/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Helpers.Effects;

import JniorProtocol.Helpers.Effects.DetailView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class BlurPane
extends JPanel {
    private DetailView detailPanel = null;
    private static final float[] elements = new float[]{0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f};
    private BufferedImage backBuffer;
    private BufferedImage blurBuffer;
    private BlurPane glassPane = this;
    private Container contentPane = null;
    private JRootPane root = null;
    private Object m_lock = null;
    private long m_timeShown = 0L;
    private boolean m_isVisible = false;

    public BlurPane() {
        this(null, null);
    }

    public BlurPane(Container container, DetailView detailView) {
        this.contentPane = container;
        this.detailPanel = detailView;
        this.setLayout(new GridBagLayout());
        this.add((Component)detailView, new GridBagConstraints());
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){});
    }

    public void createBlur() {
        this.root = SwingUtilities.getRootPane(this);
        int n = this.root.getWidth();
        int n2 = this.root.getHeight();
        this.backBuffer = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = this.backBuffer.createGraphics();
        this.root.paint(graphics2D);
        this.blurBuffer = new BufferedImage(n, n2, 1);
        graphics2D = this.blurBuffer.createGraphics();
        this.root.paint(graphics2D);
    }

    public void paintComponent(Graphics graphics) {
        if (this.isVisible() && this.blurBuffer != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Kernel kernel = new Kernel(3, 3, elements);
            ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
            convolveOp.filter(this.blurBuffer, bufferedImage);
            AffineTransformOp affineTransformOp = new AffineTransformOp(new AffineTransform(), 1);
            graphics2D.drawImage(bufferedImage, affineTransformOp, 0, 0);
        }
    }

    public void setVisibleWithLock(boolean bl, Object object) {
        if (!bl && object != this.m_lock) {
            return;
        }
        this.setVisible(bl);
        this.m_lock = object;
    }

    public void setVisible(boolean bl) {
        long l;
        if (bl && !this.isVisible()) {
            this.createBlur();
            this.m_timeShown = System.currentTimeMillis();
        }
        if (!bl && this.m_timeShown + 2000L > (l = System.currentTimeMillis())) {
            try {
                Thread.sleep(this.m_timeShown + 2000L - l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.m_isVisible = bl;
        super.setVisible(bl);
        if (this.root != null) {
            this.root.repaint();
        }
        if (!bl && this.detailPanel != null) {
            this.detailPanel.clearSubStatus();
        }
    }

    public boolean isVisible2() {
        return this.m_isVisible;
    }
}

