/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logger;

import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogOutputStream;
import com.integpg.system.JANOS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RollingLogOutputStream
extends LogOutputStream {
    public RollingLogOutputStream(LogOptions logOptions) throws FileNotFoundException {
        super(logOptions);
        if (this._bakFile.exists()) {
            if (this._file.exists()) {
                JANOS.syslog((String)("removing orphaned " + this._bakFile.getPath() + " file left during rolling log logic"));
                this._bakFile.delete();
            } else {
                JANOS.syslog((String)("saved orphaned " + this._bakFile.getPath() + " file left during rolling log logic"));
                this._bakFile.renameTo(this._file);
            }
        }
    }

    @Override
    protected int preWrite(byte[] bytes, int off, int len) throws IOException {
        if ((long)this._logOptions.getMaxFileSize() < this._file.length() + (long)len) {
            this.rollFile();
        }
        return 0;
    }

    private void rollFile() throws IOException {
        long start = System.currentTimeMillis();
        this._file.renameTo(this._bakFile);
        this.copyfile(this._bakFile, 4096, this._file, 0);
        this._bakFile.delete();
        long elapsed = System.currentTimeMillis() - start;
        System.out.println(String.format("took %lld to roll %s", elapsed, this._file.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyfile(File srcFile, int srcPos, File dstFile, int dstPos) throws IOException {
        RandomAccessFile in = null;
        RandomAccessFile out = null;
        File file = this._file;
        synchronized (file) {
            try {
                int len;
                boolean firstWrite = true;
                in = new RandomAccessFile(srcFile, "r");
                in.seek(srcPos);
                out = new RandomAccessFile(dstFile, "rw");
                out.seek(dstPos);
                byte[] buf = new byte[32768];
                while ((len = in.read(buf, 0, buf.length)) > 0) {
                    int pos = 0;
                    if (firstWrite) {
                        firstWrite = false;
                        for (int i = 0; i < len; ++i) {
                            if (10 != buf[i]) continue;
                            pos = i + 1;
                            break;
                        }
                    }
                    out.write(buf, pos, len - pos);
                }
            }
            catch (Exception ex) {
                System.err.println("Error copying file " + srcFile.getPath() + " to " + dstFile.getPath() + ": " + ex.toString());
            }
            finally {
                if (null != in) {
                    in.close();
                }
                if (null != out) {
                    out.close();
                }
            }
        }
    }
}

