/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.MinimumVersion;
import com.integpg.system.Watchdog;

public class ApplicationWatchdog
implements Runnable {
    private static final boolean REQUIRED_OS_VERSION = MinimumVersion.atLeast("ApplicationWatchdog", "1.3-b10.3");
    private Watchdog _watchdog = null;
    private Thread _thd;
    private long _lastFedTime;

    public ApplicationWatchdog(int watchdogAction) {
        if (REQUIRED_OS_VERSION) {
            this._watchdog = new Watchdog(Application.getAppInstanceName());
            this._watchdog.setAction(watchdogAction);
            AppLog.vital("Activate " + this._watchdog.getText() + " watchdog");
            this._watchdog.activate(120000);
            this._lastFedTime = System.currentTimeMillis();
        }
    }

    public void start() {
        if (null != this._watchdog && null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName(this.getClass().getName() + ":" + Application.getAppName());
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    public void join() throws InterruptedException {
        this._thd.join();
    }

    public void feed() {
        this._watchdog.refresh();
        long elapsed = System.currentTimeMillis() - this._lastFedTime;
        this._lastFedTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.feed();
                Thread.sleep(60000L);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    public void finalize() {
        AppLog.vital("Deactivate " + Application.getAppInstanceName() + " watchdog");
        this._watchdog.deactivate();
        this._watchdog.delete();
    }
}

