/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers.InterProcess;

import com.dalsemi.system.ArrayUtils;

public class InterProcessArgument {
    public static final int BYTES = 0;
    public static final int STRING = 1;
    public static final int BYTE = 10;
    public static final int SHORT = 11;
    public static final int INTEGER = 12;
    public static final int LONG = 13;
    public static final int DOUBLE = 14;
    private int m_type;
    private int m_len;
    private byte[] m_value;

    public InterProcessArgument() {
    }

    public InterProcessArgument(byte[] bytes) {
        this.m_type = 0;
        this.m_len = bytes.length;
        this.m_value = new byte[this.m_len];
        ArrayUtils.arraycopy(bytes, 0, this.m_value, 0, this.m_len);
    }

    public InterProcessArgument(String s) {
        this.m_type = 1;
        byte[] b = s.getBytes();
        this.m_len = b.length;
        this.m_value = new byte[this.m_len];
        ArrayUtils.arraycopy(b, 0, this.m_value, 0, this.m_len);
    }

    public InterProcessArgument(byte b) {
        this.m_type = 10;
        this.m_len = 1;
        this.m_value = new byte[this.m_len];
        this.m_value[0] = b;
    }

    public InterProcessArgument(short s) {
        this.m_type = 11;
        this.m_len = 2;
        this.m_value = new byte[this.m_len];
        ArrayUtils.setShort(this.m_value, 0, s);
    }

    public InterProcessArgument(int i) {
        this.m_type = 12;
        this.m_len = 4;
        this.m_value = new byte[this.m_len];
        ArrayUtils.setInt(this.m_value, 0, i);
    }

    public InterProcessArgument(long l) {
        this.m_type = 13;
        this.m_len = 8;
        this.m_value = new byte[this.m_len];
        ArrayUtils.setLong(this.m_value, 0, l);
    }

    public InterProcessArgument(double l) {
        this.m_type = 14;
        this.m_len = 8;
        this.m_value = new byte[this.m_len];
        ArrayUtils.setLong(this.m_value, 0, Double.doubleToLongBits(l));
    }

    public byte getType() {
        return (byte)this.m_type;
    }

    public int getLength() {
        return this.m_len;
    }

    public byte[] getBytes() {
        return this.m_value;
    }

    public Object getValue() {
        Object retValue = null;
        if (this.m_type == 0) {
            retValue = this.m_value;
        } else if (this.m_type == 1) {
            retValue = new String(this.m_value);
        } else if (this.m_type == 10) {
            retValue = new Byte(this.m_value[0]);
        } else if (this.m_type == 11) {
            retValue = new Short(ArrayUtils.getShort(this.m_value, 0));
        } else if (this.m_type == 12) {
            retValue = new Integer(ArrayUtils.getInt(this.m_value, 0));
        } else if (this.m_type == 13) {
            retValue = new Long(ArrayUtils.getLong(this.m_value, 0));
        } else if (this.m_type == 14) {
            long longBits = ArrayUtils.getLong(this.m_value, 0);
            retValue = new Double(Double.longBitsToDouble(longBits));
        }
        return retValue;
    }

    public void parse(byte[] bytes, int pos) {
        this.m_type = bytes[pos++];
        this.m_len = ArrayUtils.getShort(bytes, pos);
        this.m_value = new byte[this.m_len];
        ArrayUtils.arraycopy(bytes, pos += 2, this.m_value, 0, this.m_len);
    }
}

