/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.io;

import com.integpg.janoslib.io.Log;
import com.integpg.janoslib.io.RollingMemoryLogService;
import com.integpg.janoslib.utils.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;

public class RollingMemoryLog
extends Log {
    private final File _file;
    private final File _bakFile;
    private final int _maxSize;
    private final int _clusterSize = 1024;
    private final ByteArrayOutputStream _memoryOut = new ByteArrayOutputStream();
    private final StringBuilder _pendingText = new StringBuilder();
    private boolean _loaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollingMemoryLog getLog(String filename, int maxSize) {
        Hashtable hashtable = LogsCache;
        synchronized (hashtable) {
            filename = filename.toLowerCase();
            if (!LogsCache.containsKey(filename)) {
                System.out.println("rolling memory log file: " + filename + " with max size of " + maxSize);
                RollingMemoryLog rollingMemoryLog = new RollingMemoryLog(filename, maxSize);
                LogsCache.put(filename, rollingMemoryLog);
            }
            return (RollingMemoryLog)LogsCache.get(filename);
        }
    }

    private RollingMemoryLog(String filename, int maxSize) {
        super(filename);
        this._file = new File(filename);
        this._bakFile = new File(filename + ".bak");
        this._maxSize = maxSize;
    }

    private void loadFile() throws IOException {
        if (this._file.exists()) {
            long start = System.currentTimeMillis();
            this._memoryOut.write(FileUtils.readAllBytes(this._file.getPath()));
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("loaded " + this._file.getPath() + " in " + (double)elapsed / 1000.0);
        } else if (this._bakFile.exists()) {
            long start = System.currentTimeMillis();
            this._memoryOut.write(FileUtils.readAllBytes(this._bakFile.getPath()));
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("loaded " + this._bakFile.getPath() + " in " + (double)elapsed / 1000.0);
            this._bakFile.delete();
        }
        this._loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void logEntry() {
        try {
            StringBuilder stringBuilder = this._pendingText;
            synchronized (stringBuilder) {
                if (!this._loaded) {
                    this.loadFile();
                }
                if (0 < this._pendingText.length()) {
                    byte[] pendingBytes = this._pendingText.toString().getBytes();
                    this._pendingText.setLength(0);
                    this._memoryOut.write(pendingBytes);
                    RandomAccessFile raf = null;
                    try {
                        if (this._maxSize > this._memoryOut.size()) {
                            raf = new RandomAccessFile(this._file, "rw");
                            raf.seek(raf.length());
                            raf.write(pendingBytes);
                        } else {
                            byte[] fileInMemory = this._memoryOut.toByteArray();
                            int pos = fileInMemory.length - this._maxSize;
                            if (1024 > pos) {
                                pos = 1024;
                            }
                            while (fileInMemory.length > pos && 10 != fileInMemory[pos++]) {
                            }
                            this._memoryOut.reset();
                            this._memoryOut.write(fileInMemory, pos, fileInMemory.length - pos);
                            this._file.renameTo(this._bakFile);
                            raf = new RandomAccessFile(this._file, "rw");
                            raf.write(this._memoryOut.toByteArray());
                            this._bakFile.delete();
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("error logging to " + super.getFilename());
                        ex.printStackTrace();
                    }
                    finally {
                        try {
                            if (null != raf) {
                                raf.close();
                            }
                        }
                        catch (Exception ex2) {}
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeln(String string) {
        try {
            long now = System.currentTimeMillis();
            if (super.getEcho()) {
                System.out.println(string);
            }
            StringBuilder stringBuilder = this._pendingText;
            synchronized (stringBuilder) {
                if (super.getIncludeDate()) {
                    this._pendingText.append(this._dateFormat.format(now));
                    this._pendingText.append(", ");
                }
                this._pendingText.append(string);
                this._pendingText.append("\r\n");
            }
            RollingMemoryLogService.addWaitingLog(this);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    protected void preFileWrite(String s) {
    }

    @Override
    protected void postFileWrite() {
    }
}

