/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices.Externals;

import JniorProtocol.Devices.Externals.Externals;
import JniorProtocol.JniorSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ExternalTemperature
extends Externals {
    private double m_tempC;

    public ExternalTemperature(JniorSession jniorSession, long l) {
        super(jniorSession, l);
        this.m_description = "Temperature Probe";
    }

    public double getCelsius() {
        return this.m_tempC;
    }

    public double getFahrenheit() {
        return this.m_tempC * 9.0 / 5.0 + 32.0;
    }

    public void receive(ByteArrayInputStream byteArrayInputStream) {
        try {
            this.m_tempC = ExternalTemperature.getDouble(byteArrayInputStream);
            this.fireStateChange();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean compareTo(Object object) {
        return true;
    }

    public String toString() {
        return this.m_hexAddress + " : " + this.m_description + " : " + this.getCelsius() + " C, " + this.getFahrenheit() + " F";
    }
}

