/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers.InterProcess;

import com.dalsemi.system.TINIOS;
import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.EmbeddedHelpers.InterProcess.InterProcessArgument;
import com.integpg.EmbeddedHelpers.InterProcess.InterProcessEntry;
import com.integpg.EmbeddedHelpers.InterProcess.InterProcessEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.EventObject;
import java.util.Hashtable;

public class InterProcessConnection
implements Runnable {
    private Socket clientSocket = null;
    private DataInputStream in = null;
    private DataOutputStream out = null;
    private Thread thread = null;
    private boolean quit = false;
    private static Hashtable eventHooks = new Hashtable();
    private boolean isServer = false;

    public InterProcessConnection(String host, int port) throws UnknownHostException, IOException {
        this(new Socket(host, port), false);
    }

    public InterProcessConnection(Socket socket, boolean isServer) throws UnknownHostException, IOException {
        this.clientSocket = socket;
        this.in = new DataInputStream(this.clientSocket.getInputStream());
        this.out = new DataOutputStream(this.clientSocket.getOutputStream());
        this.isServer = isServer;
    }

    public void register(String command, InterProcessEvent ipce) throws Exception {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Inter-Process Connection");
            this.thread.start();
        }
        if (!this.isServer) {
            InterProcessArgument[] args = new InterProcessArgument[]{new InterProcessArgument(command)};
            this.writeEntry("register_app", args);
        }
        if (!eventHooks.contains(command)) {
            eventHooks.put(command, ipce);
        }
    }

    public void setLocalHook(String command, InterProcessEvent ipce) throws Exception {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Inter-Process Connection");
            this.thread.start();
        }
        if (!eventHooks.contains(command)) {
            eventHooks.put(command, ipce);
        }
    }

    private InterProcessEntry readEntry() throws EOFException, IOException {
        InterProcessEntry ipce = new InterProcessEntry();
        ipce.parse(this.in);
        return ipce;
    }

    public InterProcessEntry writeEntry(String command, InterProcessArgument[] args) {
        InterProcessEntry ipce = new InterProcessEntry(TINIOS.getTaskID(), -1);
        try {
            ipce.setData(command, args);
            this.out.write(ipce.getBytes());
            this.out.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ipce;
    }

    @Override
    public void run() {
        while (!this.quit) {
            try {
                InterProcessEntry ipce = this.readEntry();
                if (ipce != null) {
                    InterProcessEvent event;
                    if (eventHooks.containsKey(ipce.m_commandName)) {
                        event = (InterProcessEvent)eventHooks.get(ipce.m_commandName);
                        event.onInterProcessEvent(new EventObject(this), ipce.m_commandName, ipce.m_arguments);
                    } else if (eventHooks.containsKey("register_app")) {
                        event = (InterProcessEvent)eventHooks.get("register_app");
                        event.onInterProcessEvent(new EventObject(this), ipce.m_commandName, ipce.m_arguments);
                    }
                }
                Thread.sleep(500L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    this.release();
                }
                catch (Exception ex2) {
                    ex.printStackTrace();
                }
                break;
            }
        }
    }

    public void release() throws Exception {
        try {
            this.quit = true;
            this.in.close();
            this.out.close();
            this.clientSocket.close();
            this.in = null;
            this.out = null;
            this.clientSocket = null;
            this.thread.join(10000L);
            EmbeddedBase.BASE.gc();
            if (eventHooks.containsKey("unregister_app")) {
                InterProcessEvent event = (InterProcessEvent)eventHooks.get("unregister_app");
                System.out.println("Alert Unregister Listener " + event.getClass().getName());
                event.onInterProcessEvent(new EventObject(this), "unregister_app", null);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

