/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public final class ExceptionHandler
extends ThreadGroup {
    private static final StringBuffer sbException = new StringBuffer();
    private static final StringWriter sw = new StringWriter(1024);
    private static final PrintWriter out = new PrintWriter((Writer)sw, false);
    private static final StringBuffer sbStackTrace = new StringBuffer();

    public ExceptionHandler() {
        super("Exception Handler");
    }

    public static void attachUncaughtHandler(Runnable runnable) {
        Thread thd = new Thread(new ExceptionHandler(), runnable, "Uncaught Exception Handler");
        thd.start();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        ExceptionHandler.logException(-1, e);
    }

    public static synchronized String getRelevantStackTrace(Throwable tracer) {
        sw.getBuffer().setLength(0);
        sbStackTrace.setLength(0);
        String exceptionClass = tracer.getClass().getName();
        tracer.fillInStackTrace();
        tracer.printStackTrace(out);
        String m = tracer.getMessage();
        if (m != null) {
            sbStackTrace.append(m);
        }
        BufferedReader in = new BufferedReader(new StringReader(sw.toString()));
        try {
            String result;
            boolean skip = false;
            while ((result = in.readLine()) != null) {
                if (result.indexOf(exceptionClass) >= 0) {
                    skip = false;
                }
                if (skip) continue;
                if (sbStackTrace.length() != 0) {
                    sbStackTrace.append(' ');
                }
                sbStackTrace.append(result.trim());
            }
            return sbStackTrace.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static synchronized void logException(int code, Throwable t) {
        ExceptionHandler.logException(code, null, t);
    }

    public static synchronized void logException(int code, String desc, Throwable t) {
        sbException.setLength(0);
        if (code < 0) {
            sbException.append("Uncaught Exception: ");
        } else {
            sbException.append("Exception: (");
            sbException.append(code);
            sbException.append(") ");
        }
        if (desc != null) {
            sbException.append("[");
            sbException.append(desc);
            sbException.append("] ");
        }
        sbException.append(ExceptionHandler.getRelevantStackTrace(t));
        sbException.append(" in Thread: " + Thread.currentThread().getName());
        String str = sbException.toString();
        EmbeddedBase.BASE.log(str);
        System.out.println(str);
    }
}

