/*
 * Decompiled with CFR 0.152.
 */
package integpg.EmbeddedHelpers.Base;

import com.integpg.system.JANOS;
import integpg.EmbeddedHelpers.Base.RegistryModifiedListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ConfigBase
implements Runnable {
    private static final String EMPTY_STRING = "";
    private Thread thd;
    private boolean quit = false;
    private Hashtable subscribedKeys;
    private Vector _listeners = new Vector();
    private boolean _paused = false;

    public abstract void getConfig() throws IOException;

    public static String getRegistryKey(String string, String string2) {
        String string3 = JANOS.getRegistryString((String)string, (String)EMPTY_STRING);
        if (string3.equals(EMPTY_STRING)) {
            string3 = string2;
            JANOS.setSystemKey((String)string, (String)string3);
        }
        return string3;
    }

    public static String[] getRegistryKeys(String string, String string2) {
        String[] stringArray = null;
        stringArray = JANOS.getRegistryKey((String)string);
        if (stringArray == null || stringArray.length == 0) {
            JANOS.setSystemKey((String)string, (String)string2);
            stringArray = JANOS.getRegistryKey((String)string);
        }
        return stringArray;
    }

    public static boolean getRegistryKey(String string, boolean bl) {
        boolean bl2 = JANOS.getRegistryBoolean((String)string, (boolean)bl);
        if (bl2 == bl) {
            JANOS.setSystemKey((String)string, (String)String.valueOf(bl2));
        }
        return bl2;
    }

    public static double getRegistryKey(String string, double d) {
        double d2 = JANOS.getRegistryDouble((String)string, (double)Double.MIN_VALUE);
        if (d2 == Double.MIN_VALUE) {
            d2 = d;
            JANOS.setSystemKey((String)string, (String)Double.toString(d2));
        }
        return d2;
    }

    public static int getRegistryKey(String string, int n) {
        int n2 = JANOS.getRegistryInt((String)string, (int)Integer.MIN_VALUE);
        if (n2 == Integer.MIN_VALUE) {
            n2 = n;
            JANOS.setSystemKey((String)string, (String)Integer.toString(n2));
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToKey(String string, RegistryModifiedListener registryModifiedListener) {
        if (!this._listeners.contains(registryModifiedListener)) {
            this._listeners.addElement(registryModifiedListener);
        }
        long l = JANOS.getRegistryLastModified((String)string);
        if (this.subscribedKeys == null) {
            this.subscribedKeys = new Hashtable();
        }
        Hashtable hashtable = this.subscribedKeys;
        synchronized (hashtable) {
            this.subscribedKeys.put(string, new Long(l));
        }
        if (this.thd == null) {
            this.thd = new Thread((Runnable)this, "Monitor Registry Subscriptions");
            this.thd.setDaemon(true);
            this.thd.start();
        }
    }

    public void stop() {
        try {
            if (this.thd != null) {
                this.quit = true;
                this.thd.interrupt();
                this.thd.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void pause() {
        this._paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ConfigBase configBase = this;
        synchronized (configBase) {
            this._paused = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.quit) {
            Object object;
            if (this._paused) {
                object = this;
                synchronized (object) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            object = this.subscribedKeys;
            synchronized (object) {
                Enumeration enumeration = this.subscribedKeys.keys();
                while (enumeration.hasMoreElements()) {
                    long l;
                    String string = (String)enumeration.nextElement();
                    long l2 = JANOS.getRegistryLastModified((String)string);
                    if (l2 <= (l = ((Long)this.subscribedKeys.get(string)).longValue())) continue;
                    int n = this._listeners.size();
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            RegistryModifiedListener registryModifiedListener = (RegistryModifiedListener)this._listeners.elementAt(i);
                            registryModifiedListener.registryModified(string);
                        }
                    }
                    this.subscribedKeys.put(string, new Long(l2));
                }
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

