/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import com.integpg.net.FTPClient;
import ftp.CommandLine;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class Ftp {
    PrintStream out = System.out;
    CommandLine cmdline = new CommandLine();
    FTPClient client = new FTPClient();
    boolean secure = false;
    boolean verbose = false;
    boolean help = false;
    String server = null;

    public static void main(String[] args) {
        Ftp ftp = new Ftp(args);
        try {
            ftp.run();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private Ftp(String[] args) {
        for (int n = 0; n < args.length; ++n) {
            if (args[n].toLowerCase().compareTo("-p") == 0) {
                this.secure = true;
                continue;
            }
            if (args[n].toLowerCase().compareTo("-v") == 0) {
                this.verbose = true;
                continue;
            }
            if (args[n].compareTo("?") == 0 || args[n].toLowerCase().compareTo("help") == 0) {
                this.help = true;
                continue;
            }
            if (this.server == null && args[n].charAt(0) != '-') {
                this.server = args[n];
                continue;
            }
            this.help = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void run() throws IOException {
        if (!this.help && this.secure) {
            this.out.println("connections will be secure.");
        }
        while (true) {
            int nread;
            char[] bufr;
            FileReader file;
            File temp;
            block52: {
                StringTokenizer tok;
                String line;
                if (this.help) {
                    line = "help";
                } else if (this.server != null) {
                    line = "open " + this.server;
                    this.server = null;
                } else {
                    line = this.cmdline.getLine("ftp> ");
                }
                if (!(tok = new StringTokenizer(line, " ")).hasMoreTokens()) continue;
                String cmd = tok.nextToken().toLowerCase();
                if (!(cmd.compareTo("bye") == 0 && !tok.hasMoreTokens() || cmd.compareTo("quit") == 0 && !tok.hasMoreTokens() || cmd.compareTo("exit") == 0 && !tok.hasMoreTokens())) {
                    if (cmd.compareTo("?") == 0 || cmd.compareTo("help") == 0) {
                        this.out.println("command line:");
                        this.out.println("FTP [-P] [-V] [server]\r\n");
                        this.out.println("  -P       use secure connections");
                        this.out.println("  -V       verbose mode");
                        this.out.println("  server   open this server\r\n");
                        this.out.println("commands:");
                        this.out.println("ascii           : ascii data mode");
                        this.out.println("binary          : binary data mode");
                        this.out.println("cat FILE        : display remote file content");
                        this.out.println("close           : disconnect");
                        this.out.println("cd DIR          : change directory to DIR");
                        this.out.println("delete FILE     : delete remote FILE");
                        this.out.println("dir, ls         : list directory content");
                        this.out.println("get REMF FILE   : get remote file REMF as local FILE");
                        this.out.println("help, ?         : display this");
                        this.out.println("mkdir DIR       : create remote directory DIR");
                        this.out.println("open SERVER     : connect to SERVER");
                        this.out.println("plain           : use unsecured communications (default)");
                        this.out.println("put FILE REMF   : put local FILE as remote file REMF");
                        this.out.println("pwd             : print current directory");
                        this.out.println("rmdir DIR       : remove remote directory DIR");
                        this.out.println("secure          : use STARTTLS if available");
                        this.out.println("verbose         : display connection log detail");
                        this.out.println("\r\nbye, exit, quit : end session");
                        if (!this.help) continue;
                    } else {
                        block51: {
                            if (cmd.compareTo("open") == 0 && tok.hasMoreTokens()) {
                                if (this.client.isConnected()) {
                                    this.out.println("already connected.");
                                    continue;
                                }
                                this.client.resetLog();
                                if (!this.client.connect(tok.nextToken())) continue;
                                if (this.verbose) {
                                    this.out.println(this.client.getLog());
                                }
                                if (this.secure && !this.client.auth()) {
                                    this.out.println("secure connection not available.");
                                    this.client.close();
                                    continue;
                                }
                                String username = this.cmdline.getLine("User: ");
                                String password = this.cmdline.getLine("Password: ", false);
                                this.client.resetLog();
                                if (!this.client.login(username, password)) {
                                    this.client.close();
                                }
                                if (this.verbose) {
                                    this.out.println(this.client.getLog());
                                    continue;
                                }
                                this.out.println("connected.");
                                continue;
                            }
                            if (cmd.compareTo("verbose") == 0 && !tok.hasMoreTokens()) {
                                this.verbose = true;
                                continue;
                            }
                            if (cmd.compareTo("ascii") == 0 && !tok.hasMoreTokens()) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.out.println(this.client.type("A"));
                                continue;
                            }
                            if (cmd.compareTo("binary") == 0 && !tok.hasMoreTokens()) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.out.println(this.client.type("I"));
                                continue;
                            }
                            if (cmd.compareTo("secure") == 0 && !tok.hasMoreTokens()) {
                                if (this.client.isConnected()) {
                                    this.out.println("disconnect first.");
                                    continue;
                                }
                                this.out.println("connections will be secure.");
                                this.secure = true;
                                continue;
                            }
                            if (cmd.compareTo("plain") == 0 && !tok.hasMoreTokens()) {
                                if (this.client.isConnected()) {
                                    this.out.println("disconnect first.");
                                    continue;
                                }
                                this.out.println("unsecured connections will be used.");
                                this.secure = false;
                                continue;
                            }
                            if (cmd.compareTo("close") == 0 && !tok.hasMoreTokens()) {
                                if (!this.client.isConnected()) continue;
                                this.out.println(this.client.quit());
                                this.client.close();
                                continue;
                            }
                            if (!(cmd.compareTo("dir") != 0 && cmd.compareTo("ls") != 0 || tok.hasMoreTokens())) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    break block51;
                                } else {
                                    this.client.resetLog();
                                    String listing = this.client.dir(false);
                                    if (this.verbose) {
                                        this.out.println(this.client.getLog());
                                    }
                                    this.out.println(listing);
                                    continue;
                                }
                            }
                            if (cmd.compareTo("pwd") == 0 && !tok.hasMoreTokens()) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.out.println(this.client.pwd());
                                continue;
                            }
                            if (cmd.compareTo("cd") == 0 && tok.countTokens() == 1) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.out.println(this.client.cwd(tok.nextToken()));
                                continue;
                            }
                            if (cmd.compareTo("cat") == 0 && tok.countTokens() == 1) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.client.resetLog();
                                if (this.client.retrieve("/temp/content.$$$", tok.nextToken())) {
                                    if (this.verbose) {
                                        this.out.println(this.client.getLog());
                                    }
                                    temp = new File("/temp/content.$$$");
                                    file = new FileReader(temp);
                                    bufr = new char[1024];
                                    break block52;
                                } else {
                                    this.out.println(this.client.getLog());
                                    continue;
                                }
                            }
                            if (cmd.compareTo("get") == 0 && tok.countTokens() == 2) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.client.resetLog();
                                String remfile = tok.nextToken();
                                this.client.retrieve(tok.nextToken(), remfile);
                                this.out.println(this.client.getLog());
                                continue;
                            }
                            if (cmd.compareTo("put") == 0 && tok.countTokens() == 2) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.client.resetLog();
                                this.client.store(tok.nextToken(), tok.nextToken());
                                this.out.println(this.client.getLog());
                                continue;
                            }
                            if (cmd.compareTo("delete") == 0 && tok.countTokens() == 1) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.client.resetLog();
                                this.client.delete(tok.nextToken());
                                this.out.println(this.client.getLog());
                                continue;
                            }
                            if (cmd.compareTo("mkdir") == 0 && tok.countTokens() == 1) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.client.resetLog();
                                this.client.mkdir(tok.nextToken());
                                this.out.println(this.client.getLog());
                                continue;
                            }
                            if (cmd.compareTo("rmdir") == 0 && tok.countTokens() == 1) {
                                if (!this.client.isConnected()) {
                                    this.out.println("not connected.");
                                    continue;
                                }
                                this.client.resetLog();
                                this.client.rmdir(tok.nextToken());
                                this.out.println(this.client.getLog());
                                continue;
                            }
                        }
                        this.out.println("invalid command.");
                        continue;
                    }
                }
                if (this.client.isConnected()) {
                    this.out.println(this.client.quit());
                    this.client.close();
                }
                return;
            }
            while ((nread = file.read(bufr, 0, 1024)) >= 0) {
                if (nread == 1024) {
                    this.out.print(bufr);
                    continue;
                }
                this.out.print(new String(bufr, 0, nread));
            }
            file.close();
            temp.delete();
        }
    }
}

