/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.threading.timers;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.threading.timers.TimerTask;
import java.util.Vector;

public class RepeatingTask
extends TimerTask {
    private long _interval;
    private final Vector<Runnable> _timerTasks = new Vector();

    public RepeatingTask(String name, long interval) {
        super(name);
        this._interval = interval;
        this._nextExecutionTime = System.currentTimeMillis() + this._interval;
        this.updateExecutionTime();
    }

    public RepeatingTask(String name, long interval, long startTime) {
        super(name);
        if (0L >= interval) {
            throw new RuntimeException("Repeating Task Interval must be greater than zero");
        }
        this._interval = interval;
        this._nextExecutionTime = startTime;
        this.updateExecutionTime();
    }

    public void setInterval(long interval) {
        this._interval = interval;
    }

    @Override
    public boolean isDone() {
        return this._cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepeatingTask addRunnable(Runnable runnable) {
        Vector<Runnable> vector = this._timerTasks;
        synchronized (vector) {
            this._timerTasks.addElement(runnable);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector<Runnable> vector = this._timerTasks;
        synchronized (vector) {
            for (int i = 0; i < this._timerTasks.size(); ++i) {
                try {
                    Runnable runnable = this._timerTasks.elementAt(i);
                    runnable.run();
                    continue;
                }
                catch (Exception ex) {
                    AppLog.error("Error executing timer task", ex);
                }
            }
        }
    }

    @Override
    public void updateExecutionTime() {
        if (-1L == this._nextExecutionTime) {
            this._nextExecutionTime = System.currentTimeMillis();
        } else {
            while (System.currentTimeMillis() > this._nextExecutionTime) {
                this._nextExecutionTime += this._interval;
            }
        }
    }
}

