/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.TaskManager.OneWireEventListener;
import com.integpg.TaskManager.externals.ExternalModuleInfo;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class OneWireMonitor {
    private static Thread _thd;
    private static boolean _quit;
    private static Hashtable<String, ExternalModuleInfo> _deviceHash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllDevices() {
        Hashtable<String, ExternalModuleInfo> hashtable = _deviceHash;
        synchronized (hashtable) {
            _deviceHash.clear();
            _deviceHash = new Hashtable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOneWireDevice(ExternalModuleInfo externalModuleInfo, OneWireEventListener listener) {
        try {
            Hashtable<String, ExternalModuleInfo> hashtable = _deviceHash;
            synchronized (hashtable) {
                String addressString = externalModuleInfo.getAddressString();
                if (null == externalModuleInfo) {
                    throw new RuntimeException("Invalid External Address: " + addressString);
                }
                if (!_deviceHash.containsKey(addressString)) {
                    _deviceHash.put(addressString, externalModuleInfo);
                } else {
                    externalModuleInfo = _deviceHash.get(addressString);
                }
                System.out.println("add " + listener + " to " + externalModuleInfo.Listeners);
                externalModuleInfo.Listeners.addElement(listener);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void monitorOneWireDevices() {
        if (_thd == null || !_thd.isAlive()) {
            _thd = new Thread(new Runnable(){

                @Override
                public void run() {
                    _quit = false;
                    OneWireMonitor.mainLoop();
                }
            }, "One Wire Monitor");
            _thd.setDaemon(true);
            _thd.start();
        }
    }

    public static void stopMonitoringOneWireDevices() {
        _quit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mainLoop() {
        try {
            EmbeddedBase.BASE.printInfo("One Wire Monitor Started");
            while (!_quit) {
                Hashtable<String, ExternalModuleInfo> hashtable = _deviceHash;
                synchronized (hashtable) {
                    Enumeration<ExternalModuleInfo> deviceEnum = _deviceHash.elements();
                    while (deviceEnum.hasMoreElements()) {
                        ExternalModuleInfo externalModuleInfo = deviceEnum.nextElement();
                        try {
                            externalModuleInfo.refreshDevice();
                            if (!externalModuleInfo.hasDeviceChanged()) continue;
                            for (int i = 0; i < externalModuleInfo.Listeners.size(); ++i) {
                                OneWireEventListener listener = (OneWireEventListener)externalModuleInfo.Listeners.elementAt(i);
                                listener.OneWireChangeEvent();
                            }
                        }
                        catch (IOException ex) {
                            System.out.println("error reading " + externalModuleInfo.getAddressString());
                            ex.printStackTrace();
                        }
                    }
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        EmbeddedBase.BASE.printInfo("One Wire Monitor Stopped");
    }

    public static long parseHex(String s) {
        if (s == null || s.length() != 16) {
            return 0L;
        }
        long l = Long.parseLong(s.substring(0, 8), 16);
        l <<= 32;
        return l += Long.parseLong(s.substring(8), 16);
    }

    static {
        _quit = false;
        _deviceHash = new Hashtable();
    }
}

