/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Helpers.FTP;

import JniorProtocol.Helpers.Debug.Debug;
import JniorProtocol.Helpers.FTP.FtpListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.StringTokenizer;

public class SimpleFTP {
    FtpListener listener = null;
    private Socket socket = null;
    private BufferedReader reader = null;
    private BufferedWriter writer = null;
    private static boolean DEBUG = false;

    public void setListener(FtpListener ftpListener) {
        this.listener = ftpListener;
    }

    public synchronized void connect(String string) throws IOException {
        this.connect(string, 21);
    }

    public synchronized void connect(String string, int n) throws IOException {
        this.connect(string, n, "anonymous", "anonymous");
    }

    public synchronized void connect(String string, int n, String string2, String string3) throws IOException {
        if (this.listener != null) {
            this.listener.onConnect();
        }
        if (this.socket != null) {
            throw new IOException("SimpleFTP is already connected. Disconnect first.");
        }
        this.socket = new Socket(string, n);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        String string4 = this.readLine();
        if (!string4.startsWith("220 ")) {
            throw new IOException("SimpleFTP received an unknown response when connecting to the FTP server: " + string4);
        }
        if (this.listener != null) {
            this.listener.onLogin();
        }
        this.sendLine("USER " + string2);
        string4 = this.readLine();
        if (!string4.startsWith("331 ")) {
            throw new IOException("SimpleFTP received an unknown response after sending the user: " + string4);
        }
        this.sendLine("PASS " + string3);
        string4 = this.readLine();
        if (!string4.startsWith("230 ")) {
            throw new IOException("SimpleFTP was unable to log in with the supplied password: " + string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() throws IOException {
        try {
            if (this.listener != null) {
                this.listener.onDisconnect();
            }
            this.sendLine("QUIT");
        }
        finally {
            this.socket = null;
        }
    }

    public synchronized String pwd() throws IOException {
        int n;
        int n2;
        this.sendLine("PWD");
        String string = null;
        String string2 = this.readLine();
        if (string2.startsWith("257 ") && (n2 = string2.indexOf(34, (n = string2.indexOf(34)) + 1)) > 0) {
            string = string2.substring(n + 1, n2);
        }
        return string;
    }

    public synchronized boolean cwd(String string) throws IOException {
        this.sendLine("CWD " + string);
        String string2 = this.readLine();
        return string2.startsWith("250 ");
    }

    public synchronized boolean stor(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("SimpleFTP cannot upload a directory.");
        }
        String string = file.getName();
        long l = file.length();
        return this.stor(new FileInputStream(file), string, l);
    }

    public synchronized boolean stor(InputStream inputStream, String string, long l) throws IOException {
        Object object;
        Object object2;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        this.sendLine("PASV");
        String string2 = this.readLine();
        if (!string2.startsWith("227 ")) {
            throw new IOException("SimpleFTP could not request passive mode: " + string2);
        }
        String string3 = null;
        int n = -1;
        int n2 = string2.indexOf(40);
        int n3 = string2.indexOf(41, n2 + 1);
        if (n3 > 0) {
            object2 = string2.substring(n2 + 1, n3);
            object = new StringTokenizer((String)object2, ",");
            try {
                string3 = ((StringTokenizer)object).nextToken() + "." + ((StringTokenizer)object).nextToken() + "." + ((StringTokenizer)object).nextToken() + "." + ((StringTokenizer)object).nextToken();
                n = Integer.parseInt(((StringTokenizer)object).nextToken()) * 256 + Integer.parseInt(((StringTokenizer)object).nextToken());
            }
            catch (Exception exception) {
                throw new IOException("SimpleFTP received bad data link information: " + string2);
            }
        }
        this.sendLine("STOR " + string);
        object2 = new Socket(string3, n);
        string2 = this.readLine();
        if (!string2.startsWith("125 ") && !string2.startsWith("150 ")) {
            throw new IOException("SimpleFTP was not allowed to send the file: " + string2);
        }
        object = new BufferedOutputStream(((Socket)object2).getOutputStream());
        byte[] byArray = new byte[4096];
        int n4 = 0;
        int n5 = 0;
        while ((n4 = bufferedInputStream.read(byArray)) != -1) {
            ((BufferedOutputStream)object).write(byArray, 0, n4);
            n5 += n4;
            if (this.listener == null) continue;
            this.listener.onStoreUpdate((int)((double)n5 / (double)l * 100.0));
        }
        ((BufferedOutputStream)object).flush();
        ((FilterOutputStream)object).close();
        bufferedInputStream.close();
        string2 = this.readLine();
        return string2.startsWith("226 ");
    }

    public synchronized boolean bin() throws IOException {
        this.sendLine("TYPE I");
        String string = this.readLine();
        return string.startsWith("200 ");
    }

    public synchronized boolean ascii() throws IOException {
        this.sendLine("TYPE A");
        String string = this.readLine();
        return string.startsWith("200 ");
    }

    private void sendLine(String string) throws IOException {
        if (this.socket == null) {
            throw new IOException("SimpleFTP is not connected.");
        }
        try {
            this.writer.write(string + "\r\n");
            this.writer.flush();
            if (DEBUG) {
                Debug.log("> " + string);
            }
        }
        catch (IOException iOException) {
            this.socket = null;
            throw iOException;
        }
    }

    private String readLine() throws IOException {
        String string = this.reader.readLine();
        if (DEBUG) {
            Debug.log("< " + string);
        }
        return string;
    }
}

