/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers;

import com.dalsemi.system.TINIOS;
import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ThreadWatchdog
implements Runnable {
    private static ThreadWatchdog _instance = null;
    private Thread _thd = null;
    private boolean _stopThread = false;
    private Hashtable _threads = new Hashtable();
    private Vector _removeThreads = new Vector();

    private ThreadWatchdog() {
    }

    public static ThreadWatchdog getInstance() {
        return _instance;
    }

    public void addThread(Thread thd) {
        this._threads.put(thd, new ThreadInfo());
    }

    public void feedWatchdog() {
        ThreadInfo thdInfo = (ThreadInfo)this._threads.get(Thread.currentThread());
        if (thdInfo != null) {
            thdInfo.Watchdog = TINIOS.uptimeMillis();
        }
    }

    public void start() {
        this._thd = new Thread((Runnable)this, "ThreadWatchdog");
        this._thd.start();
    }

    public void stop() {
        this._stopThread = true;
        this._thd.interrupt();
        try {
            this._thd.join();
        }
        catch (InterruptedException ex) {
            EmbeddedBase.BASE.logError("Error stopping ThreadWatchdog", ex);
        }
    }

    @Override
    public void run() {
        this.addThread(this._thd);
        while (!this._stopThread) {
            if (this._threads.size() > 0) {
                try {
                    Enumeration threads = this._threads.keys();
                    while (threads.hasMoreElements()) {
                        Thread thd = (Thread)threads.nextElement();
                        ThreadInfo thdInfo = (ThreadInfo)this._threads.get(thd);
                        System.out.println(thd.getName() + " alive? " + thd.isAlive() + "   " + (TINIOS.uptimeMillis() - thdInfo.Watchdog));
                        if (!thd.isAlive()) {
                            System.out.println("Thread: " + thd.getName() + " has died!");
                            this._removeThreads.addElement(thd);
                            continue;
                        }
                        if (TINIOS.uptimeMillis() - thdInfo.Watchdog <= 20000L) continue;
                        System.out.println("Thread: " + thd.getName() + " is too busy?");
                    }
                    while (this._removeThreads.size() > 0) {
                        this._threads.remove(this._removeThreads.elementAt(0));
                        this._removeThreads.removeElementAt(0);
                    }
                    this.feedWatchdog();
                }
                catch (Exception ex) {
                    EmbeddedBase.BASE.logError("Error in ThreadWatchdog", ex);
                }
                if (!this._thd.isAlive()) {
                    // empty if block
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                EmbeddedBase.BASE.logError("", ex);
            }
        }
    }

    static {
        _instance = new ThreadWatchdog();
    }

    class ThreadInfo {
        public int Inportance = 0;
        public long Watchdog = TINIOS.uptimeMillis();

        ThreadInfo() {
        }
    }
}

