/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager.Event;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.TaskManager.Logic;
import java.io.IOException;
import java.util.StringTokenizer;

public class EventData
implements Cloneable {
    public String name;
    public long time;
    public long endTime = -1L;
    public int daysMask;
    public String action;
    public String[] actions = new String[50];
    public int actionCount = 0;
    public boolean recurring = false;
    public long interval;
    public String type;
    public String eventBasedType;
    public int eventIoNumber;
    public int middleNumber;
    public int miscNumber = 0;
    public String _logicalExpression;
    public Logic _logic;

    public EventData() {
    }

    public EventData(String name, String time, String action) {
        this.name = name;
    }

    public Object clone() {
        EventData ed = new EventData();
        ed.name = this.name;
        ed.time = this.time;
        ed.endTime = this.endTime;
        ed.daysMask = this.daysMask;
        ed.action = this.action;
        ed.recurring = this.recurring;
        ed.interval = this.interval;
        ed.type = this.type;
        ed.eventBasedType = this.eventBasedType;
        ed.eventIoNumber = this.eventIoNumber;
        ed.middleNumber = this.middleNumber;
        ed.actionCount = this.actionCount;
        ed.miscNumber = this.miscNumber;
        ed.actions = new String[this.actions.length];
        for (int i = 0; i < this.actions.length; ++i) {
            ed.actions[i] = this.actions[i];
        }
        ed._logicalExpression = this._logicalExpression;
        ed._logic = this._logic;
        return ed;
    }

    public EventData getData() {
        try {
            String newName = new String();
            StringTokenizer st = new StringTokenizer(this.name);
            while (st.hasMoreTokens()) {
                newName = newName + st.nextToken();
            }
            String prefix = "Schedule/Events/" + newName + "/";
            this.time = EventData.getTimeFromString(EmbeddedBase.BASE.m_jnioros.getRegistryString(prefix + "Time", "00:00:00"));
            this.endTime = EventData.getTimeFromString(EmbeddedBase.BASE.m_jnioros.getRegistryString(prefix + "EndTime", "00:00:00"));
            if (this.endTime == 0L) {
                this.endTime = -1L;
            }
            this.action = "";
            String[] regActions = EmbeddedBase.BASE.m_jnioros.getRegistryKey(prefix + "Action");
            if (regActions != null && regActions.length > 0) {
                for (int i = 0; i < regActions.length; ++i) {
                    if (!this.action.equals("")) {
                        this.action = this.action + ",";
                    }
                    this.action = this.action + regActions[i];
                }
            } else {
                this.action = "Nothing";
            }
            System.out.println("action: " + this.action);
            if (this.action.equals("Nothing")) {
                return null;
            }
            int lastPos = 0;
            int pos = this.action.indexOf(";;", lastPos);
            while (pos > 0 && this.actionCount < this.actions.length) {
                this.actions[this.actionCount++] = this.action.substring(lastPos, pos).trim();
                System.out.println("action " + this.actionCount + ": " + this.actions[this.actionCount - 1]);
                lastPos = pos + 2;
                pos = this.action.indexOf(";;", lastPos);
            }
            this.actions[this.actionCount++] = this.action.substring(lastPos).trim();
            System.out.println("action " + this.actionCount + ": " + this.actions[this.actionCount - 1]);
            this.type = EmbeddedBase.BASE.m_jnioros.getRegistryString(prefix + "Type", "Time");
            if (this.type.equals("Time")) {
                this.recurring = EmbeddedBase.BASE.m_jnioros.getRegistryBoolean(prefix + "Recurring", false);
                if (this.recurring) {
                    String intervals = EmbeddedBase.BASE.m_jnioros.getRegistryString(prefix + "Interval", "0 seconds");
                    if (intervals.lastIndexOf(" ") <= 0) {
                        intervals = intervals + " seconds";
                    }
                    this.setInterval(intervals);
                } else {
                    this.endTime = -1L;
                }
            } else if (this.type.equals("Event")) {
                this.eventBasedType = EmbeddedBase.BASE.m_jnioros.getRegistryString(prefix + "EventBasedType", "");
                String ioNumber = this.eventBasedType.substring(this.eventBasedType.lastIndexOf(58) + 1);
                if (!ioNumber.equals("")) {
                    this.eventIoNumber = Integer.valueOf(ioNumber);
                }
                String mNumber = this.eventBasedType.substring(this.eventBasedType.indexOf(58) + 1, this.eventBasedType.lastIndexOf(58));
                if (!ioNumber.equals("")) {
                    this.middleNumber = Integer.valueOf(mNumber);
                }
                String eventBasedType2 = EmbeddedBase.BASE.m_jnioros.getRegistryString(prefix + "Misc", "");
                try {
                    this.miscNumber = Integer.parseInt(eventBasedType2);
                }
                catch (NumberFormatException nfe) {}
            } else if (this.type.equals("Logical")) {
                this._logicalExpression = EmbeddedBase.BASE.m_jnioros.getRegistryString(prefix + "LogicalExpression", "");
                this._logic = new Logic(this._logicalExpression);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
        return this;
    }

    private static long getTimeFromString(String time) throws Exception {
        int hours = 0;
        int mins = 0;
        int seconds = 0;
        StringTokenizer st = new StringTokenizer(time);
        while (st.hasMoreTokens()) {
            String timePart = st.nextToken();
            if (timePart.indexOf(":") <= 0) continue;
            StringTokenizer tt = new StringTokenizer(timePart, ":");
            int i = 0;
            while (tt.hasMoreTokens()) {
                timePart = tt.nextToken();
                switch (i) {
                    case 0: {
                        hours = Integer.parseInt(timePart);
                        break;
                    }
                    case 1: {
                        mins = Integer.parseInt(timePart);
                        break;
                    }
                    case 2: {
                        seconds = Integer.parseInt(timePart);
                    }
                }
                ++i;
            }
        }
        return hours * 3600000 + mins * 60000 + seconds * 1000;
    }

    public void setRecurring(boolean recurring) {
        this.recurring = recurring;
    }

    public void setInterval(String interval) {
        this.interval = Integer.parseInt(interval.substring(0, interval.indexOf(" ")));
        if (interval.lastIndexOf("hour") >= 0) {
            this.interval *= 3600000L;
        } else if (interval.lastIndexOf("min") >= 0) {
            this.interval *= 60000L;
        } else if (interval.lastIndexOf("second") >= 0) {
            this.interval *= 1000L;
        }
    }

    public boolean isValidDay(int day) {
        boolean validDay = (this.daysMask & 1 << day % 8 - 1) != 0;
        return validDay;
    }

    private int getNextValidDay(int day) {
        int nextDay = day;
        if (this.daysMask == 0) {
            return -1;
        }
        int mask = this.daysMask >> day;
        while ((mask & 1) != 1) {
            if ((mask >>= 1) == 0) {
                mask = this.daysMask;
            }
            if (++nextDay % 7 != day) continue;
            return -1;
        }
        return nextDay;
    }

    public String toString() {
        String returnString = this.name + " will " + this.action + "\r\n";
        if (this.recurring) {
            returnString = returnString + "   every " + this.interval + " starting";
        }
        returnString = returnString + " at " + this.time + " on " + this.daysMask + " days";
        return returnString;
    }
}

