 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: syslog.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// initialize the syslog on new connection
var log_onopen = chan.onopen;
chan.onopen = function(evt) {
	
	// Request fresh syslog detail
	var request = new Object();
	request['Message'] = "Syslog Read";
  chan.sendJson(request);

	// clear any prior syslog content
	document.getElementById("logtable").innerHTML = "";
	document.getElementById("logdata").className = "twirl";
	
	// chain
	if (log_onopen)
		log_onopen(evt);
}

// context highlighting
function log_context(msg) {
	var cls = "";
	if (msg.indexOf(", ** ") >= 0)
		cls = " class='err'";
	else if (msg.indexOf(", -- ") >= 0)
		cls = " class='boot'";
	else if (msg.indexOf("Successful login") >= 0)
		cls = " class='emph'";
	return ("<tr><td" + cls + ">" + msg + "</td></tr>");
}

// message processing
var log_onmessage = chan.onmessage;
chan.onmessage = function(evt) {
	var jobj = JSON.parse(evt.data);

	if (jobj['Message'] === 'Syslog Read Response') {
		logdata = jobj['Data'];
		
		document.getElementById("logdata").className = "";
		var elem = document.getElementById("logtable");
		content = "";
		for (var n = logdata.length - 1; n >= 0; n--) {
			try {
				content += log_context(decodeURIComponent(escape(logdata[n]))); 
			} catch(err) {
				content += log_context(logdata[n]); 
			}
		}
		elem.innerHTML = content;
	}

	else if (jobj['Message'] === 'Syslog Update') {
		logdata = jobj['Data'];
		
		var elem = document.getElementById("logtable");
		try {
			elem.innerHTML = log_context(decodeURIComponent(escape(logdata))) + elem.innerHTML;
		} catch(err) {
			elem.innerHTML = log_context(logdata) + elem.innerHTML;
		}
		
	}
	if (log_onmessage)
		log_onmessage(evt);	// chain message processing
}

