/*
 * Decompiled with CFR 0.152.
 */
package integpg.EmbeddedHelpers.Serial;

import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.comm.NoSuchPortException;
import com.integpg.comm.PortInUseException;
import com.integpg.comm.SerialPort;
import com.integpg.comm.UnsupportedCommOperationException;
import com.integpg.system.JANOS;
import java.io.IOException;

public class SerialParams {
    public String REG_SERIAL_PORT = "/SerialPort";
    public String REG_BAUD = "/Baud";
    public String REG_DATA_BITS = "/DataBits";
    public String REG_PARITY = "/Parity";
    public String REG_STOP_BITS = "/StopBits";
    public String REG_FLOW_CONTROL = "/FlowControl";
    public String REG_PACKET_SIZE = "/PacketSize";
    public String SERIAL_PORT = "AUX";
    public int BAUD = 9600;
    public int DATABITS = 8;
    public int STOPBITS = 1;
    public int PARITY = 0;
    public int FLOWCONTROL = 0;
    private int PACKET_SIZE = 1024;
    private static final int[] VALID_BAUD_RATES = new int[]{300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200, 230400, 460800, 921600};
    public static final String[] FLOW_ARRAY = new String[]{"NO FLOW CONTROL", "HARDWARE", "SOFTWARE"};
    public static final int FLOW_NONE = 0;
    public static final int FLOW_HARDWARE = 1;
    public static final int FLOW_SOFTWARE = 2;
    public String serialPort = this.SERIAL_PORT;
    public int baudRate = this.BAUD;
    public int dataBits = this.DATABITS;
    public int stopBits = this.STOPBITS;
    public int parity = this.PARITY;
    public int flowControl = this.FLOWCONTROL;
    public int packetSize = this.PACKET_SIZE;
    private SerialPort serial;

    public SerialParams(String string) {
        this.REG_SERIAL_PORT = string + this.REG_SERIAL_PORT;
        this.REG_BAUD = string + this.REG_BAUD;
        this.REG_DATA_BITS = string + this.REG_DATA_BITS;
        this.REG_PARITY = string + this.REG_PARITY;
        this.REG_STOP_BITS = string + this.REG_STOP_BITS;
        this.REG_FLOW_CONTROL = string + this.REG_FLOW_CONTROL;
        this.REG_PACKET_SIZE = string + this.REG_PACKET_SIZE;
    }

    public void setDefaults(int n, int n2, int n3, int n4) {
        this.setDefaults(null, n, n2, n3, n4);
    }

    public void setDefaults(String string, int n, int n2, int n3, int n4) {
        if (string != null) {
            this.SERIAL_PORT = string;
        }
        this.BAUD = n;
        this.DATABITS = n2;
        this.STOPBITS = n3;
        this.PARITY = n4;
    }

    public void configPort() {
        this.serialPort = JANOS.getRegistryString((String)this.REG_SERIAL_PORT, (String)this.SERIAL_PORT);
        if (this.serialPort.equals(this.SERIAL_PORT)) {
            JANOS.setRegistryString((String)this.REG_SERIAL_PORT, (String)this.SERIAL_PORT);
        }
        this.baudRate = JANOS.getRegistryInt((String)this.REG_BAUD, (int)this.BAUD);
        if (this.baudRate == this.BAUD) {
            JANOS.setRegistryString((String)this.REG_BAUD, (String)Integer.toString(this.BAUD));
        }
        this.dataBits = JANOS.getRegistryInt((String)this.REG_DATA_BITS, (int)this.DATABITS);
        if (this.dataBits == this.DATABITS) {
            JANOS.setRegistryString((String)this.REG_DATA_BITS, (String)Integer.toString(this.DATABITS));
        }
        this.stopBits = JANOS.getRegistryInt((String)this.REG_STOP_BITS, (int)this.STOPBITS);
        if (this.stopBits == this.STOPBITS) {
            JANOS.setRegistryString((String)this.REG_STOP_BITS, (String)Integer.toString(this.STOPBITS));
        }
        this.parity = JANOS.getRegistryInt((String)this.REG_PARITY, (int)this.PARITY);
        if (this.parity == this.PARITY) {
            JANOS.setRegistryString((String)this.REG_PARITY, (String)Integer.toString(this.PARITY));
        }
        this.flowControl = JANOS.getRegistryInt((String)this.REG_FLOW_CONTROL, (int)this.FLOWCONTROL);
        if (this.flowControl == this.FLOWCONTROL) {
            JANOS.setRegistryString((String)this.REG_FLOW_CONTROL, (String)Integer.toString(this.FLOWCONTROL));
        }
        this.packetSize = JANOS.getRegistryInt((String)this.REG_PACKET_SIZE, (int)this.PACKET_SIZE);
        if (this.packetSize == this.PACKET_SIZE) {
            JANOS.setRegistryString((String)this.REG_PACKET_SIZE, (String)Integer.toString(this.PACKET_SIZE));
        }
    }

    public SerialPort openPort(String string) throws IOException, UnsupportedCommOperationException, NoSuchPortException, PortInUseException {
        if (this.serialPort.equalsIgnoreCase("disabled")) {
            return null;
        }
        System.out.println(string + " opening " + this.serialPort.toUpperCase() + " port");
        if (this.serialPort.toLowerCase().equals("aux")) {
            this.serial = new AUXSerialPort();
            this.serial.open();
        } else if (this.serialPort.toLowerCase().equals("rs232")) {
            if (JANOS.uptimeMillis() < 90000L) {
                System.out.println("Waiting to Open CONSOLE Port " + JANOS.uptimeMillis());
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.serial = new COMSerialPort();
            this.serial.open();
            COMSerialPort cfr_ignored_0 = (COMSerialPort)this.serial;
            COMSerialPort.setBootDialog((boolean)false);
        } else {
            System.out.println("Serial Control: Bad Serial Port Selection");
            JANOS.syslog((String)"Serial Control: Bad Serial Port Selection");
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < VALID_BAUD_RATES.length; ++i) {
            if (this.baudRate != VALID_BAUD_RATES[i]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new UnsupportedCommOperationException();
        }
        this.configFlowControl();
        this.configurePacketSize();
        this.serial.setSerialPortParams(this.baudRate, this.dataBits, this.stopBits, this.parity);
        this.serial.enableReceiveTimeout(100);
        return this.serial;
    }

    public void configFlowControl() throws IOException {
        this.flowControl = JANOS.getRegistryInt((String)this.REG_FLOW_CONTROL, (int)this.FLOWCONTROL);
        if (this.flowControl == this.FLOWCONTROL) {
            JANOS.setRegistryString((String)this.REG_FLOW_CONTROL, (String)Integer.toString(this.FLOWCONTROL));
        }
        try {
            if (this.flowControl == 1) {
                this.serial.setFlowControlMode(3);
                System.out.print("Enabling Hardware Flow Control for Serial");
            } else if (this.flowControl == 2) {
                this.serial.setFlowControlMode(12);
                System.out.print("Enabling Software Flow Control for Serial");
            }
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            unsupportedCommOperationException.printStackTrace();
        }
    }

    public void configurePacketSize() throws IOException, UnsupportedCommOperationException {
        this.packetSize = JANOS.getRegistryInt((String)this.REG_PACKET_SIZE, (int)this.PACKET_SIZE);
        if (this.packetSize == this.PACKET_SIZE) {
            JANOS.setRegistryString((String)this.REG_PACKET_SIZE, (String)Integer.toString(this.PACKET_SIZE));
        }
        this.serial.enableReceiveThreshold(this.packetSize);
    }

    public void onDeath() {
        System.out.println("Attempt to give the Console port back to the OS");
        if (this.serial != null) {
            this.serial.close();
        }
    }
}

