/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integ.janoslib.messagepump.MessagePumpListener;
import com.integpg.janoslib.io.AppLog;
import com.integpg.snmp.SNMPStore;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPNull;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.snmp.objects.SNMPVariablePair;
import com.integpg.snmp.objects.exceptions.SNMPBadValueException;
import com.integpg.system.SystemMsg;
import java.util.Json;

public class OidReceiveHandler
implements MessagePumpListener {
    @Override
    public void messageReceived(SystemMsg msg) {
        if (3000 == msg.type) {
            Json json = new Json(new String(msg.msg));
            System.out.println("msg: " + msg.type + " = " + json);
            String command = (String)json.get("command");
            if ("update-oids".equalsIgnoreCase(command)) {
                Json[] oidJsonArray;
                for (Json oidJson : oidJsonArray = (Json[])json.get("oids")) {
                    try {
                        System.out.println("oidJson: " + oidJson);
                        String id = (String)oidJson.get("oid");
                        String type = (String)oidJson.get("type");
                        String value = (String)oidJson.get("value");
                        SNMPObject object = new SNMPNull();
                        if ("string".equalsIgnoreCase(type)) {
                            object = new SNMPOctetString(value);
                        } else if ("integer".equalsIgnoreCase(type)) {
                            object = new SNMPInteger(Integer.parseInt(value));
                        }
                        SNMPVariablePair pair = SNMPStore.findPair(id);
                        if (null == pair) {
                            pair = SNMPStore.insertPair(id, object);
                        } else {
                            pair.setObject(object);
                        }
                        System.out.println("pair: " + pair);
                    }
                    catch (SNMPBadValueException ex) {
                        AppLog.error(ex);
                    }
                }
            }
        }
    }
}

