/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.io;

import com.integpg.janoslib.datastructures.CircularQueue;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.io.RollingMemoryLogService;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public abstract class Log {
    protected static final Hashtable<String, Log> LogsCache = new Hashtable();
    protected static final String CRLF = "\r\n";
    protected QuickDateFormat _dateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss zzz");
    private final String _filename;
    private final CircularQueue _queue = new CircularQueue(100);
    private final StringBuffer _sb = new StringBuffer();
    private boolean _includeDate = true;
    private boolean _echo = true;

    protected Log() {
        this._filename = null;
    }

    protected Log(String filename) {
        this._filename = filename.toLowerCase();
    }

    public void setDateFormat(String dateFormat) {
        if (!dateFormat.equals(this._dateFormat.getDateFormatString())) {
            System.out.println("Change date format for " + this.getFilename() + " to " + dateFormat);
            this._dateFormat = new QuickDateFormat(dateFormat);
        }
    }

    protected String getFilename() {
        return this._filename;
    }

    public boolean getIncludeDate() {
        return this._includeDate;
    }

    public void setIncludeDate(boolean includeDate) {
        this._includeDate = includeDate;
    }

    public boolean getEcho() {
        return this._echo;
    }

    public void setEcho(boolean echo) {
        this._echo = echo;
    }

    public int getPendingEntries() {
        return this._queue.size();
    }

    public synchronized void writeln(String line) {
        this._sb.setLength(0);
        if (this._includeDate) {
            this._sb.append(this._dateFormat.format(System.currentTimeMillis()));
            this._sb.append(", ");
        }
        this._sb.append(line);
        this._sb.append(CRLF);
        try {
            if (this._queue.isFull()) {
                System.out.println(this._filename + " queue is full");
                while (this._queue.isFull()) {
                    Thread.yield();
                }
            }
            String s = this._sb.toString();
            this._queue.enqueue(s);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this._echo) {
            System.out.println(line);
        }
        RollingMemoryLogService.addWaitingLog(this);
    }

    public void debug(String line) {
        this.writeln("?? " + line);
    }

    public void fatal(String line) {
        this.writeln("!! " + line);
    }

    public void warn(String line) {
        this.writeln(" * " + line);
    }

    public void error(String line) {
        this.writeln("** " + line);
    }

    public void error(Throwable ex) {
        ex.printStackTrace();
        this.error(ex.toString());
        AppLog.error(ex);
    }

    public void error(String description, Throwable ex) {
        ex.printStackTrace();
        this.error(description + ": " + ex.toString());
        AppLog.error(description, ex);
    }

    public void info(String line) {
        this.writeln(line);
    }

    public void vital(String line) {
        this.writeln("## " + line);
    }

    protected void logEntry() {
        try {
            Object o = this._queue.peek();
            if (o != null) {
                String s = (String)o;
                this.preFileWrite(s);
                FileOutputStream out = new FileOutputStream(this._filename, true);
                out.write(s.getBytes());
                out.close();
                this.postFileWrite();
                this._queue.dequeue();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected abstract void preFileWrite(String var1);

    protected abstract void postFileWrite();

    public boolean isBusy() {
        boolean busy;
        boolean bl = busy = !this._queue.isEmpty();
        if (busy) {
            System.out.println(this._filename + " is busy");
        }
        return busy;
    }

    public int getEntriesRemainingCount() {
        return this._queue.size();
    }
}

