class DeviceObject extends TaskerObject {
    constructor(name) {
        super();
        this.Name = name = name || 'new Device';
    }


    editTemplate() {
        var template = 'editTemplate() not overridden';
        return template;
    }
}



class EthernetDevice extends DeviceObject {
    constructor(name, ipAddress, port) {
        super(name);
        this.Type = 'EthernetDevice';
        this.Params = {};
    }


    editTemplate() {
        var template = 'IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="ip-address-{{$index}}" required> ' +
            ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-{{$index}}" required>';
        return template;
    }
}



class SNMPDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'SNMPDevice';
        this.Params = { Port: 162, CommunityName: 'public' };
    }


    editTemplate() {
        var template = 'IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="ip-address-{{$index}}" required> ' +
            ' UDP Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-{{$index}}" required>' +
            ' Community Name <input type="text" class="form-control" ng-model="device.Params.CommunityName" ' +
            '  style="width:200px;" name="community-name-{{$index}}" required>';
        return template;
    }
}



class ModbusDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'ModbusDevice';
        this.Params = { Port: 502 };
    }


    editTemplate() {
        var template = 'IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="ip-address-{{$index}}" required> ' +
            ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-{{$index}}" required>'
        return template;
    }
}