App.controller('slavingController', ['$scope', function ($scope) {

    var _this = this;
    _this.running = false;

    _this.Config = {};
    _this.Config.ioPoints = [];
    _this.Config.inputs = [];
    _this.Config.outputs = [];

    _this.Config.defaultIoPoints = ["din1", "din2", "din3", "din4", "din5", "din6", "din7", "din8", "din9", "din10", "din11", "din12",
        "rout1", "rout2", "rout3", "rout4", "rout5", "rout6", "rout7", "rout8", "rout9", "rout10", "rout11", "rout12", "rout13", "rout14", "rout15", "rout16"];

    _this.SavedConfig = {};

    var firstMonitor = true;
    var comm = new Comm();
    comm.connect();

    jnrwebsocket.addOnLoggedInListener(function onLoggedIn() {
            jnrwebsocket.subscribeRegistryKey('Run/Slaving', function (registryKey, registryValue) {
                if (registryValue == "flash/slaveservice.jar") {
                    _this.running = true;
                }
                if (registryValue == "") {
                    _this.running = false;
                }
                $scope.$apply();
            });
    });

    comm.onmessage = function (evt) {
        var json = JSON.parse(evt.data);

        if (json.Message === "Authenticated") {
        } else if (json.Message === "Monitor") {
            if (firstMonitor) {
                for (var i = 0; i < json.Inputs.length; i++) {
                    _this.Config.ioPoints.push("din" + (i + 1));
                    _this.Config.inputs.push({ name: "din" + (i + 1) });
                }
                for (var i = 0; i < json.Outputs.length; i++) {
                    _this.Config.ioPoints.push("rout" + (i + 1));
                    _this.Config.outputs.push({ name: "rout" + (i + 1) });
                }

                readSlavingRegistryConfig();
                firstMonitor = false;

                $scope.$apply();
            }

        } else if (json.Message === "Registry Response"
            || json.Message === "Registry Update") {
            var keys = json.Keys;
            for (key in keys) {
                slaveInfoUpdate(key, keys[key]);
            }

            _this.SavedConfig.inputs = angular.copy(_this.Config.inputs);
            _this.SavedConfig.outputs = angular.copy(_this.Config.outputs);
            $scope.$apply();
        }
    };

    function readSlavingRegistryConfig() {
        var regRead = { "Message": "Registry Read", "Keys": [] };
        for (var i = 0; i < 8; i++) {
            regRead.Keys.push("/IO/Inputs/din" + (i + 1) + "/Slave");
        }
        comm.sendJson(regRead);
        var regRead = { "Message": "Registry Read", "Keys": [] };
        for (var i = 0; i < 8; i++) {
            regRead.Keys.push("/IO/Outputs/rout" + (i + 1) + "/Slave");
        }
        comm.sendJson(regRead);
    };



    function slaveInfoUpdate(key, slaveInfo) {
        if (slaveInfo) {
            console.log(slaveInfo);

            // check to see if it is input config
            var regex = "IO/Inputs/din([\\d]+)/Slave";
            var matches = key.match(regex);
            if (matches) {
                var channelIndex = matches[1] - 1;
                loadSlaveConfig(channelIndex, slaveInfo, _this.Config.inputs);
            }

            // check to see if it is output config
            var regex = "IO/Outputs/rout([\\d]+)/Slave";
            var matches = key.match(regex);
            if (matches) {
                var channelIndex = matches[1] - 1;
                loadSlaveConfig(channelIndex, slaveInfo, _this.Config.outputs);
            }
        }
    };



    function loadSlaveConfig(channelIndex, slaveConfig, dictionary) {
        var slavingParts = slaveConfig.split(",");
        dictionary[channelIndex].ipAddress = slavingParts[0].trim();
        if ("" === dictionary[channelIndex].ipAddress) {
            dictionary[channelIndex].ipAddress = "localhost";
        }
        dictionary[channelIndex].port = slavingParts[1].trim();
        dictionary[channelIndex].username = slavingParts[2].trim();
        dictionary[channelIndex].password = slavingParts[3].trim();
        dictionary[channelIndex].ioPoint = slavingParts[4].trim();
        if (5 < slavingParts.length) {
            dictionary[channelIndex].failedComm = slavingParts[5].trim();
        }
    };



    _this.save = function () {
        var message = 'Are you sure you want to save the changes you have made?';
        bootbox.confirm(message, function (result) {
            if (result) {
                var keys = {};
                for (var channelIndex = 0; channelIndex < _this.Config.inputs.length; channelIndex++) {
                    var regKey = "IO/Inputs/din" + (channelIndex + 1) + "/Slave";
                    keys[regKey] = getSlavingKeyForChannel(channelIndex, _this.Config.inputs);
                }
                for (var channelIndex = 0; channelIndex < _this.Config.outputs.length; channelIndex++) {
                    var regKey = "IO/Outputs/rout" + (channelIndex + 1) + "/Slave";
                    keys[regKey] = getSlavingKeyForChannel(channelIndex, _this.Config.outputs);
                }
                var regWrite = { "Message": "Registry Write", "Keys": keys };
                comm.sendJson(regWrite);

                setTimeout(function () {
                    readSlavingRegistryConfig();
                }, 1000);
            }
        });
    };



    function getSlavingKeyForChannel(channelIndex, dictionary) {
        var output = dictionary[channelIndex];
        var keyValue = "";
        if (output.ioPoint && "" != output.ioPoint) {

            if (!output.ipAddress)
                output.ipAddress = "localhost";
            var values = [output.ipAddress];
            values.push(output.port ? output.port : "");
            values.push(output.username ? output.username : "");
            values.push(output.password ? output.password : "");
            values.push(output.ioPoint ? output.ioPoint : "");
            values.push(output.failedComm ? output.failedComm : "");

            keyValue = values.join(", ");
        }
        return keyValue;
    };



    _this.revert = function () {
        var message = 'Are you sure you want to cancel the changes you have made?';
        bootbox.confirm(message, function (result) {
            if (result)
                readSlavingRegistryConfig();
        });
    };



    _this.hasConfigChanged = function () {
        return !(angular.equals(_this.Config.inputs, _this.SavedConfig.inputs)
            && angular.equals(_this.Config.outputs, _this.SavedConfig.outputs));
    };



    /** _this.ioPointChanged = function (channelIndex) {
        var output = _this.Config.outputs[channelIndex];
        if (!output.ipAddress)
                output.ipAddress = "localhost";

        if (!output || !output.ioPoint || "" === output.ioPoint) {
            _this.Config.outputs[channelIndex] = {};
        } else {
            if (!output.ipAddress)
                output.ipAddress = "localhost";
        }
    };*/
}]);