 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA
  724.933.9350

  File: config.js

  This file contains the basic Javascript required by the main page. This handles dynamic
  updates and page controls.

  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process
  Group, Inc. is required.
*/

// $$$$$$$$$$ set false prevent update intervals (for debug)
var dopoll = true;
// $$$$$$$$$$ comment out to log websocket traffic (overrides output otherwise)
//console.log = function() {}

var chan = new Comm();
var module_keyToId = null;
var module_idToKey = null;
var module_present = new Array();
var module_idToStatus = new Object();
var registry_cache = new Object();
var registry_default = new Object();
var snapText = new Object();
var output_states = new Array();
var poll_pacer = 0;

var helpcontext = "";

function avoidInvalidKeyStorkes(evtArg) {
    var evt = (document.all ? window.event : evtArg);
    var isIE = (document.all ? true : false);
    var KEYCODE = (document.all ? window.event.keyCode : evtArg.which);

    var element = (document.all ? window.event.target : evtArg.target);
    var msg = "We have disabled this key: " + KEYCODE;

    if (KEYCODE == "112") {
        if (isIE) {
            document.onhelp = function() {
                return (false);
            };
            window.onhelp = function() {
                return (false);
            };
        }
        evt.returnValue = false;
        evt.keyCode = 0;
        window.status = msg;
        evt.preventDefault();
        evt.stopPropagation();

        if (helpcontext == "")
	        window.open("query.cgi?help=*", "dcphelp");
	       else
  	      window.open("query.cgi?help=" + helpcontext, "dcphelp");
    }

    window.status = "Done";    
}    

if (window.document.addEventListener) {
    window.document.addEventListener("keydown", avoidInvalidKeyStorkes, false);
} else {
    window.document.attachEvent("onkeydown", avoidInvalidKeyStorkes);
    document.captureEvents(Event.KEYDOWN);
}

// Opens a login dialog if access to the WebSocket interface is denied.
chan.onauth = function(evt) {
	if (chan.connected)
		location.reload();
	else
		login();
}

// detect IE (just can't get everything to work with it)
var ugh_IE = !!window.navigator.userAgent.match(/(MSIE|Trident\/7\.)/) ? true : false;

// IE Doesn't have a .startsWith
if (!String.prototype.startsWith) {
  String.prototype.startsWith = function (str){
    return this.lastIndexOf(str, 0) === 0;
  };
}

// IE Doesn't have a .endsWith
if (!String.prototype.endsWith) {
	String.prototype.endsWith = function(suffix) {
		return this.indexOf(suffix, this.length - suffix.length) !== -1;
	};
}

// function adds commas for 1000s in an integer
function nformat(num) {
	var str = num.toString();
	var regex = str.indexOf(".") < 0 ? /(\d)(?=(\d{3})+$)/g : /(\d)(?=(\d{3})+\.)/g;
	return str.replace(regex, '$1,');
}

var unique = 1;

// **************************************************
// overlay pages if connection lost
var chan_onclose = chan.onclose;
chan.onclose = function(evt) {
		document.getElementById("txt").innerHTML = "Connection Closed";
		document.getElementById("offline").style.display = "inherit";
		if (chan_onclose)
			chan_onclose(evt);
}
// **************************************************
// process received messages
var chan_onmessage = chan.onmessage;
chan.onmessage = function(evt) {
	var jobj = JSON.parse(evt.data);
	
	if (jobj['Message'] === 'Authenticated') {
		document.getElementById("logout").innerHTML = chan.username;
		
		if (jobj['Administrator']) {
			document.getElementById("tabs").innerHTML = document.getElementById("tabs-admin").innerHTML;
			jnior_admin = true;
			jnior_control = true;
			tabinit();
			
		}
		else if (jobj['Control']) {
			document.getElementById("tabs").innerHTML = document.getElementById("tabs-control").innerHTML;
			jnior_admin = false;
			jnior_control = true;
			tabinit();
		}
		else {
			document.getElementById("tabs").innerHTML = document.getElementById("tabs-other").innerHTML;
			jnior_admin = false;
			jnior_control = false;
			tabinit();
		}
		
		if (jnior_control) {
			var elems = document.getElementsByClassName("control hide");
			while (elems.length) {
				elems[0].className = "control";
			}
		}
	}

	else if (jobj['Message'] === 'Device Shutdown') {
		document.getElementById("txt").innerHTML = "Shutdown";
		document.getElementById("offline").style.display = "inherit";
	}

	else if (jobj['Message'] === 'Clock Response') {
		document.getElementById("clock").innerHTML = jobj['Date'];
	}

	else if (jobj['Message'] === 'Registry Update' || jobj['Message'] === 'Registry Response') {
		var meta = jobj['Meta'];
		if (meta)
			var op = meta['Op'];

		// general Registry update
		if (op == null) {
	    var keys = jobj['Keys'], key;
	    for (key in keys) {

	    	// standardize key format
	    	var keylower = keystd(key);
	    	var keyvalue = keys[key];
	    	registry_cache[keylower] = keyvalue;
	    	if (keyvalue == null || keyvalue == "")
	    		keyvalue = registry_default[keylower];
	    	if (keyvalue == undefined)
	    	  keyvalue = "";


	    	// check for color inversion
	    	if (keylower == "io/invertcolors" || keylower == "io/oncolor" || keylower == "io/offcolor") {
	    		var lnk = document.getElementById('pagestyle');
	    		lnk.href = "config.css.php?unique=" + unique++;
	    	}

	    	// process connected devices
	    	if (keylower == "externals/$present") {
	    		var str = keyvalue;
	    		var pos;
	    		var p = 0;
	    		var n = 0;

					module_present = new Array();
	    		while ((pos = str.indexOf(",", p)) > -1) {
	    			module_present[n++] = str.substring(p, pos).trim();
	    			p = pos + 1;
	    		}
	    		if (str.length >= p + 16)
	    			module_present[n] = str.substring(p).trim();

		    	// process external device changes (once initialized)
		    	if (module_keyToId) {

					  // remove any that are no longer
					  for (id in module_idToStatus) {
					  	if (module_present.indexOf(id) == -1)
					  		delete module_idToStatus[id];
					  }

		    		// update the available devices
		    		if (module_present.length) {
					    var request = new Object();
					    request['Message'] = "Read Devices";
					    request['Devices'] = module_present;
					    chan.sendJson(request);
					  }

						update_modulelist();
					}
		  	}

	    	if (module_keyToId && keylower.startsWith("externals/deviceorder/type")) {
	    		if (keyvalue === null || keyvalue == "") {
	    			var id = module_keyToId[keylower];
	    			if (id) {
	    				delete module_keyToId[keylower];
	    				delete module_idToKey[id];
	    				update_modulelist();
	    			}
	    		}
	    		else {
	    			var id = module_keyToId[keylower];
    				module_keyToId[keylower] = keyvalue;
    				if (id != keyvalue) {
	    				delete module_idToKey[id];
	    			}
	    			module_idToKey[keyvalue] = keylower;
	    			update_modulelist();
	    		}
	    	}

	    	// process module enables
	    	if (keylower.startsWith("externals/") && keylower.indexOf("enable") >= 0)
	    		update_externals(true);

	    	// process key named objects
	      var setting = document.getElementsByName(keylower);
	      for (k = 0; k < setting.length; k++) {
			    if (typeof(setting[k]) !== 'undefined') {
			  		if (setting[k].type === 'checkbox') {
						  var val = keyvalue;
						  var n = val.indexOf(",");
						  if (n >= 0)
				  		  val = val.substr(0, n);
			    		setting[k].checked = istrue(val);

			    		// because the control depends on two different settings
			    		if (keylower.startsWith("io/inputs/din") && keylower.endsWith("/latching")) {
								var node = keylower.substring(0, keylower.lastIndexOf("/") + 1);
								var elems = document.getElementsByName(node + "showcontrols");
								var ckd = false;
								for (j = 0; j < elems.length; j++) {
									if (elems[j].type === 'checkbox') {
										ckd = elems[j].checked;
										break;
									}
								}
								for (j = 0; j < elems.length; j++) {
									if (elems[j].className.startsWith("release")) {
										elems[j].className = istrue(val) && ckd ? "release" : "release hide";
										break;
									}
								}
			    		}
						}
						else if (setting[k].type === 'text') {
							if (keylower.indexOf("password") >= 0)
								setting[k].type = "password";
				  		setting[k].value = decodeURIComponent(escape(keyvalue));
						}
						else if (setting[k].type == 'password') {
				  		setting[k].value = keyvalue;
						}
						else if (setting[k].type === 'select-one') {
							if (keyvalue === "")
			        	setting[k].value = parseInt(setting[k].getAttribute("dflt"));
		        	else
			        	setting[k].value = parseInt(keyvalue);
						}
						else if (keylower.endsWith("$hourmeter")) {
							setting[k].innerHTML = nformat(keyvalue);
						}
						else if (setting[k].className.startsWith("spanio")) {
							setting[k].className = istrue(keyvalue) ? "spanio" : "spanio hide";
						}
						else if (setting[k].className.startsWith("spancounter")) {
							setting[k].className = istrue(keyvalue) ? "spancounter" : "spancounter hide";
						}
						else if (setting[k].className.startsWith("spanmeter")) {
							setting[k].className = istrue(keyvalue) ? "spanmeter" : "spanmeter hide";
						}
						else if (setting[k].className.startsWith("toggle")) {
							setting[k].className = keyvalue == 0 ? "toggle" : "toggle hide";
						}
						else if (setting[k].className.startsWith("pulse")) {
							setting[k].className = keyvalue == 1 ? "pulse" : "pulse hide";
						}
						else if (setting[k].className.startsWith("release")) {
							var node = keylower.substring(0, keylower.lastIndexOf("/") + 1);
							var elems = document.getElementsByName(node + "latching");
							var ckd = elems[0].checked;
							setting[k].className = istrue(keyvalue) && ckd ? "release" : "release hide";
						}
						else {
							setting[k].innerHTML = decodeURIComponent(escape(keyvalue));
						}
					}
	      }
	    }
    }

    // Registry updates for modules
    else if (op === "modules") {
    	keys = jobj['Keys'];
    	module_keyToId = new Object();
    	module_idToKey = new Object();
    	var devices = new Array();

    	var n = 0;
	    for (key in keys) {

	    	// standardize key format
	    	var keylower = keystd(key);
	    	var keyvalue = keys[key];
	    	registry_cache[keylower] = keyvalue;
	    	if (keyvalue == null)
	    		keyvalue = registry_default[keylower];

	    	if (keylower.startsWith("externals/deviceorder/type")) {
	    		var id = keyvalue;
	    		module_keyToId[keylower] = id;
	    		module_idToKey[id] = keylower;
		    	devices[n++] = id;
		    }
	    }

	    var request = new Object();
	    request['Message'] = "Read Devices";
	    request['Devices'] = devices;
	    chan.sendJson(request);
    }
  }

	else if (jobj['Message'] === 'Registry List Response') {
		var meta = jobj['Meta'];
		var op = meta['Op'];
		var keys = jobj['Keys'];

	 	// process operations for the Modules page
	 	if (op === "modules") {
	 		var request = new Object();
	 		request['Message'] = "Registry Read";
	 		request['Meta'] = meta;
	 		request['Keys'] = keys;
	 		chan.sendJson(request);
	 	}
	}

	// process external module update
	else if (jobj['Message'] === 'Read Devices Response') {
		modules = jobj['Devices'];
		update = false;

		for (key in modules) {
			var device = modules[key];
			var id = device['Address'];
			var status = device['Hex'];
			if (module_idToStatus[id] == null)
				update = true;
			module_idToStatus[id] = status;
		}

		update_modulelist();
		update_externals(update);
	}

	else if (jobj['Message'] === 'Write Devices Response') {
		pace_sliding = false;
	}

	// process Monitor messages
	else if (jobj['Message'] === 'Monitor') {
		document.getElementById("offline").style.display = "none";

		// page remains hidden by twirly until websocket active
		var load = document.getElementById('load');
		if (load.className == 'loading') {
			load.className = 'loading hide';
			document.getElementById('main').className = 'wrapper';
		}

		var inputs = jobj['Inputs'], key;
		var n = 0;
    for (key in inputs) {
    	n++;
    	var state = inputs[key];
    	var nameon = "dinon" + n;
    	var nameoff = "dinoff" + n;
   		var ondiv = document.getElementById(nameon);
   		if (ondiv) {
	   		var offdiv = document.getElementById(nameoff);

	    	var id = "rel" + n;
	    	var btn = document.getElementById(id);

	    	if (state['State'] == 0) {
	    		ondiv.className = "state on hide";
	    		offdiv.className = "state off";
		    	btn.disabled = true;
		    	btn.innerHTML = "Armed";
	    	}
	    	else {
	    		ondiv.className = "state on";
	    		offdiv.className = "state off hide";
		    	btn.disabled = false;
		    	btn.innerHTML = "Reset";
	    	}
	      var setting = document.getElementsByName("counter" + n);
	      var cntval = nformat(state['Count']);
	      for (k = 0; k < setting.length; k++) {
	      	setting[k].innerHTML = cntval;
	      }
	    }
    }

		var ext_read = [false, false, false, false];
		var outputs = jobj['Outputs'], key;
		var n = 0;
    for (key in outputs) {
    	n++;
    	var state = outputs[key];
    	var nameon = "routon" + n;
    	var nameoff = "routoff" + n;
   		var ondiv = document.getElementById(nameon);
   		if (ondiv) {
	   		var offdiv = document.getElementById(nameoff);
	    	if (state['State'] == 0) {
	    		ondiv.className = "state on hide";
	    		offdiv.className = "state off";
	    	}
	    	else {
	    		ondiv.className = "state on";
	    		offdiv.className = "state off hide";
	    	}
	    }

			if (state) {
		    if (state['State'] != output_states[n])
		    	ext_read[(n - 1) >> 2] = true;

		    output_states[n] = state['State'];
		  }
    }

    if (module_keyToId == null) {
    	var meta = new Object();
    	meta['Op'] = "modules";

			var request = new Object();
			request['Message'] = "Registry Read";
			request['Keys'] = new Array("Externals/$Present");
		  chan.sendJson(request);

			var request = new Object();
			request['Message'] = "Registry List";
			request['Meta'] = meta;
			request['Node'] = "Externals/DeviceOrder";
		  chan.sendJson(request);
    }
    else {

    	// request updates
    	var p = 2;
    	if (jnior_model.startsWith("412"))
    		p = 3;
    	else if (jnior_model == "414")
    		p = 1;

    	var devices = new Array();
    	var j = 0;
    	for (n = p; n < 4; n++) {
    		if (ext_read[n]) {
    			devices[j] = module_keyToId["externals/deviceorder/typefb_" + (n - p + 1)];
    			j++;
    		}
    	}
    	if (devices.length) {
    		var request = new Object();
    		request['Message'] = "Read Devices";
    		request['Devices'] = devices;
    		chan.sendJson(request);
    	}
    }
	}

	if (chan_onmessage)
		chan_onmessage(evt);	// chain message processing
}


// **************************************************

// We want to receive the clock periodically
function clockread() {
	// Here we check for an active connection
	if (chan.open) {
//		if (Date.now() > chan.message_time + 15000) {
//			document.getElementById("txt").innerHTML = "Response Timeout";
//			document.getElementById("offline").style.display = "inherit";
//			chan.ws.close();
//		}
//		else {
			chan.sendJson({'Message':'Clock Read'});
//		}
	}
}

// read the clock and setup updates
if (dopoll)
	setInterval(clockread, 1000);

// **************************************************

// Function reduces a key to lowercase and trims any leading slash. This standardizes the key
//  for reference.
function keystd(key) {
	var keylower = key.toLowerCase();
	if (keylower.startsWith('/'))
		keylower = keylower.substring(1);
	return keylower;
}

// **************************************************
function updateHelp(evt) {
	var targ = evt.target;
	if (targ.title != "") {
		helpcontext = targ.title;
		document.getElementById("helpcontext").innerHTML = 
			"Mouseover and use F1 for context sensitive help. Current topic: <a href='query.cgi?help=" + 
			helpcontext + "' target='dcphelp'>" + helpcontext + "</a>";
	}
}

// reset statusbar
function helpInit(sel) {
	if (sel == 1)
		document.getElementById("helpcontext").innerHTML = "Mouseover and use F1 for context sensitive help.";
	else
		document.getElementById("helpcontext").innerHTML = "";

	helpcontext = "";
}

// **************************************************
function updateCheckbox(evt) {
	var targ = evt.target;
	if (targ.title != "") {
		var curr = getkey(targ.title, "disabled").toLowerCase();

		var keys = new Object();
		var update = new Object();
		update['Message'] = "Registry Write";

  	if (targ.title.startsWith("Run/")) {
  		if (targ.checked)
  			keys[targ.title] = targ.name;
	  	else
	  		keys[targ.title] = "";
  	}
  	else {
  		if (curr == "1" || curr == "0")
  			keys[targ.title] = curr == "0" ? "1" : "0";
  		if (curr == "true" || curr == "false")
  			keys[targ.title] = curr == "false" ? "true" : "false";
  		if (curr == "enable" || curr == "disable")
  			keys[targ.title] = curr == "disable" ? "enable" : "disable";
  		else
	  		keys[targ.title] = targ.checked ? "enabled" : "disabled";
	  }

	  update['Keys'] = keys;
    chan.sendJson(update);
  }
}

// On gaining focus we snapshot the content used to detect change
function snapTextbox(box) {
	snapText[box.target.name] = box.target.value;
}

// on losing focus we update the key
function updateTextbox(e) {
	updateKey(e.target.name, e.target.title, e.target.value);
}

function textKeydown(e) {
	// check for ESC to restore original content
	if (e.which == 0x1b) {
		e.target.value = snapText[e.target.name];
		e.target.blur();
		return false;
	}
	// check for ENTER to update the key
	else if (e.keyCode == 0x0d) {
		e.target.blur();
		return false;
	}
}

// updates the key ONLY if it changed
function updateKey(name, key, value) {
	if (name != "") {
		// process username with care
		if (key == "IpConfig/Username") {
			if (value != "") {
				document.getElementById('username').innerHTML = "Change to user <b>" + value + "</b> requires password!";
				document.getElementById('psw1').value = "";
				document.getElementById('psw2').value = "";
				overlay();
			}
			else {
				var keys = new Object();
				keys['IpConfig/Username'] = "";
				keys['IpConfig/Password'] = "";

				var update = new Object();
				update['Message'] = "Registry Write";
				update['Keys'] = keys;
				chan.sendJson(update);
			}
		}

  	// only if changed
  	else if (snapText[name] != value) {
			var keys = new Object();
			var update = new Object();
			update['Message'] = "Registry Write";
			keys[key] = value;
			update['Keys'] = keys;
  	  chan.sendJson(update);
  	}
  }
}

function tbox(name, key, node, size) {
	var content = "<tr><th>" + name + "</th>";

	var rkey = node + key;
	if (rkey.startsWith("$"))
		content += "<td class='static'><span name='" + node.toLowerCase() + key.toLowerCase() + "' title='" + rkey + "'></td>";
	else {
		content += "<td><input class='field' type='text' name='" + node.toLowerCase() + key.toLowerCase() + "' title='" + rkey;
		if (size == 0 || size == undefined)
			content += "' style='width:100%;'></td></tr>";
		else
			content += "' size='" + size + "'></td></tr>";
	}
	return content;
}

function updateSelect() {
	if (this.name === "email") {
		showProfile(this.value);
	}
	else if (this.name != "") {
		var keys = new Object();
		var update = new Object();
		update['Message'] = "Registry Write";
		keys[this.title] = this.value;
		update['Keys'] = keys;
		chan.sendJson(update);
	}
}

function showProfile(val) {
	node = "Email/" + val + "/";
	if (val === "<default>") {
		val = "&lt;default&gt;";
		node = "Email/";
	}
	document.getElementById('ehead').innerHTML = "eMail Profile: " + val;

	var ent = new Array();
	var content = "<table class='econf'>";
	content += tbox("To Address", "ToAddress", node);
	ent[0] = node + "ToAddress";
	content += tbox("Cc Address", "CcAddress", node);
	ent[1] = node + "CcAddress";
	content += tbox("Bcc Address", "BccAddress", node);
	ent[2] = node + "BccAddress";
	content += tbox("Subject", "Subject", node);
	ent[3] = node + "Subject";
	content += tbox("Message", "Message", node);
	ent[4] = node + "Message";
	content += tbox("Message File", "MessageFile", node);
	ent[5] = node + "MessageFile";
	content += tbox("Attachments", "Attachments", node);
	ent[6] = node + "Attachments";

	if (node === "Email/") {
		content += tbox("Signature", "Signature", node);
		ent[7] = node + "Signature";
	}

	content += "</table>";

	document.getElementById('econf').innerHTML = content;
	setevents();

	var request = new Object();
	request['Message'] = "Registry Read";
	request['Keys'] = ent;
  chan.sendJson(request);
}

function init() {
	// Assign events to controls
	setevents();

	// establish connection
	chan.connect();

	// initialize file folders
	finit();

	// initialize Registry Editor
	regexpand("");

	// establish 1 seconds polling for external devices
	if (dopoll)
		window.setInterval(poll, 1000);
}

function setevents() {
  // Assign onclick events to checkboxes
  // Assign onmouseover events to checkboxes
  // Assign onfocus events to text inputs
  // Assign onmouseover events to text inputs
  // Assign onblur (losing focus) events to text inputs
  // Assign onkeydown events to text boxes
  var InputItems = document.getElementsByTagName('input');

  for (var i = 0; i < InputItems.length; i++) {
  	if (InputItems[i].type.toLowerCase() == 'checkbox') {
  		if (!InputItems[i].name.startsWith("Applications")) {
    		InputItems[i].onclick = updateCheckbox;
    		InputItems[i].onmouseover = updateHelp;
    	}
  	}
  	else if (InputItems[i].type.toLowerCase() == 'text') {
  		InputItems[i].onfocus = snapTextbox;
  		InputItems[i].onblur = updateTextbox;
  		InputItems[i].onkeydown = textKeydown;
   		InputItems[i].onmouseover = updateHelp;
  	}
  	else if (InputItems[i].type.toLowerCase() == 'select-one') {
 			InputItems[i].onblur = updateSelect;
   		InputItems[i].onmouseover = updateHelp;
  	}
  }

	// Assign onchange events to selection drop-downs
  var InputItems = document.getElementsByTagName('select');

  for (var i = 0; i < InputItems.length; i++) {
  	if (InputItems[i].type.toLowerCase() == 'select-one') {
  		InputItems[i].onchange = updateSelect;
   		InputItems[i].onmouseover = updateHelp;
  	}
  }
}

function LoadEmail(obj) {
	var nodelink = obj.href;
	var hashpos = nodelink.lastIndexOf('#');
	var key = nodelink.substring(hashpos + 1);

  document.getElementById('ehead').innerHTML = "eMail Profile : " + key;

	if (key === "<default>")
		key = "/Email";
	else
		key = "/Email/" + key;

  var meta = new Object();
  meta['Op'] = "email";
  meta['Node'] = key;

  var request = new Object();
  request['Message'] = "Registry List";
  request['Meta'] = meta;
  request['Node'] = key;
  chan.sendJson(request);
}

function overlay() {
	document.getElementById('ovrerr').innerHTML = "";
	document.getElementById('psw1').value = "";
	document.getElementById('psw2').value = "";
	el = document.getElementById("overlay");
	el.style.display = getComputedStyle(el).getPropertyValue('display') == "none" ? "inherit" : "none";
	document.getElementById('psw1').focus();
}

function psw2key(evt) {
	if (evt.keyCode == 13)
		overlayOK();
}

function overlayCancel() {
	var el = document.getElementsByName('ipconfig/username');
	el.value = snapText['ipconfig/username'];
	overlay();
}

function overlayOK() {
	psw1 = document.getElementById('psw1').value;
	psw2 = document.getElementById('psw2').value;
	user = document.getElementsByName('ipconfig/username')[0].value;

	document.getElementById('psw1').value = "";
	document.getElementById('psw2').value = "";

	if (psw1 != psw2) {
		document.getElementById('ovrerr').innerHTML = "ERROR! Paswords do not match!";
	}
	else {
		var keys = new Object();
		keys['IpConfig/Username'] = user;
		if (psw1 == "")
			keys['IpConfig/Password'] = "";

		var update = new Object();
		update['Message'] = "Registry Write";
		update['Keys'] = keys;
		chan.sendJson(update);

		if (psw1 != "") {
			var keys = new Object();
			keys['IpConfig/Password'] = user + ':' + psw1;

			var update = new Object();
			update['Message'] = "Registry Write Encrypted";
			update['Keys'] = keys;
			chan.sendJson(update);
		}

		overlay();
	}
}

function profile() {
	document.getElementById('proferr').innerHTML = "";
	document.getElementById('prof').value = "";
	el = document.getElementById("profile");
	el.style.display = getComputedStyle(el).getPropertyValue('display') == "none" ? "inherit" : "none";
	document.getElementById('prof').focus();
}

function profkey(evt) {
	if (evt.keyCode == 13)
		profileOK();
}

function profileOK() {
	prof = document.getElementById('prof').value;

	if (prof == "") {
		document.getElementById('proferr').innerHTML = "ERROR! No profile name entered!";
	}
	else {
		var sel = document.getElementById('emailsel');
		var content = sel.innerHTML;
		if (content.indexOf(">" + prof + "<") == -1) {
			content += "<option>" + prof + "</option>";
			sel.innerHTML = content;
		}
		sel.value = prof;
		profile();
		showProfile(prof);
	}
}

function login() {
	el = document.getElementById('login');
	var disp = getComputedStyle(el).getPropertyValue('display');
	if (disp == "none") {
		document.getElementById('psw').value = "";
		el.style.display = "inherit";
		document.getElementById('user').focus();
	}
}

function loginkey(evt) {
	if (evt.keyCode == 13)
		loginOK();
}

function loginOK() {
	username = document.getElementById('user').value;
	password = document.getElementById('psw').value;
	chan.authenticate(username, password);

	el = document.getElementById('login');
	el.style.display = "none";
}

function toggle(channel) {
	var request = new Object();
	request['Message'] = "Control";
	request['Command'] = "Toggle";
	request['Channel'] = channel;
	chan.sendJson(request);
}

function dosearch(mode) {
  el = document.getElementById("search");
  switch (mode) {
    case 0: // cancel
      el.style.display = "none";
      break;

    case 1: //show
      el.addEventListener("keydown", submitOnEnter);
      el.style.display = "inherit";
      document.getElementById("query").focus();
      break;

    case 2: // OK
      query = document.getElementById('query').value;
      el.style.display = "none";
      window.open("query.cgi?help=*" + query.trim(), "_blank");
      break;
  }
}

function submitOnEnter(evt) {
	if (evt.keyCode == 13)
    dosearch(2);
}

