/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.ExternalModules;
import com.integpg.janoslib.externalio.Type28;
import com.integpg.janoslib.externalio.Type7E;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.snmp.Config;
import com.integpg.snmp.ExternalTempToSnmp;
import com.integpg.snmp.SNMPStore;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.system.JANOS;
import java.text.DecimalFormat;
import java.util.Hashtable;

class ExternalModuleInteregator
implements Runnable {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000");
    private static Thread _thread;
    private String[] _allDeviceTypeOrderStrings;
    private long _lastDeviceOrderRegistryModifiedTime = 0L;
    private Hashtable<String, ExternalTempToSnmp> _moduleCache = new Hashtable();

    ExternalModuleInteregator() {
    }

    static void start() {
        if (null == _thread) {
            ExternalModuleInteregator externalModuleInteregator = new ExternalModuleInteregator();
            _thread = new Thread(externalModuleInteregator);
            _thread.setName(externalModuleInteregator.getClass().getName());
            _thread.start();
        }
    }

    @Override
    public void run() {
        while (true) {
            this.doLoop();
            this.doSleep();
        }
    }

    private void doLoop() {
        String externalDeviceOrderRegistryFolderString = "Externals/DeviceOrder";
        long deviceOrderRegistryModifiedTime = JANOS.getRegistryLastModified((String)externalDeviceOrderRegistryFolderString);
        if (this._lastDeviceOrderRegistryModifiedTime < deviceOrderRegistryModifiedTime) {
            AppLog.info("get registry listing for device order");
            this._allDeviceTypeOrderStrings = JANOS.getRegistryList((String)"Externals/DeviceOrder");
            this._lastDeviceOrderRegistryModifiedTime = deviceOrderRegistryModifiedTime;
        }
        if (null != this._allDeviceTypeOrderStrings) {
            for (String moduleTypeOrder : this._allDeviceTypeOrderStrings) {
                boolean shouldUpdateSnmp = Config.getShouldUpdateSnmpWithModuleValues(moduleTypeOrder);
                if (!shouldUpdateSnmp) continue;
                long start = System.currentTimeMillis();
                int moduleIndex = Integer.valueOf(moduleTypeOrder.substring(7));
                String addressString = JANOS.getRegistryString((String)("Externals/DeviceOrder/" + moduleTypeOrder), (String)"");
                long address = HexUtils.parseHexAsLong(addressString);
                try {
                    ExternalModule externalModule = ExternalModules.getDeviceObject(address);
                    externalModule.TypeString = moduleTypeOrder;
                    externalModule.read();
                    if (externalModule instanceof Type28) {
                        if (!this._moduleCache.containsKey(addressString)) {
                            this._moduleCache.put(addressString, new ExternalTempToSnmp((Type28)externalModule, moduleIndex));
                        }
                        ExternalTempToSnmp moduleUpdater = this._moduleCache.get(addressString);
                        moduleUpdater.update();
                    } else if (externalModule instanceof Type7E) {
                        this.updateEnvironmentalSensor((Type7E)externalModule, moduleIndex);
                    } else if (externalModule instanceof TypeFD) {
                        this.updateTenVoltModule((TypeFD)externalModule, moduleIndex);
                    } else if (externalModule instanceof TypeFE) {
                        this.updateFourTwentyModule((TypeFE)externalModule, moduleIndex);
                    }
                }
                catch (Throwable ex) {
                    AppLog.error("error reading " + addressString, ex);
                }
                long elapsed = System.currentTimeMillis() - start;
                System.out.println(String.format("took %lld to update %s (%s)", elapsed, moduleTypeOrder, addressString));
            }
        }
    }

    private void updateTemperatureProbe(Type28 type28, int moduleIndex) {
        int type = 40;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, (SNMPObject)new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type28.getTempC())));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type28.getTempF())));
    }

    private void updateEnvironmentalSensor(Type7E type7E, int moduleIndex) {
        int type = 126;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, (SNMPObject)new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type7E.getTempC())));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type7E.getTempF())));
        SNMPStore.insertPair(baseOid + "4." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type7E.getHumidity())));
    }

    private void updateTenVoltModule(TypeFD typeFD, int moduleIndex) {
        int type = 253;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, (SNMPObject)new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(1))));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(2))));
        SNMPStore.insertPair(baseOid + "4." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(3))));
        SNMPStore.insertPair(baseOid + "5." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(4))));
        SNMPStore.insertPair(baseOid + "6." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledOutput(1))));
        SNMPStore.insertPair(baseOid + "7." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledOutput(2))));
    }

    private void updateFourTwentyModule(TypeFE typeFE, int moduleIndex) {
        int type = 254;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, (SNMPObject)new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(1))));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(2))));
        SNMPStore.insertPair(baseOid + "4." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(3))));
        SNMPStore.insertPair(baseOid + "5." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(4))));
        SNMPStore.insertPair(baseOid + "6." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledOutput(1))));
        SNMPStore.insertPair(baseOid + "7." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledOutput(2))));
    }

    private void doSleep() {
        try {
            int externalQueryInterval = Config.getExternalQueryInterval();
            if (0 >= externalQueryInterval) {
                externalQueryInterval = 15000;
            }
            Thread.sleep(externalQueryInterval);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

