 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: relays.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// Function returns HTML for the 4ROUT module
function device_relays(key) {
	var chs = "ABCD";
	var id = module_keyToId[key];
	
	var status = module_idToStatus[id];
	if (status == 'undefined')
		return;	
	
	var assign = key.substring(key.length - 2);

	// prefix output description with digital relay rout#
	var ofs = -1;	
	if (assign == "_1")
		ofs = 1;
	else if (assign == "_2")
		ofs = (jnior_model == 412) ? -1 : 5;
	else if (assign == "_3")
		ofs = (jnior_model == 414) ? 9 : -1;
		
	var modkey = "Externals/" + id + "/";
	var desc = getkey(modkey + "Desc", "Digital 4ROUT");		
	
	var inner = "<td name='fb'>";
	inner += "<p class='modname'><span name='" + key + "'>" + desc + "</span></p>";
	inner += "<p class='modaddr'>" + id + "</p>";
	inner += "<div class='modio'>";
	inner += "<table class='relayleft'>";

	for (var n = 0; n < 4; n++) {
		var chkey = modkey + "Rout" + chs[n] + "/";
		var idn = "rout:" + n + ":" + id;

		// get realy configuration details
		var desc_key = chkey + "Desc";
		var desc_val = getkey(desc_key, "Relay Output " + chs[n]);
		var on_key = chkey + "OnText";
		var on_val = getkey(on_key, "ON");
		var off_key = chkey + "OffText";
		var off_val = getkey(off_key, "OFF");
		var enab_key = chkey + "Enable";
		var enab_val = istrue(getkey(enab_key, "enabled"));
		
		if (n == 2)
			inner += "</table><table class='relayright'>";
			
		inner += "<tr><td>";
		if (enab_val) {
			inner += "<div class='fbname'>";
		
			if (ofs > 0)
				inner += "<div class='fbpre'>" + (jnior_outputs + ofs + n) + "-</div>";
			inner += "<div name='" + keystd(desc_key) + "'>" + desc_val + "</div></div>";
	
			// fetch I/O state
			var mask = (1 << n);
			var state = parseInt(status.substring(2, 4), 16) & mask;
	
			// include controls if appropriate		
			if (jnior_control)
				inner += "<div class='fbctrl'><button onclick='exttoggle(\"" + id + "\"," + mask + ");'>Toggle</button></div>";
			
			// display state
			if (state) 
				inner += "<div class='fbstate on' id='" + idn + "' name='" + keystd(on_key) + "'>" + on_val + "</div>";
			else 
				inner += "<div class='fbstate off' id='" + idn + "' name='" + keystd(off_key) + "'>" + off_val + "</div>";
		}
		inner += "</td></tr>";
	}
	inner += "</table>";
	inner += "</div>";
	inner += "</td>";
	return inner;
}

// Function updates 4ROUT Module block content
function update_relays(key) {
	var id = module_keyToId[key];
	
	var status = module_idToStatus[id];
	if (status == null)
		return;	

	var chs = "ABCD";
	var modkey = "Externals/" + id + "/";

	// update relay status
	for (var n = 0; n < 4; n++) {
		var chkey = modkey + "Rout" + chs[n] + "/";
		var idn = "rout:" + n + ":" + id;

		var on_key = chkey + "OnText";
		var on_val = getkey(on_key, "ON");
		var off_key = chkey + "OffText";
		var off_val = getkey(off_key, "OFF");
		
		var elem = document.getElementById(idn);
		if (elem) {

			// fetch I/O state
			var mask = (1 << n);
			var state = parseInt(status.substring(2, 4), 16) & mask;
			
			elem.className = state != 0 ? "fbstate on" : "fbstate off";
			elem.name = state != 0? keystd(on_key) : keystd(off_key);
			elem.innerHTML = state != 0 ? on_val : off_val;	
		}
	}

	return false;
}


function exttoggle(id, mask) {
	var devices = new Object();
	devices['Address'] = id;
	
	var status = module_idToStatus[id];
	var state = (parseInt(status.substring(2, 4), 16) & mask) ^ mask;
	
	mask &= 0x0f;
	state &= 0x0f;
	devices['Hex'] = "0" + mask.toString(16) + "0" + state.toString(16) + "0000000000000000";
	
	var request = new Object();
	request['Message'] = "Write Devices";
	request['Devices'] = new Array(devices);
	chan.sendJson(request);
	
	var request = new Object();
	request['Message'] = "Read Devices";
	request['Devices'] = new Array(id);
	chan.sendJson(request);
}

