/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.io;

import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.io.Log;
import com.integpg.janoslib.io.RollingMemoryLog;
import com.integpg.janoslib.io.RollingMemoryLogService;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.janoslib.system.MinimumVersion;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.JANOS;

public class AppLog {
    private static final boolean REQUIRED_OS_VERSION = MinimumVersion.atLeast("SysLog", "1.3-b10");
    private static QuickDateFormat _dateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss zzz");
    private static Log _log;
    private static Log _debugLog;
    private static Log _exceptionLog;
    private static boolean _warnSysLog;
    private static boolean _logErrorOccured;

    private static synchronized void ensureLogFile() {
        try {
            if (_log == null && Application.getAppInstanceName() != null) {
                _log = RollingMemoryLog.getLog(Application.getAppInstanceName() + ".log", 65536);
                _log.setDateFormat(_dateFormat.getDateFormatString());
                _log.writeln("--------------------------------------------------");
            }
            if (_debugLog == null && Application.getAppInstanceName() != null) {
                _debugLog = RollingMemoryLog.getLog(Application.getAppInstanceName() + "_debug.log", 65536);
                _debugLog.setDateFormat(_dateFormat.getDateFormatString());
                boolean shouldLogDebug = JANOS.getRegistryBoolean((String)("AppData/" + Application.getAppName() + "/LogDebug"), (boolean)false);
                if (shouldLogDebug |= DEBUG.ON) {
                    DEBUG.ON = true;
                    _debugLog.writeln("--------------------------------------------------");
                }
            }
            if (_exceptionLog == null && Application.getAppInstanceName() != null) {
                _exceptionLog = RollingMemoryLog.getLog(Application.getAppInstanceName() + "_exception.log", 65536);
                _exceptionLog.setDateFormat(_dateFormat.getDateFormatString());
                _exceptionLog.writeln("--------------------------------------------------");
            }
        }
        catch (Exception ex) {
            StringBuilder sb = new StringBuilder();
            sb.append(_dateFormat.format(System.currentTimeMillis()));
            sb.append(", ");
            sb.append(ex.toString());
            System.err.println(sb.toString());
        }
    }

    public static void setDateFormat(String dateFormat) {
        if (!dateFormat.equals(_dateFormat.getDateFormatString())) {
            System.out.println("Change applog date format to " + dateFormat);
            _dateFormat = new QuickDateFormat(dateFormat);
        }
    }

    public static void setAppLog(Log log) {
        _log = log;
    }

    public static void setAppDebugLog(Log log) {
        _debugLog = log;
    }

    public static void setAppExceptionLog(Log log) {
        _exceptionLog = log;
    }

    public static void debug(Object o) {
        AppLog.debug(o.toString());
    }

    public static void debug(String line) {
        boolean shouldLogDebug = RegistryHelper.getRegistryKey("AppData/" + Application.getAppName() + "/LogDebug", false);
        if (shouldLogDebug |= DEBUG.ON) {
            if (_debugLog != null) {
                _debugLog.debug(line);
            }
            AppLog.sendToSyslogServer(line, 7);
        } else {
            System.out.println(line);
        }
    }

    public static void fatal(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.fatal(line);
        }
        JANOS.syslog((String)line, (int)2, (int)1);
    }

    public static void warn(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.warn(line);
        }
        AppLog.sendToSyslogServer(line, 4);
    }

    public static void error(String error) {
        AppLog.ensureLogFile();
        _log.error(error);
        AppLog.sendToSyslogServer(error, 3);
    }

    public static void error(Throwable ex) {
        String stackTrace = ExceptionHandler.getStackTrace(ex);
        AppLog.ensureLogFile();
        AppLog.anErrorHasOccuredLog();
        if (_exceptionLog != null) {
            _exceptionLog.error(stackTrace);
        }
        AppLog.sendToSyslogServer(ex.toString(), 3);
    }

    public static void error(String description, Throwable ex) {
        String stackTrace = ExceptionHandler.getStackTrace(ex);
        AppLog.ensureLogFile();
        AppLog.anErrorHasOccuredLog();
        if (_exceptionLog != null) {
            _exceptionLog.error(description + ": " + stackTrace);
        }
        AppLog.sendToSyslogServer(description + ": " + ex.toString(), 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void anErrorHasOccuredLog() {
        if (null != _log) {
            Log log = _log;
            synchronized (log) {
                if (_log != null && _logErrorOccured) {
                    _log.error("An ERROR has occured.  Please check the application exception log");
                    _logErrorOccured = false;
                }
            }
        }
    }

    private static void sendToSyslogServer(String message, int level) {
        if (REQUIRED_OS_VERSION) {
            JANOS.syslog((String)message, (int)level, (int)2);
        } else if (_warnSysLog) {
            _log.info("!! Sending to the syslog server requires v1.3 or later");
            _warnSysLog = false;
        }
    }

    public static void info(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.info(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    public static void vital(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.vital(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    public static boolean isBusy() {
        return _log.isBusy() || _exceptionLog.isBusy() || _debugLog.isBusy() || RollingMemoryLogService.isBusy();
    }

    static {
        _warnSysLog = true;
        _logErrorOccured = true;
    }
}

