/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.debug.Stopwatch;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.snmp.AgentInterface;
import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPMessage;
import com.integpg.snmp.objects.SNMPRequestPDU;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class Agent
implements Runnable {
    public static final int SNMP_PORT = 161;
    private static final int RECEIVE_BUFFER_SIZE = 512;
    private DatagramSocket _datagramSocket;
    private Thread _receiveThread;
    private AgentInterface _agentInterface = null;

    public Agent() {
        try {
            this._datagramSocket = new DatagramSocket(161);
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
    }

    public void setAgentInterface(AgentInterface agentInterface) {
        this._agentInterface = agentInterface;
    }

    public void listen() {
        if (null == this._receiveThread) {
            this._receiveThread = new Thread(this);
            this._receiveThread.setName(this.getClass().getName());
            this._receiveThread.setDaemon(true);
            this._receiveThread.start();
        }
    }

    @Override
    public void run() {
        Stopwatch stopwatch = new Stopwatch("snmp");
        AppLog.info("agent listening on port 161");
        while (!this._receiveThread.isInterrupted()) {
            try {
                ByteArrayInputStream bain;
                SNMPCodec codec;
                int tag;
                DatagramPacket inPacket = new DatagramPacket(new byte[512], 512);
                this._datagramSocket.receive(inPacket);
                stopwatch.start();
                InetAddress requesterAddress = inPacket.getAddress();
                int requesterPort = inPacket.getPort();
                byte[] messageBytes = inPacket.getData();
                stopwatch.split("receive data");
                if (DEBUG.ON) {
                    System.out.println(HexUtils.hexDump(messageBytes, 0, inPacket.getLength()));
                    stopwatch.split("print received hex");
                }
                if (48 != (tag = (codec = new SNMPCodec(bain = new ByteArrayInputStream(messageBytes))).read())) {
                    throw new RuntimeException("SNMP Sequence Expected");
                }
                SNMPMessage message = new SNMPMessage();
                message.decodeBER(codec);
                stopwatch.split("snmp message");
                if (DEBUG.ON) {
                    System.out.println("message: " + message);
                    stopwatch.split("print message");
                }
                SNMPRequestPDU pdu = (SNMPRequestPDU)message.getPDU();
                if (null != this._agentInterface) {
                    switch (pdu.getTag()) {
                        case 160: {
                            this._agentInterface.processGetRequest(pdu);
                            stopwatch.split("process getrequest message");
                            break;
                        }
                        case 161: {
                            this._agentInterface.processGetNextRequest(pdu);
                            stopwatch.split("process getnextrequest message");
                        }
                    }
                }
                pdu.setResponse();
                if (DEBUG.ON) {
                    System.out.println("message: " + message);
                    stopwatch.split("print message");
                }
                ByteArrayOutputStream baout = new ByteArrayOutputStream();
                SNMPCodec outCodec = new SNMPCodec(baout);
                message.encodeBER(outCodec);
                byte[] outBytes = baout.toByteArray();
                stopwatch.split("build response");
                if (DEBUG.ON) {
                    System.out.println(HexUtils.hexDump(outBytes, 0, outBytes.length));
                    stopwatch.split("print response hex");
                }
                DatagramPacket outPacket = new DatagramPacket(outBytes, outBytes.length, requesterAddress, requesterPort);
                this._datagramSocket.send(outPacket);
                stopwatch.split("sent");
                stopwatch.stop();
                if (!DEBUG.ON) continue;
                System.out.println(stopwatch);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

