/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager.externals;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.TaskManager.externals.ExternalModuleInfo;
import java.io.IOException;

public class ExternalChannelInfo {
    public static final int IN = 0;
    public static final int OUT = 1;
    private final ExternalModuleInfo _externalModuleInfo;
    private final int _direction;
    private final int _channel;
    private String _channelRegKey;

    public ExternalChannelInfo(ExternalModuleInfo externalModuleInfo, int direction, int channel) {
        this._externalModuleInfo = externalModuleInfo;
        this._direction = direction;
        this._channel = channel;
        this._channelRegKey = "externals/" + this.getAddressString() + "/";
        this._channelRegKey = 0 == direction ? this._channelRegKey + "ain" + channel : this._channelRegKey + "aout" + channel;
    }

    public ExternalModuleInfo getExternalModuleInfo() {
        return this._externalModuleInfo;
    }

    public void refreshDevice() throws IOException {
        this._externalModuleInfo.refreshDevice();
    }

    public String getAddressString() {
        return this._externalModuleInfo.getAddressString();
    }

    public long getAddress() {
        return this._externalModuleInfo.getAddress();
    }

    public int getChannel() {
        return this._channel;
    }

    public boolean hasDeviceChanged() {
        return this._externalModuleInfo.hasDeviceChanged();
    }

    public double getValue() {
        System.out.println(this._externalModuleInfo.getAddressString() + " " + this._channel);
        return this._externalModuleInfo.getValue(this._direction, this._channel);
    }

    public double getScaledValue() {
        double value = this.getValue();
        double min = EmbeddedBase.BASE.m_jnioros.getRegistryDouble(this._channelRegKey + "/min", 4.0);
        double max = EmbeddedBase.BASE.m_jnioros.getRegistryDouble(this._channelRegKey + "/max", 20.0);
        value = value / 65520.0 * (max - min) + min;
        return value;
    }
}

