/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Helpers.Masks;

public class DaysMask {
    public static final String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    public static final int WEEKDAYS = 62;
    public static final int WEEKENDS = 65;
    private int m_daysMask;

    public DaysMask(int n) throws IllegalArgumentException {
        if (n < 0 || n > 127) {
            throw new IllegalArgumentException("Days Mask Out of Range");
        }
        this.m_daysMask = n;
    }

    public int getDaysMask() {
        return this.m_daysMask;
    }

    public boolean isValidDay(int n) {
        return (this.m_daysMask & 1 << n - 1) != 0;
    }

    public String toString() {
        String string = new String();
        if (this.m_daysMask == 62) {
            string = "Weekdays";
        } else if (this.m_daysMask == 65) {
            string = "Weekends";
        } else {
            for (int i = 0; i < 7; ++i) {
                if (!this.isValidDay(i + 1)) continue;
                if (!string.equals("")) {
                    string = string + ", ";
                }
                string = string + DAYS[i];
            }
        }
        return string;
    }
}

