/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices.Externals;

import JniorProtocol.Devices.Externals.Externals;
import JniorProtocol.JniorSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ExternalTypeFB
extends Externals {
    private byte[] m_states = new byte[4];
    private byte[] m_newStates = new byte[4];
    private int[] m_pulseDuration = new int[4];
    private int[] m_pulseRemaining = new int[4];
    private byte m_channelMask;

    public ExternalTypeFB(JniorSession jniorSession, long l) {
        super(jniorSession, l);
        this.m_description = "4ROUT Digital Module";
    }

    public byte getState(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        return this.m_states[n - 1];
    }

    public void open(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        this.m_channelMask = (byte)(this.m_channelMask | 1 << n - 1);
        this.m_newStates[n - 1] = 0;
    }

    public void close(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        this.m_channelMask = (byte)(this.m_channelMask | 1 << n - 1);
        this.m_newStates[n - 1] = 1;
    }

    public void toggle(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        this.m_channelMask = (byte)(this.m_channelMask | 1 << n - 1);
        this.m_newStates[n - 1] = (byte)((this.m_newStates[n - 1] + 1) % 2);
    }

    public void pulse(int n, int n2, int n3) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        this.m_channelMask = (byte)(this.m_channelMask | 1 << n - 1);
        this.m_newStates[n - 1] = (byte)n2;
        this.m_pulseDuration[n - 1] = n3;
    }

    public void setMask(int n, int n2) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        this.m_channelMask = (byte)n;
        if (n2 < 0 || n2 > 15) {
            throw new IllegalArgumentException("States Out of Range.");
        }
        this.m_newStates[0] = (byte)(n2 & 1);
        this.m_newStates[1] = (byte)(n2 >> 1 & 1);
        this.m_newStates[2] = (byte)(n2 >> 2 & 1);
        this.m_newStates[3] = (byte)(n2 >> 3 & 1);
    }

    public String toString() {
        String string = this.m_hexAddress + " : " + this.m_description + " : ";
        string = string + this.m_states[0] + ", " + this.m_states[1] + ", " + this.m_states[2] + ", " + this.m_states[3];
        return string;
    }

    public byte[] getWriteBytes() {
        byte[] byArray = new byte[10];
        byArray[0] = this.m_channelMask;
        this.m_channelMask = 0;
        byArray[1] = (byte)((this.m_newStates[3] << 3) + (this.m_newStates[2] << 2) + (this.m_newStates[1] << 1) + this.m_newStates[0]);
        ExternalTypeFB.setShort(byArray, 2, (short)this.m_pulseDuration[0]);
        ExternalTypeFB.setShort(byArray, 4, (short)this.m_pulseDuration[1]);
        ExternalTypeFB.setShort(byArray, 6, (short)this.m_pulseDuration[2]);
        ExternalTypeFB.setShort(byArray, 8, (short)this.m_pulseDuration[3]);
        this.m_pulseDuration[0] = 0;
        this.m_pulseDuration[1] = 0;
        this.m_pulseDuration[2] = 0;
        this.m_pulseDuration[3] = 0;
        return byArray;
    }

    public void receive(ByteArrayInputStream byteArrayInputStream) {
        try {
            short s = (byte)ExternalTypeFB.get(byteArrayInputStream);
            short s2 = (byte)ExternalTypeFB.get(byteArrayInputStream);
            this.m_newStates[0] = this.m_states[0] = (byte)(s2 & 1);
            this.m_newStates[1] = this.m_states[1] = (byte)((s2 & 2) >> 1);
            this.m_newStates[2] = this.m_states[2] = (byte)((s2 & 4) >> 2);
            this.m_newStates[3] = this.m_states[3] = (byte)((s2 & 8) >> 3);
            this.m_pulseRemaining[0] = ExternalTypeFB.getShort(byteArrayInputStream);
            this.m_pulseRemaining[1] = ExternalTypeFB.getShort(byteArrayInputStream);
            this.m_pulseRemaining[2] = ExternalTypeFB.getShort(byteArrayInputStream);
            this.m_pulseRemaining[3] = ExternalTypeFB.getShort(byteArrayInputStream);
            this.fireStateChange();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

