/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.TextReplacer;
import com.integ.tasker.devices.Device;
import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.SNMPDevice;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.web.handlers.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import com.integpg.system.SystemMsg;
import java.util.Json;

public class SNMPTrapMethod
extends Action {
    public SNMPTrapMethod(Task parentTask, Json json) {
        super(parentTask, json);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            String deviceGuid = this._paramsJson.getString("DeviceGUID");
            String oid = this._paramsJson.getString("OID");
            String message = this._paramsJson.getString("Message");
            message = TextReplacer.replace(message, taskRuntime.Scope);
            try {
                if (null == deviceGuid || "".equals(deviceGuid)) {
                    throw new RuntimeException("No device was selected for this SNMP Trap");
                }
                Device device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
                if (null == device) {
                    throw new RuntimeException("No device found for " + deviceGuid);
                }
                if (!(device instanceof SNMPDevice)) {
                    throw new RuntimeException("Device found for " + deviceGuid + " is not a SNMP Device");
                }
                SNMPDevice snmpDevice = (SNMPDevice)device;
                String host = snmpDevice.getIpAddress();
                int port = snmpDevice.getPort();
                String communityName = snmpDevice.getCommunityName();
                try {
                    Json jsonMessage = new Json();
                    jsonMessage.put("host", (Object)host);
                    jsonMessage.put("port", port);
                    jsonMessage.put("oid", (Object)oid);
                    jsonMessage.put("community-name", (Object)communityName);
                    jsonMessage.put("value", (Object)message);
                    jsonMessage.put("type", (Object)"string");
                    SystemMsg systemMsg = new SystemMsg();
                    systemMsg.type = 3001;
                    systemMsg.msg = jsonMessage.toString().getBytes();
                    MessagePumpEngine.postMessage(systemMsg);
                }
                catch (Exception ex) {
                    throw new RuntimeException(String.format("Error sending trap %s for oid %s to %s:%d - %s", message, oid, host, port, ex.getMessage()));
                }
            }
            catch (Exception ex) {
                AppLog.warn(ex.getMessage());
                ErrorMessage errorMessage = new ErrorMessage(ex.getMessage());
                MessagePumpEngine.postMessage(errorMessage.build());
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing SNMP Trap").initCause(ex);
        }
    }
}

