/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.slaveservice;

import com.integpg.janoslib.io.AppLog;
import com.integpg.slaveservice.SlaveService;
import com.integpg.system.JANOS;
import java.io.IOException;

public class LocalSlaveService
extends SlaveService {
    @Override
    protected void monitor() {
        AppLog.info("Starting Local Slave Service");
        this._monitorThread = new Thread(this);
        this._monitorThread.setDaemon(true);
        this._monitorThread.setName("Local Slave Service");
        this._monitorThread.start();
    }

    @Override
    public void run() {
        AppLog.info("Local Slave Service has started");
        this._running = true;
        while (this._running) {
            int newOutputs = 0;
            if (this._followedInputMask != 0) {
                newOutputs |= this.trackInputs();
            }
            if (this._followedOutputMask != 0) {
                newOutputs |= this.trackOutputs();
            }
            try {
                JANOS.setOutputStates((int)newOutputs, (int)this._usedOutputMask);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        AppLog.info("Local Slave Service has stopped");
    }

    @Override
    public int trackInputs() {
        int inputs = JANOS.getInputStates();
        int newOutputs = 0;
        for (int channel = 0; channel < 12; ++channel) {
            int state;
            if ((this._followedInputMask >> channel & 1) == 0 || (state = inputs >> channel & 1) != 1) continue;
            int outputChannel = this._inputs[channel];
            newOutputs |= 1 << outputChannel;
        }
        return newOutputs;
    }

    @Override
    public int trackOutputs() {
        int outputs = JANOS.getOutputStates();
        int newOutputs = 0;
        for (int channel = 0; channel < 12; ++channel) {
            int state;
            if ((this._followedOutputMask >> channel & 1) == 0 || (state = outputs >> channel & 1) != 1) continue;
            int outputChannel = this._outputs[channel];
            newOutputs |= 1 << outputChannel;
        }
        return newOutputs;
    }
}

