/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol;

import JniorProtocol.Helpers.Debug.Debug;
import JniorProtocol.JniorSession;
import JniorProtocol.Listeners.ConnectionListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Vector;

public class SessionServer
implements Runnable {
    private Vector m_connectionListeners = new Vector();
    private ServerSocketChannel svrSocketChannel;
    private Vector connections = new Vector();
    private boolean bServerRun = true;

    public SessionServer(int n) {
        try {
            this.svrSocketChannel = ServerSocketChannel.open();
            this.svrSocketChannel.configureBlocking(true);
            this.svrSocketChannel.socket().bind(new InetSocketAddress(n));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.m_connectionListeners.add(connectionListener);
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stop() {
        this.bServerRun = false;
    }

    public void run() {
        try {
            while (this.bServerRun) {
                SocketChannel socketChannel = this.svrSocketChannel.accept();
                int n = this.svrSocketChannel.socket().getLocalPort();
                Debug.log("Connection received on port " + n);
                JniorSession jniorSession = new JniorSession();
                for (int i = 0; i < this.m_connectionListeners.size(); ++i) {
                    jniorSession.addConnectionListener((ConnectionListener)this.m_connectionListeners.get(i));
                }
                jniorSession.setSocketChannel(socketChannel);
                this.connections.addElement(jniorSession);
            }
        }
        catch (IOException iOException) {
            if (this.bServerRun) {
                iOException.printStackTrace();
            }
            this.bServerRun = false;
        }
    }
}

