/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.tasker.Unloadable;
import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.triggers.TriggerMonitor;
import com.integ.tasker.triggers.TriggerProfile;
import com.integ.tasker.triggers.TriggerProfilesCollection;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.Json;

public class TriggersConfiguration
implements Unloadable {
    public static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_triggers.log").setLogType(LogTypes.HalfBak));
    private final WorkspaceConfigurationFile _workspaceConfigurationFile;
    private final TriggerMonitor _triggerMonitor;

    public TriggersConfiguration(WorkspaceConfigurationFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
        this._triggerMonitor = new TriggerMonitor(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
    }

    public WorkspaceConfigurationFile getWorkspaceConfigurationFile() {
        return this._workspaceConfigurationFile;
    }

    public TriggerMonitor getTriggerMonitor() {
        return this._triggerMonitor;
    }

    public void loadConfiguration(Json[] triggerListJsonArray) throws Throwable {
        if (null == triggerListJsonArray || 0 == triggerListJsonArray.length) {
            return;
        }
        TriggerProfilesCollection.clear();
        for (Json triggerJson : triggerListJsonArray) {
            TriggerProfile triggerProfile = new TriggerProfile(this, triggerJson);
            TriggerProfilesCollection.put(triggerProfile.getName(), triggerProfile);
        }
        this._triggerMonitor.start();
    }

    @Override
    public void unload() {
        this._triggerMonitor.stop();
    }
}

