/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager.Watcher;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.EmbeddedHelpers.Monitor.IOStateListener;
import com.integpg.EmbeddedHelpers.Monitor.IOStateMonitor;
import com.integpg.EmbeddedHelpers.ThreadWatchdog;
import com.integpg.TaskManager.Event.EventData;
import com.integpg.TaskManager.TaskManager;
import com.integpg.TaskManager.Watcher.WatcherEvent;
import com.integpg.TaskManager.Watcher.WatcherListener;
import integpg.JniorOS;
import java.io.IOException;

public class Watcher
implements IOStateListener,
Runnable {
    private Thread thd;
    private boolean running;
    public static final int REGISTRY_WATCHER = 0;
    public static final int STATE_WATCHER = 3;
    public static final int COUNTER_WATCHER = 1;
    public static final int USAGE_WATCHER = 4;
    public static final int ANALOGUP_WATCHER = 5;
    public static final int ANALOGDOWN_WATCHER = 6;
    public static final int INT_DIN = 0;
    public static final int INT_ROUT = 1;
    public static final int EXT_8TEMP = 2;
    public static final int EXT_8TEMP_ID = 16;
    public static final int EXT_12TEMP = 3;
    public static final int EXT_12TEMP_ID = 40;
    public static final int EXT_ROUT = 4;
    public static final int EXT_ROUT_ID = 251;
    public static final int EXT_RTD = 5;
    public static final int EXT_RTD_ID = 252;
    public static final int EXT_10vIN = 6;
    public static final int EXT_10vIN_ID = 253;
    public static final int EXT_10vOUT = 7;
    public static final int EXT_10vOUT_ID = 253;
    public static final int EXT_420mAIN = 8;
    public static final int EXT_420mAIN_ID = 254;
    public static final int EXT_420mAOUT = 9;
    public static final int EXT_420mAOUT_ID = 254;
    public static final int INT_DIN_9_12 = 10;
    public static final double maxxy = 65520.0;
    public static final int STATE_RISING = 1;
    public static final int STATE_FALLING = 2;
    public static final int STATE_EITHER = 3;
    int type;
    String key;
    String value;
    int setPoint;
    int ioNumber;
    long prevValue;
    boolean reset = true;
    private int[] exts;
    public EventData event;
    private WatcherListener listener;

    public Watcher(int t, String s, String en) {
        this.type = t;
        this.key = s;
        this.event = TaskManager.loadEvent("Schedule/Events/" + en + "/");
    }

    public Watcher(int t, int ioNumber, int value, EventData evt) {
        this.type = t;
        this.ioNumber = ioNumber - 1;
        this.setPoint = value;
        this.event = (EventData)evt.clone();
    }

    public Watcher(int t, int ioNumber, EventData evt) {
        this.type = t;
        this.ioNumber = ioNumber;
        this.event = evt;
    }

    public void setWatcherListener(WatcherListener wl) {
        this.listener = wl;
    }

    public void start() {
        int[] vers = null;
        try {
            vers = EmbeddedBase.BASE.m_jnioros.getVersion();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.type == 3 && vers != null && vers[0] >= 4) {
            System.out.println("IOStateMonitor " + this.ioNumber);
            if (8 > this.ioNumber) {
                IOStateMonitor.getInstance().addStateListener(this, 0, this.ioNumber + 1);
            } else if (80 <= this.ioNumber) {
                IOStateMonitor.getInstance().addStateListener(this, 0, this.ioNumber - 71);
            } else {
                IOStateMonitor.getInstance().addStateListener(this, 1, this.ioNumber - 7);
            }
        } else {
            this.thd = new Thread((Runnable)this, "Watcher");
            ThreadWatchdog.getInstance().addThread(this.thd);
            this.exts = TaskManager.exts;
            this.thd.start();
        }
    }

    public void stop() {
        if (8 > this.ioNumber) {
            IOStateMonitor.getInstance().removeStateListener(this, 0, this.ioNumber + 1);
        } else if (80 <= this.ioNumber) {
            IOStateMonitor.getInstance().removeStateListener(this, 0, this.ioNumber - 71);
        } else {
            IOStateMonitor.getInstance().removeStateListener(this, 1, this.ioNumber - 7);
        }
        this.running = false;
        System.out.println("Stopping IO Monitor from Watcher");
        IOStateMonitor.getInstance().stop();
    }

    private long getIOFromNumber(int iONumber) throws IOException {
        int halfmax = 3;
        int devtype = iONumber / 8;
        int channel = iONumber % 8;
        int extoff = 0;
        if (devtype == 0) {
            return EmbeddedBase.BASE.m_jnioros.getInputStates() & 1 << channel;
        }
        if (devtype == 10) {
            int channelMask = 1 << channel + 8;
            return EmbeddedBase.BASE.m_jnioros.getInputStates() & channelMask;
        }
        if (devtype == 1) {
            return EmbeddedBase.BASE.m_jnioros.getOutputStates() & 1 << channel;
        }
        if (devtype == 4) {
            return EmbeddedBase.BASE.m_jnioros.getOutputStates() & 1 << channel - extoff + 8;
        }
        if (devtype == 8) {
            if ((this.exts[1] != 254 || this.exts[0] != 254) && channel > halfmax) {
                extoff = halfmax + 1;
            }
            double analog = EmbeddedBase.BASE.m_jnioros.get420In(channel - extoff);
            return (long)(analog *= 1000.0);
        }
        if (devtype == 9) {
            if ((this.exts[1] != 254 || this.exts[0] != 254) && channel > halfmax) {
                extoff = halfmax + 1;
            } else if (channel > halfmax) {
                extoff = 2;
            }
            double analog = EmbeddedBase.BASE.m_jnioros.get420Out(channel - extoff);
            return (long)(analog *= 1000.0);
        }
        if (devtype == 6) {
            if ((this.exts[1] != 253 || this.exts[0] != 253) && channel > halfmax) {
                extoff = halfmax + 1;
            }
            double analog = EmbeddedBase.BASE.m_jnioros.get10vIn(channel - extoff);
            return (long)(analog *= 1000.0);
        }
        if (devtype == 7) {
            if ((this.exts[1] != 253 || this.exts[0] != 253) && channel > halfmax) {
                extoff = halfmax + 1;
            } else if (channel > halfmax) {
                extoff = 2;
            }
            double analog = EmbeddedBase.BASE.m_jnioros.get10vOut(channel - extoff);
            return (long)(analog *= 1000.0);
        }
        if (devtype == 2 || devtype == 3) {
            double analog;
            if ((this.exts[1] != 16 && this.exts[1] != 40 || this.exts[0] != 16 && this.exts[0] != 40) && channel > halfmax) {
                extoff = halfmax + 1;
            } else if (channel > halfmax) {
                extoff = 3;
            }
            try {
                analog = EmbeddedBase.BASE.m_jnioros.getTemp(channel - extoff);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                analog = 0.0;
            }
            return (long)(analog *= 1000.0);
        }
        if (devtype == 5) {
            if ((this.exts[1] != 252 || this.exts[0] != 252) && channel > halfmax) {
                extoff = halfmax + 1;
            }
            double analog = EmbeddedBase.BASE.m_jnioros.getRtdIn(channel - extoff);
            return (long)(analog *= 100.0);
        }
        return -1L;
    }

    @Override
    public void run() {
        JniorOS jnioros = EmbeddedBase.BASE.m_jnioros;
        String stringTemp = new String();
        System.out.println("TYPE: " + this.type);
        System.out.println("IO NUMBER: " + this.ioNumber);
        try {
            this.running = true;
            switch (this.type) {
                case 0: {
                    this.value = jnioros.getRegistryString(this.key, "");
                    break;
                }
                case 1: {
                    this.prevValue = jnioros.getInputCounter(this.ioNumber);
                    break;
                }
                case 4: {
                    this.prevValue = jnioros.getUsageMeter(this.ioNumber);
                    break;
                }
                case 3: {
                    this.prevValue = this.getIOFromNumber(this.ioNumber);
                    break;
                }
                case 5: 
                case 6: {
                    this.prevValue = this.getIOFromNumber(this.ioNumber);
                }
            }
            while (this.running) {
                switch (this.type) {
                    case 0: {
                        stringTemp = EmbeddedBase.BASE.m_jnioros.getRegistryString(this.key, "");
                        if (stringTemp.equals(this.value)) break;
                        this.fireWatcherEvent();
                        this.value = stringTemp;
                        break;
                    }
                    case 1: {
                        long intTemp = EmbeddedBase.BASE.m_jnioros.getInputCounter(this.ioNumber);
                        if (this.prevValue != intTemp && this.prevValue < (long)this.setPoint && intTemp >= (long)this.setPoint) {
                            this.fireWatcherEvent();
                        }
                        this.prevValue = intTemp;
                        break;
                    }
                    case 4: {
                        long intTemp = EmbeddedBase.BASE.m_jnioros.getUsageMeter(this.ioNumber);
                        if (this.prevValue != intTemp && this.prevValue < (long)this.setPoint && intTemp >= (long)this.setPoint) {
                            this.fireWatcherEvent();
                        }
                        this.prevValue = intTemp;
                        break;
                    }
                    case 3: {
                        long intTemp = this.getIOFromNumber(this.ioNumber);
                        if (this.prevValue != intTemp) {
                            System.out.println("State Changed");
                            if (intTemp != 0L && this.setPoint != 2) {
                                this.fireWatcherEvent();
                            } else if (intTemp == 0L && this.setPoint != 1) {
                                this.fireWatcherEvent();
                            }
                        }
                        this.prevValue = intTemp;
                        break;
                    }
                    case 5: {
                        long intTemp = this.getIOFromNumber(this.ioNumber);
                        if (intTemp != this.prevValue) {
                            if (intTemp >= (long)this.setPoint && this.prevValue < (long)this.setPoint && this.reset) {
                                this.fireWatcherEvent();
                                this.reset = false;
                            } else if (intTemp < (long)this.event.miscNumber) {
                                this.reset = true;
                            }
                        }
                        this.prevValue = intTemp;
                        break;
                    }
                    case 6: {
                        long intTemp = this.getIOFromNumber(this.ioNumber);
                        if (intTemp != this.prevValue) {
                            if (intTemp < (long)this.setPoint && this.prevValue >= (long)this.setPoint && this.reset) {
                                this.fireWatcherEvent();
                                this.reset = false;
                            } else if (intTemp >= (long)this.event.miscNumber) {
                                this.reset = true;
                            }
                        }
                        this.prevValue = intTemp;
                    }
                }
                try {
                    Thread.sleep(250L);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
        System.out.println("Stopping watcher for " + this.event.name);
    }

    private void fireWatcherEvent() {
        long dayTime = TaskManager.getDayTime();
        if ((this.event.endTime == -1L || this.event.endTime > dayTime) && this.event.time < dayTime && this.listener != null && this.event != null) {
            this.listener.WatcherTriggered(new WatcherEvent(this, this.event.name));
        }
    }

    @Override
    public void ioStateChange(int io, byte channel, byte state, long inputStatesMask, long outputsStatesMask) {
        System.out.println("State Changed " + this.prevValue + " " + state);
        if (this.prevValue != (long)state) {
            System.out.println("State Changed");
            if (this.setPoint == 3) {
                this.fireWatcherEvent();
            } else if (state == 1 && this.setPoint == 1) {
                this.fireWatcherEvent();
            } else if (state == 0 && this.setPoint == 2) {
                this.fireWatcherEvent();
            }
        }
        this.prevValue = state;
    }
}

