/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers.Base;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.EmbeddedHelpers.Base.RegistryModifiedListener;
import integpg.JniorOS;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ConfigBase
implements Runnable {
    private static final String EMPTY_STRING = "";
    private Thread thd;
    private boolean quit = false;
    private Hashtable subscribedKeys;
    private Vector _listeners = new Vector();
    private boolean _paused = false;

    public abstract void getConfig() throws IOException;

    public static String getRegistryKey(String keyName, String defaultValue) {
        JniorOS jnioros = EmbeddedBase.BASE.m_jnioros;
        String value = jnioros.getRegistryString(keyName, EMPTY_STRING);
        if (value.equals(EMPTY_STRING)) {
            value = defaultValue;
            jnioros.setSystemKey(keyName, value);
        }
        return value;
    }

    public static String[] getRegistryKeys(String keyName, String defaultValue) {
        JniorOS jnioros = EmbeddedBase.BASE.m_jnioros;
        String[] value = null;
        try {
            value = jnioros.getRegistryKey(keyName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (value == null || value.length == 0) {
            jnioros.setSystemKey(keyName, defaultValue);
            try {
                value = jnioros.getRegistryKey(keyName);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return value;
    }

    public static boolean getRegistryKey(String keyName, boolean defaultValue) {
        JniorOS jnioros = EmbeddedBase.BASE.m_jnioros;
        boolean value = jnioros.getRegistryBoolean(keyName, defaultValue);
        if (value == defaultValue) {
            jnioros.setSystemKey(keyName, String.valueOf(value));
        }
        return value;
    }

    public static double getRegistryKey(String keyName, double defaultValue) {
        JniorOS jnioros = EmbeddedBase.BASE.m_jnioros;
        double value = jnioros.getRegistryDouble(keyName, Double.MIN_VALUE);
        if (value == Double.MIN_VALUE) {
            value = defaultValue;
            jnioros.setSystemKey(keyName, Double.toString(value));
        }
        return value;
    }

    public static int getRegistryKey(String keyName, int defaultValue) {
        JniorOS jnioros = EmbeddedBase.BASE.m_jnioros;
        int value = jnioros.getRegistryInt(keyName, Integer.MIN_VALUE);
        if (value == Integer.MIN_VALUE) {
            value = defaultValue;
            jnioros.setSystemKey(keyName, Integer.toString(value));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToKey(String key, RegistryModifiedListener listener) {
        JniorOS jnioros = EmbeddedBase.BASE.m_jnioros;
        if (!this._listeners.contains(listener)) {
            this._listeners.addElement(listener);
        }
        long lastModified = jnioros.getRegistryLastModified(key);
        if (this.subscribedKeys == null) {
            this.subscribedKeys = new Hashtable();
        }
        Hashtable hashtable = this.subscribedKeys;
        synchronized (hashtable) {
            this.subscribedKeys.put(key, new Long(lastModified));
        }
        if (this.thd == null) {
            this.thd = new Thread((Runnable)this, "Monitor Registry Subscriptions");
            this.thd.setDaemon(true);
            this.thd.start();
        }
    }

    public void stop() {
        try {
            if (this.thd != null) {
                this.quit = true;
                this.thd.interrupt();
                this.thd.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void pause() {
        this._paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ConfigBase configBase = this;
        synchronized (configBase) {
            this._paused = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JniorOS jnioros = EmbeddedBase.BASE.m_jnioros;
        while (!this.quit) {
            Object object;
            if (this._paused) {
                object = this;
                synchronized (object) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            object = this.subscribedKeys;
            synchronized (object) {
                Enumeration keys = this.subscribedKeys.keys();
                while (keys.hasMoreElements()) {
                    long knownModified;
                    String key = (String)keys.nextElement();
                    long lastModified = jnioros.getRegistryLastModified(key);
                    if (lastModified <= (knownModified = ((Long)this.subscribedKeys.get(key)).longValue())) continue;
                    int listenerCount = this._listeners.size();
                    if (listenerCount > 0) {
                        for (int i = 0; i < listenerCount; ++i) {
                            RegistryModifiedListener listener = (RegistryModifiedListener)this._listeners.elementAt(i);
                            listener.registryModified(key);
                        }
                    }
                    this.subscribedKeys.put(key, new Long(lastModified));
                }
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

