/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Registry;

import JniorProtocol.JniorSession;
import JniorProtocol.Registry.RegistryKey;
import java.util.Hashtable;
import java.util.Vector;

public abstract class RegistryStore {
    private static final boolean DEBUG = false;
    private JniorSession m_session;
    private Hashtable hashUids = new Hashtable();
    private Hashtable hashKeys = new Hashtable();

    public RegistryStore(JniorSession jniorSession) {
        this.m_session = jniorSession;
        this.defineDefaults();
    }

    public void defineDefaults() {
        int n;
        this.addKey(new InternalRegistryKey("IpConfig/DNSTimeout", "0", true));
        this.addKey(new InternalRegistryKey("IpConfig/NTPServer", "clock.isc.org", true));
        this.addKey(new InternalRegistryKey("IpConfig/MTU", "1500", true));
        this.addKey(new InternalRegistryKey("Events/Services", "enabled", true));
        this.addKey(new InternalRegistryKey("Events/OnAlarm", "enabled", true));
        this.addKey(new InternalRegistryKey("Events/OnAlarm1", "enabled", true));
        this.addKey(new InternalRegistryKey("Events/OnAlarm2", "enabled", true));
        this.addKey(new InternalRegistryKey("Events/OnAlarm/Email", "enabled", true));
        this.addKey(new InternalRegistryKey("Events/OnAlarm1/Email", "enabled", true));
        this.addKey(new InternalRegistryKey("Events/OnAlarm2/Email", "enabled", true));
        this.addKey(new InternalRegistryKey("Events/OnUsage", "enabled", true));
        this.addKey(new InternalRegistryKey("Events/OnUsage/Email", "enabled", true));
        this.addKey(new InternalRegistryKey("Events/OnConfig", "enabled", true));
        this.addKey(new InternalRegistryKey("WebServer/Server", "enabled", true));
        this.addKey(new InternalRegistryKey("WebServer/Root", "/www/", true));
        this.addKey(new InternalRegistryKey("WebServer/Index", "index.html", true));
        this.addKey(new InternalRegistryKey("JniorServer/Server", "enabled", true));
        this.addKey(new InternalRegistryKey("JniorServer/Login", "true", true));
        this.addKey(new InternalRegistryKey("ModbusServer/Server", "enabled", true));
        this.addKey(new InternalRegistryKey("ModbusServer/Port", "502", true));
        this.addKey(new InternalRegistryKey("ModbusServer/Login", "true", true));
        this.addKey(new InternalRegistryKey("IO/Log", "disabled", true));
        this.addKey(new InternalRegistryKey("IO/Inputs/Log", "enabled", true));
        for (n = 1; n <= 16; ++n) {
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Desc", "Digital In " + n, true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/OnDesc", "On", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/OffDesc", "Off", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Inversion", "disabled", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Debounce", "200", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Latching", "disabled", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Alarm/Inversion", "disabled", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Alarm/HoldOff", "300000", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Alarm1/HolfOff", "300000", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Alarm2/HoldOff", "300000", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Usage/HoldOff", "300000", true));
            this.addKey(new InternalRegistryKey("IO/Inputs/din" + n + "/Count/Units", "Counts", true));
        }
        this.addKey(new InternalRegistryKey("IO/Outputs/Log", "enabled", true));
        for (n = 1; n <= 16; ++n) {
            this.addKey(new InternalRegistryKey("IO/Outputs/rout" + n + "/Desc", "Relay Out " + n, true));
            this.addKey(new InternalRegistryKey("IO/Outputs/rout" + n + "/ClosedDesc", "Closed", true));
            this.addKey(new InternalRegistryKey("IO/Outputs/rout" + n + "/OpenDesc", "Open", true));
            this.addKey(new InternalRegistryKey("IO/Outputs/rout" + n + "/Usage/HoldOff", "300000", true));
        }
    }

    public RegistryKey addKey(RegistryKey registryKey) {
        if (!this.hashUids.containsKey(new Integer(registryKey.getUid()))) {
            this.hashUids.put(new Integer(registryKey.getUid()), registryKey);
        } else {
            RegistryKey registryKey2 = (RegistryKey)this.hashUids.get(new Integer(registryKey.getUid()));
            if (!registryKey2.getKey().equals(registryKey.getKey())) {
                do {
                    registryKey.incrementUid();
                } while (this.hashUids.containsKey(new Integer(registryKey.getUid())));
                this.hashUids.put(new Integer(registryKey.getUid()), registryKey);
            } else {
                registryKey = registryKey2;
            }
        }
        if (!this.hashKeys.containsKey(registryKey.getKey())) {
            this.hashKeys.put(registryKey.getKey(), registryKey);
        }
        return registryKey;
    }

    public RegistryKey getByUid(int n) {
        RegistryKey registryKey = null;
        if (this.hashUids.containsKey(new Integer(n))) {
            registryKey = (RegistryKey)this.hashUids.get(new Integer(n));
        }
        return registryKey;
    }

    public RegistryKey getByKey(String string) {
        RegistryKey registryKey = null;
        if (this.hashKeys.containsKey(string)) {
            registryKey = (RegistryKey)this.hashKeys.get(string);
        }
        return registryKey;
    }

    public Vector getAll() {
        return new Vector(this.hashUids.values());
    }

    class InternalRegistryKey
    extends RegistryKey {
        public InternalRegistryKey(String string) {
            this(string, "");
        }

        public InternalRegistryKey(String string, String string2) {
            this(string, string2, false);
        }

        public InternalRegistryKey(String string, String string2, boolean bl) {
            this.m_session = RegistryStore.this.m_session;
            this.uid = InternalRegistryKey.getUniqueId(string);
            this.key = string;
            if (bl) {
                this.setDefaultValue(string2);
            } else {
                this.setValue(string2);
            }
        }
    }
}

