/*
 * Decompiled with CFR 0.152.
 */
package integpg;

import com.integpg.system.JANOS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class JniorOS {
    public int[] getVersion() throws IOException {
        return JANOS.getVersionNum();
    }

    public int getSerialNumber() throws IOException {
        return JANOS.getSerialNumber();
    }

    public void syslog(String message) {
        JANOS.syslog((String)message);
    }

    public void sendMail(String sEmailBlock, String sSubject, String sMessage) {
        JANOS.sendMail((String)sEmailBlock, (String)sSubject, (String)sMessage);
    }

    public long getIoSignature() throws IOException {
        return JANOS.getIoSignature();
    }

    public boolean isInputSet(int chan) throws IOException {
        return JANOS.isInputSet((int)chan);
    }

    public boolean isLatching(int chan) throws IOException {
        return JANOS.isLatching((int)chan);
    }

    public boolean isInputLatched(int chan) throws IOException {
        return JANOS.isInputLatched((int)chan);
    }

    public void resetLatchedInput(int chan) throws IOException {
        JANOS.resetLatchedInput((int)chan);
    }

    public boolean isOutputSet(int chan) throws IOException {
        return JANOS.isOutputSet((int)chan);
    }

    public int getInputStates() throws IOException {
        return JANOS.getInputStates();
    }

    public int getOutputStates() throws IOException {
        return JANOS.getOutputStates();
    }

    public void setOutputRelay(int chan, boolean state) throws IOException {
        JANOS.setOutputRelay((int)chan, (boolean)state);
    }

    public boolean setOutputPulsed(int bits, int mask, int milliseconds) throws IOException {
        return JANOS.setOutputPulsed((int)bits, (int)mask, (int)milliseconds);
    }

    public void setOutputStates(int data, int mask) throws IOException {
        JANOS.setOutputStates((int)data, (int)mask);
    }

    public int getInputCounter(int chan) throws IOException {
        return JANOS.getInputCounter((int)chan);
    }

    public void resetInputCounter(int chan) throws IOException {
        JANOS.resetInputCounter((int)chan);
    }

    public void setInputCounter(int chan, int value) throws IOException {
        JANOS.setInputCounter((int)chan, (int)value);
    }

    public long getUsageMeter(int chan) throws IOException {
        return JANOS.getUsageMeter((int)chan);
    }

    public void resetUsageMeter(int chan) throws IOException {
        JANOS.resetUsageMeter((int)chan);
    }

    public double getRtdIn(int chan) throws IOException {
        return JANOS.getRtdIn((int)chan);
    }

    public void set10vOut(int chan, double value) throws IOException {
        JANOS.set10vOut((int)chan, (double)value);
    }

    public double get10vIn(int chan) throws IOException {
        return JANOS.get10vIn((int)chan);
    }

    public double get10vOut(int chan) throws IOException {
        return JANOS.get10vOut((int)chan);
    }

    public void set420Out(int chan, double value) throws IOException {
        JANOS.set420Out((int)chan, (double)value);
    }

    public double get420In(int chan) throws IOException {
        return JANOS.get420In((int)chan);
    }

    public double get420Out(int chan) throws IOException {
        return JANOS.get420Out((int)chan);
    }

    public double getTemp(int chan) throws IOException, Exception {
        return JANOS.getTemp((int)chan);
    }

    public String getRegistryString(String key, String sDefault) {
        return JANOS.getRegistryString((String)key, (String)sDefault);
    }

    public String[] getRegistryKey(String key) throws IOException {
        return JANOS.getRegistryKey((String)key);
    }

    public String[] getRegistryList(String key) throws IOException {
        return JANOS.getRegistryList((String)key);
    }

    public boolean getRegistryBoolean(String key, boolean bDefault) {
        return JANOS.getRegistryBoolean((String)key, (boolean)bDefault);
    }

    public int getRegistryInt(String key, int nDefault) {
        return JANOS.getRegistryInt((String)key, (int)nDefault);
    }

    public double getRegistryDouble(String key, double dDefault) {
        return JANOS.getRegistryDouble((String)key, (double)dDefault);
    }

    public long getRegistryLastModified(String key) {
        return JANOS.getRegistryLastModified((String)key);
    }

    public boolean setRegistryString(String key, String value) throws IOException {
        return JANOS.setRegistryString((String)key, (String)value);
    }

    public void setSystemKey(String key, String value) {
        JANOS.setSystemKey((String)key, (String)value);
    }

    public boolean setRegistryKey(String key, String[] values) throws IOException {
        return JANOS.setRegistryKey((String)key, (String[])values);
    }

    public long[] getExternalDeviceList() throws IOException {
        return JANOS.getExternalDeviceList();
    }

    public long[] getAlarmingDeviceList() throws IOException {
        return JANOS.getAlarmingDeviceList();
    }

    public int getDeviceType(long addr) {
        return (int)(addr & 0xFFL);
    }

    public int[] readAnalogInputs(long addr) throws IOException {
        return JANOS.readAnalogInputs((long)addr);
    }

    public void writeDigPotentiometer(long addr, int pos) throws IOException {
        JANOS.writeDigPotentiometer((long)addr, (int)pos);
    }

    public int readDigPotentiometer(long addr) throws IOException {
        return JANOS.readDigPotentiometer((long)addr);
    }

    public byte[] readDeviceBlock(long addr) throws IOException {
        return JANOS.readDeviceBlock((long)addr);
    }

    public void writeDeviceBlock(long addr, byte[] block) throws IOException {
        JANOS.writeDeviceBlock((long)addr, (byte[])block);
    }

    private void validateVersion(int major, int minor) throws Exception, UnsupportedOperationException {
        throw new UnsupportedOperationException("JANOS does not perform version validation.  Applications are now responsible for OS version validation.");
    }

    public void backupFile(String filename) throws IOException, Exception, UnsupportedOperationException {
        File SysLogFileBak;
        System.out.println("Backing up " + filename);
        File src = new File(filename);
        String modelString = this.getRegistryString("$Model", "");
        System.out.println("Model: " + modelString);
        if (modelString.charAt(0) != '3') {
            this.doFlashLogsBackup(src);
        }
        if ((SysLogFileBak = new File(filename + ".bak")).exists()) {
            SysLogFileBak.delete();
        }
        File SysLogFile = src;
        SysLogFile.renameTo(SysLogFileBak);
    }

    private void doFlashLogsBackup(File bakFile) {
        long start = System.currentTimeMillis();
        try {
            String logPath = "/flash/logs";
            if (!new File(logPath).exists()) {
                new File(logPath).mkdir();
            }
            System.out.println("bak file exists: " + bakFile.exists());
            System.out.println("The file length is " + bakFile.length());
            if (bakFile.exists()) {
                try {
                    File flashBackupFile;
                    int flashFileSize = 262144;
                    int fileSize = 32768;
                    String bakFileName = bakFile.getName();
                    if (bakFileName.startsWith("~")) {
                        bakFileName = bakFileName.substring(1);
                    }
                    if ((flashBackupFile = new File(logPath + "/" + bakFileName)).exists()) {
                        System.out.println("The flash backup file length is " + flashBackupFile.length());
                        if (flashBackupFile.length() > (long)(flashFileSize - fileSize)) {
                            System.out.println("The backup file length is greater than " + (flashFileSize - fileSize));
                            int pos = (int)(flashBackupFile.length() - (long)(flashFileSize - fileSize));
                            System.out.println("The new beginning of file position " + pos);
                            pos = JniorOS.findNewLine(flashBackupFile, pos);
                            System.out.println("The new beginning of file after the first new line is " + pos);
                            int newLen = (int)(flashBackupFile.length() - (long)pos);
                            System.out.println("The new length of the flash backup file is " + pos);
                            File newBackupFile = new File(flashBackupFile.getPath() + ".tmp");
                            System.out.println("Copy the backup file to a tmp backup file");
                            JniorOS.copyfile(flashBackupFile, pos, newBackupFile, 0);
                            System.out.println("The new backup file length is " + newBackupFile.length() + "  " + newLen);
                            flashBackupFile.delete();
                            newBackupFile.renameTo(flashBackupFile);
                            System.out.println("The backup file length is " + flashBackupFile.length());
                        }
                    }
                    JniorOS.copyfile(bakFile, 0, flashBackupFile, (int)flashBackupFile.length());
                }
                catch (Exception ex) {
                    System.err.println("Error adding bak file to rolling flash log for " + bakFile.getName() + ": " + ex.toString());
                }
            }
            bakFile.delete();
        }
        catch (Exception ex) {
            System.err.println("Error backing up " + bakFile.getName() + ": " + ex.toString());
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Flash Backup took " + (double)elapsed / 1000.0 + " seconds");
    }

    private static int findNewLine(File srcFile, int srPos) {
        int pos = srPos;
        try {
            int len;
            RandomAccessFile in = new RandomAccessFile(srcFile, "r");
            in.seek(srPos);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                for (int i = 0; i < len; ++i) {
                    if (buf[i] != 10) continue;
                    return pos + i + 1;
                }
                pos += len;
            }
            in.close();
        }
        catch (Exception ex) {
            System.err.println("Error finding new line in " + srcFile.getPath() + ": " + ex.toString());
        }
        return pos;
    }

    private static RandomAccessFile copyfile(File srcFile, int srPos, File dstFile, int dtPos) {
        try {
            int len;
            System.out.println("Copy " + srcFile + " at " + srPos + " to " + dstFile + " starting at " + dtPos);
            RandomAccessFile in = new RandomAccessFile(srcFile, "r");
            in.seek(srPos);
            RandomAccessFile out = new RandomAccessFile(dstFile, "rw");
            out.seek(dtPos);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            buf = null;
            return out;
        }
        catch (FileNotFoundException ex) {
            System.err.println("Error copying file " + srcFile.getPath() + " to " + dstFile.getPath() + ": " + ex.toString());
        }
        catch (IOException ex) {
            System.err.println("Error copying file " + srcFile.getPath() + " to " + dstFile.getPath() + ": " + ex.toString());
        }
        catch (Exception ex) {
            System.err.println("Error copying file " + srcFile.getPath() + " to " + dstFile.getPath() + ": " + ex.toString());
        }
        return null;
    }
}

