/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager.Watcher;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.TaskManager.Event.Event;
import com.integpg.TaskManager.Event.EventData;
import com.integpg.TaskManager.OneWireEventListener;
import com.integpg.TaskManager.TaskManager;
import com.integpg.TaskManager.externals.ExternalChannelInfo;

public class AnalogWatcher
implements OneWireEventListener {
    public static final int TREND_UP = 0;
    public static final int TREND_DOWN = 1;
    private static final int WAITING_UP = 0;
    private static final int WAITING_DOWN = 1;
    private static final int ALARMED_UP = 2;
    private static final int ALARMED_DOWN = 3;
    private int _state = -1;
    private int _prevState = -1;
    private double _alarmValue;
    private double _resetValue;
    private EventData _eventData;
    private ExternalChannelInfo _externalChannelInfo;
    private boolean _initialLoad = true;

    public AnalogWatcher(EventData ed, int direction) {
        this._eventData = ed;
        this._alarmValue = (double)ed.middleNumber / 1000.0;
        this._resetValue = (double)ed.miscNumber / 1000.0;
        this._state = direction;
    }

    public void setExternalChannelInfo(ExternalChannelInfo externalChannelInfo) {
        this._externalChannelInfo = externalChannelInfo;
    }

    @Override
    public void OneWireChangeEvent() {
        double value = 0.0;
        switch ((int)(this._externalChannelInfo.getAddress() & 0xFFL)) {
            case 16: 
            case 40: {
                double fahrenheit;
                double celcius;
                value = celcius = this._externalChannelInfo.getValue();
                boolean useFahrenheit = EmbeddedBase.BASE.m_jnioros.getRegistryBoolean("OneWire/" + this._externalChannelInfo.getAddressString() + "/Fahrenheit", false);
                if (!useFahrenheit) break;
                value = fahrenheit = celcius * 9.0 / 5.0 + 32.0;
                break;
            }
            case 252: {
                double fahrenheit;
                double celcius;
                value = celcius = this._externalChannelInfo.getValue();
                boolean useFahrenheit = EmbeddedBase.BASE.m_jnioros.getRegistryBoolean("OneWire/" + this._externalChannelInfo.getAddressString() + "/Fahrenheit", false);
                if (!useFahrenheit) break;
                value = fahrenheit = celcius * 9.0 / 5.0 + 32.0;
                break;
            }
            case 253: {
                value = this._externalChannelInfo.getScaledValue();
                break;
            }
            case 254: {
                value = this._externalChannelInfo.getScaledValue();
            }
        }
        switch (this._state) {
            case 0: {
                if (this._state != this._prevState) {
                    System.out.println(this._eventData.name + " - Value is " + value + ", waiting for it to rise above " + this._alarmValue);
                }
                this._prevState = this._state;
                if (!(value > this._alarmValue)) break;
                this._state = 2;
                if (this._initialLoad) break;
                EmbeddedBase.BASE.log(this._eventData.name + " - ALARM!!! Value rised above " + this._alarmValue);
                System.out.println(this._eventData.name + " TRIGGER EVENT!!!");
                this.fireEvent();
                break;
            }
            case 1: {
                if (this._state != this._prevState) {
                    System.out.println(this._eventData.name + " - Value is " + value + ", waiting for it to fall below " + this._alarmValue);
                }
                this._prevState = this._state;
                if (!(value < this._alarmValue)) break;
                this._state = 3;
                if (this._initialLoad) break;
                EmbeddedBase.BASE.log(this._eventData.name + " - ALARM!!! Value fell below " + this._alarmValue);
                System.out.println(this._eventData.name + " TRIGGER EVENT!!!");
                this.fireEvent();
                break;
            }
            case 2: {
                if (this._state != this._prevState) {
                    System.out.println(this._eventData.name + " - Value is " + value + ", waiting for it to fall below " + this._resetValue);
                }
                this._prevState = this._state;
                if (!(value < this._resetValue)) break;
                this._state = 0;
                EmbeddedBase.BASE.log(this._eventData.name + " - RESET!!! Value fell below " + this._resetValue);
                System.out.println(this._eventData.name + " TRIGGER RESET!!!");
                break;
            }
            case 3: {
                if (this._state != this._prevState) {
                    System.out.println(this._eventData.name + " - Value is " + value + ", waiting for it to rise above " + this._resetValue);
                }
                this._prevState = this._state;
                if (!(value > this._resetValue)) break;
                this._state = 1;
                EmbeddedBase.BASE.log(this._eventData.name + " - RESET!!! Value rised above " + this._resetValue);
                System.out.println(this._eventData.name + " TRIGGER RESET!!!");
            }
        }
        this._initialLoad = false;
    }

    private void fireEvent() {
        if (this._initialLoad) {
            return;
        }
        long dayTime = TaskManager.getDayTime();
        if ((this._eventData.endTime == -1L || this._eventData.endTime > dayTime) && this._eventData.time < dayTime) {
            new Event(TaskManager.getInstance()).doEvent(this._eventData);
        }
    }
}

