/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messaging;

import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.messaging.CustomMessageHandler;
import com.integpg.janoslib.messaging.CustomMessageListener;
import com.integpg.janoslib.messaging.MessageLoopTypes;
import com.integpg.janoslib.messaging.RegistryMessageHandler;
import com.integpg.janoslib.messaging.RegistryMessageListener;
import com.integpg.janoslib.messaging.SystemMessageHandler;
import com.integpg.janoslib.messaging.SystemMessageListener;
import com.integpg.janoslib.messaging.websocket.WebSocketPipeHandler;
import com.integpg.janoslib.messaging.websocket.WebSocketPipeListener;
import com.integpg.system.MessagePump;
import com.integpg.system.SystemMsg;

public class MessageLoop {
    private static final MessageLoop INSTANCE = new MessageLoop();
    private static final SystemMessageHandler systemHandler = new SystemMessageHandler();
    private static final RegistryMessageHandler registryHandler = new RegistryMessageHandler();
    private static final WebSocketPipeHandler websocketPipeHandler = new WebSocketPipeHandler();
    private static final CustomMessageHandler customMessageHandler = new CustomMessageHandler();
    private static Thread _thdProducer = null;
    private static Thread _thdConsumer = null;
    private static final MessagePump _messagePump;
    private static Queue _queue;

    public static void addSystemListener(SystemMessageListener listener) {
        systemHandler.addListener(listener);
        MessageLoop.start();
    }

    public static void addRegistryListener(RegistryMessageListener listener) {
        registryHandler.addListener(listener);
        MessageLoop.start();
    }

    public static void addWebsocketPipeListeners(WebSocketPipeListener listener) {
        websocketPipeHandler.addListener(listener);
        MessageLoop.start();
    }

    public static void addCustomMessageListeners(int id, CustomMessageListener listener) {
        customMessageHandler.addListener(id, listener);
        MessageLoop.start();
    }

    private MessageLoop() {
    }

    private static void start() {
        if (null == _queue) {
            _queue = new Queue();
        }
        if (null == _thdProducer) {
            _thdProducer = new Thread(new Runnable(){

                @Override
                public void run() {
                    MessageLoop.producerLoop();
                }
            });
            _thdProducer.setDaemon(true);
            _thdProducer.setName("MessageLoopProducer");
            _thdProducer.start();
        }
        if (null == _thdConsumer) {
            _thdConsumer = new Thread(new Runnable(){

                @Override
                public void run() {
                    MessageLoop.consumerLoop();
                }
            });
            _thdConsumer.setDaemon(true);
            _thdConsumer.setName("MessageLoopConsumer");
            _thdConsumer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void producerLoop() {
        System.out.println("Message pump ready");
        while (true) {
            try {
                while (true) {
                    SystemMsg msg = _messagePump.getMessage();
                    _messagePump.postMessage(msg);
                    Queue queue = _queue;
                    synchronized (queue) {
                        _queue.enqueue(msg);
                        if (_queue.size() > 10) {
                            System.out.println("+ " + _queue.size() + " messages in the queue");
                        }
                        _queue.notifyAll();
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Error processing message pump: " + ex.toString());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void consumerLoop() {
        while (true) {
            try {
                while (true) {
                    SystemMsg msg;
                    Queue queue = _queue;
                    synchronized (queue) {
                        if (_queue.isEmpty()) {
                            _queue.wait();
                        }
                        msg = (SystemMsg)_queue.dequeue();
                        if (_queue.size() >= 10) {
                            System.out.println("- " + _queue.size() + " messages in the queue");
                        }
                    }
                    MessageLoop.processMessage(msg);
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void processMessage(SystemMsg msg) {
        if (systemHandler.shouldHandle(msg)) {
            systemHandler.notifyListeners(msg);
        } else if (registryHandler.shouldHandle(msg)) {
            registryHandler.notifyListeners(msg);
        } else if (websocketPipeHandler.shouldHandle(msg)) {
            websocketPipeHandler.notifyListeners(msg);
        } else if (websocketPipeHandler.shouldHandle(msg)) {
            websocketPipeHandler.notifyListeners(msg);
        } else if (msg.type != 18) {
            if (msg.type >= 1024 && customMessageHandler.shouldHandle(msg)) {
                customMessageHandler.notifyListeners(msg);
            } else if (msg.type < 1024 && msg.type != 16 && msg.type != 2) {
                System.out.println("Unhandled " + MessageLoopTypes.getMessageDescription(msg.type) + " message received");
            }
        }
    }

    public static void postMessage(SystemMsg msg) {
        try {
            _messagePump.postMessage(msg);
        }
        catch (Exception ex) {
            System.out.println("Error posting message: " + ex.toString());
        }
    }

    static {
        _queue = null;
        System.out.println("Initialize Message Pump");
        _messagePump = new MessagePump();
        _messagePump.open();
        MessageLoop.start();
    }
}

