/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.controlstructures;

import com.integ.scripting.ExpressionEngine;
import com.integ.tasker.TextReplacer;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import java.util.Json;

public class SetVariableMethod
extends Action {
    private final String _variable;
    private final String _conditional;
    private final ExpressionEngine _expressionEngine = new ExpressionEngine();

    public SetVariableMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._variable = this._paramsJson.getString("Variable");
        System.out.println("Variable: " + this._variable);
        this._conditional = this._paramsJson.getString("Conditional");
        System.out.println("conditional: " + this._conditional);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        long start = System.currentTimeMillis();
        boolean _debug_ = taskRuntime.Scope.isDebug();
        try {
            if (_debug_) {
                System.out.println("SetVariableMethod.execute()");
            }
            String newConditionalString = TextReplacer.replace(this._conditional, taskRuntime.Scope);
            this._expressionEngine.setDebug(_debug_);
            this._expressionEngine.parse(newConditionalString);
            Object resultObject = this._expressionEngine.execute(taskRuntime.Scope);
            if (_debug_) {
                System.out.println(this._variable + " = " + resultObject);
            }
            taskRuntime.Scope.setVariable(this._variable, resultObject);
        }
        catch (Exception ex) {
            throw new Exception(String.format("Error Setting Variable: %s to %s", this._conditional, this._variable), ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        if (_debug_) {
            System.out.println(String.format("set variable elapsed: %lld", elapsed));
        }
    }
}

