/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.tasks.Scope;
import com.integpg.system.JANOS;

public class RegistryObject
extends AbstractObjectCall {
    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            if (parser.peekToken().checkType(46)) {
                parser.nextToken();
                if (!parser.nextToken().checkType(0)) {
                    throw new UnexpectedTokenException("FIELD OR METHOD NAME", parser.currentToken());
                }
                switch (this._fieldOrMethodName = parser.currentToken().content) {
                    case "read": {
                        this.parseArguments(parser);
                        break;
                    }
                    case "write": {
                        this.parseArguments(parser);
                    }
                }
            } else {
                this._fieldOrMethodName = "read";
                this.parseArguments(parser);
            }
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process registry object", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        boolean _debug_ = scope.isDebug();
        if ("read".equalsIgnoreCase(this._fieldOrMethodName)) {
            String registryKeyName = ((AbstractNode)this._arguments.get(0)).toString();
            if (_debug_) {
                System.out.println(String.format("RegistryObject.evaluate: ( %s )", registryKeyName));
            }
            String keyValue = JANOS.getRegistryString((String)registryKeyName, (String)"");
            if (_debug_) {
                System.out.println(String.format("  registry %s = %s", registryKeyName, keyValue));
            }
            return keyValue;
        }
        if ("write".equalsIgnoreCase(this._fieldOrMethodName)) {
            String registryKeyName = ((AbstractNode)this._arguments.get(0)).toString();
            String registryValue = ((AbstractNode)this._arguments.get(1)).toString();
            if (_debug_) {
                System.out.println(String.format("  registry write %s to %s", registryValue, registryKeyName));
            }
            JANOS.setRegistryString((String)registryKeyName, (String)registryValue);
            return registryValue;
        }
        return null;
    }
}

