/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.TaskManager.externals.ExternalChannelInfo;
import com.integpg.TaskManager.externals.ExternalModuleInfo;
import com.integpg.TaskManager.externals.Type28Info;
import com.integpg.TaskManager.externals.TypeFcInfo;
import com.integpg.TaskManager.externals.TypeFdInfo;
import com.integpg.TaskManager.externals.TypeFeInfo;
import java.util.Hashtable;

public class ExternalModuleFromEventBasedTypeKey {
    public static final int INT_DIN = 0;
    public static final int INT_ROUT = 1;
    public static final int EXT_8TEMP = 2;
    public static final int EXT_12TEMP = 3;
    public static final int EXT_ROUT = 4;
    public static final int EXT_RTD = 5;
    public static final int EXT_10vIN = 6;
    public static final int EXT_10vOUT = 7;
    public static final int EXT_420mAIN = 8;
    public static final int EXT_420mAOUT = 9;
    private static Hashtable<String, ExternalModuleInfo> _deviceHash = new Hashtable();

    public static void clearDeviceHash() {
        _deviceHash.clear();
    }

    public static ExternalChannelInfo getExternalModuleFromIoNumber(int ioNumber) {
        System.out.println("IONumber: " + ioNumber);
        int devtype = (ioNumber - 1) / 8;
        int channel = (ioNumber - 1) % 8 + 1;
        System.out.println("Type: " + devtype + " Channel: " + channel);
        String addressRegKey = null;
        switch (devtype) {
            case 4: {
                break;
            }
            case 5: {
                if (channel <= 4) {
                    addressRegKey = "Externals/DeviceOrder/TypeFC_1";
                    break;
                }
                addressRegKey = "Externals/DeviceOrder/TypeFC_2";
                break;
            }
            case 8: {
                if (channel <= 4) {
                    addressRegKey = "Externals/DeviceOrder/TypeFE_1";
                    break;
                }
                addressRegKey = "Externals/DeviceOrder/TypeFE_2";
                break;
            }
            case 9: {
                if (channel <= 2) {
                    addressRegKey = "Externals/DeviceOrder/TypeFE_1";
                    break;
                }
                addressRegKey = "Externals/DeviceOrder/TypeFE_2";
                break;
            }
            case 6: {
                if (channel <= 4) {
                    addressRegKey = "Externals/DeviceOrder/TypeFD_1";
                    break;
                }
                addressRegKey = "Externals/DeviceOrder/TypeFD_2";
                break;
            }
            case 7: {
                if (channel <= 2) {
                    addressRegKey = "Externals/DeviceOrder/TypeFD_1";
                    break;
                }
                addressRegKey = "Externals/DeviceOrder/TypeFD_2";
                break;
            }
            case 2: {
                addressRegKey = "Externals/DeviceOrder/Type10_" + channel;
                break;
            }
            case 3: {
                addressRegKey = "Externals/DeviceOrder/Type28_" + channel;
            }
        }
        if (null != addressRegKey) {
            String addressString = EmbeddedBase.BASE.m_jnioros.getRegistryString(addressRegKey, "");
            System.out.println(addressRegKey + " = " + addressString);
            ExternalModuleInfo externalModuleInfo = null;
            if (_deviceHash.containsKey(addressString)) {
                System.out.println("get cached module");
                externalModuleInfo = _deviceHash.get(addressString);
            }
            switch (devtype) {
                case 4: {
                    break;
                }
                case 5: {
                    if (null == externalModuleInfo) {
                        externalModuleInfo = new TypeFcInfo(addressString);
                        _deviceHash.put(addressString, externalModuleInfo);
                    }
                    return new ExternalChannelInfo(externalModuleInfo, 0, (channel - 1) % 4 + 1);
                }
                case 8: {
                    if (null == externalModuleInfo) {
                        externalModuleInfo = new TypeFeInfo(addressString);
                        _deviceHash.put(addressString, externalModuleInfo);
                    }
                    return new ExternalChannelInfo(externalModuleInfo, 0, (channel - 1) % 4 + 1);
                }
                case 9: {
                    if (null == externalModuleInfo) {
                        externalModuleInfo = new TypeFeInfo(addressString);
                        _deviceHash.put(addressString, externalModuleInfo);
                    }
                    return new ExternalChannelInfo(externalModuleInfo, 1, (channel - 1) % 2 + 1);
                }
                case 6: {
                    if (null == externalModuleInfo) {
                        externalModuleInfo = new TypeFdInfo(addressString);
                        _deviceHash.put(addressString, externalModuleInfo);
                    }
                    return new ExternalChannelInfo(externalModuleInfo, 0, (channel - 1) % 4 + 1);
                }
                case 7: {
                    if (null == externalModuleInfo) {
                        externalModuleInfo = new TypeFdInfo(addressString);
                        _deviceHash.put(addressString, externalModuleInfo);
                    }
                    return new ExternalChannelInfo(externalModuleInfo, 0, (channel - 1) % 2 + 1);
                }
                case 2: {
                    if (null == externalModuleInfo) {
                        externalModuleInfo = new Type28Info(addressString);
                        _deviceHash.put(addressString, externalModuleInfo);
                    }
                    return new ExternalChannelInfo(externalModuleInfo, 0, (channel - 1) % 1 + 1);
                }
                case 3: {
                    if (null == externalModuleInfo) {
                        externalModuleInfo = new Type28Info(addressString);
                        _deviceHash.put(addressString, externalModuleInfo);
                    }
                    return new ExternalChannelInfo(externalModuleInfo, 0, (channel - 1) % 1 + 1);
                }
            }
        }
        return null;
    }
}

