/*
 * Decompiled with CFR 0.152.
 */
package TaskManagerInterface.Event;

import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Helpers.Masks.DaysMask;
import JniorProtocol.Listeners.RegistryListener;
import JniorProtocol.Registry.Registry;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequest;
import TaskManagerInterface.Event.EventDataListener;
import TaskManagerInterface.TaskManagerPanel;
import java.util.Calendar;
import java.util.EventObject;
import java.util.StringTokenizer;

public class EventData
implements RegistryListener {
    private static final boolean DEBUG = false;
    public static final int EITHER = 3;
    public static final int EVENT_DIN = 1;
    public static final int EVENT_ROUT = 2;
    public static final int FALLING = 2;
    public static final int NONE = 0;
    public static final int RISING = 1;
    public static final int TRANSITION = 1;
    public static final int COUNTER = 2;
    public static final int USAGE = 3;
    public static final int ANALOGUP = 4;
    public static final int ANALOGDOWN = 5;
    public boolean enabled = false;
    public boolean recurring = false;
    public boolean eventBased = false;
    public boolean timeBased = false;
    public boolean logical = false;
    public String _logicalExpression = "";
    public boolean loaded = false;
    public String action;
    private DaysMask daysOfWeek;
    public String endTime;
    public long endTimeMillis;
    public int eventChannel;
    public int eventIo;
    public int index;
    public long interval;
    private EventDataListener listener;
    private TaskManagerPanel main;
    public String name;
    public String startTime;
    public long startTimeMillis;
    public int type;
    public int value;
    public int misc;
    public Object saveLock = new Object();

    public EventData(TaskManagerPanel taskManagerPanel, String string) {
        this.main = taskManagerPanel;
        this.name = string.replaceAll(" ", "");
    }

    public void setListener(EventDataListener eventDataListener) {
        this.listener = eventDataListener;
    }

    public void setDaysMask(int n) {
        this.daysOfWeek = new DaysMask(n);
    }

    public int getDaysMask() {
        if (this.daysOfWeek == null) {
            return 0;
        }
        return this.daysOfWeek.getDaysMask();
    }

    public void get() {
        this.main.m_details.setSubStatusText("Retrieving " + this.name);
        final Registry registry = this.main.m_session.getRegistryInstance();
        final RegistryRequest registryRequest = new RegistryRequest();
        new Thread(new Runnable(){

            @Override
            public void run() {
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/DaysOfWeek"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/Time"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/EndTime"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/Action"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/Recurring"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/Interval"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/Enabled"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/Type"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/EventBasedType"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/Misc"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + EventData.this.name + "/LogicalExpression"));
                registryRequest.addRegistryListener(EventData.this);
                try {
                    registry.subscribeRegistry(registryRequest, true);
                }
                catch (CommandTimeoutException commandTimeoutException) {
                    commandTimeoutException.printStackTrace();
                }
                catch (NotYetConnectedException notYetConnectedException) {
                    notYetConnectedException.printStackTrace();
                }
            }
        }).start();
        while (registryRequest.getPercentReceived() < 100.0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Calendar calendar = Calendar.getInstance();
        boolean bl = this.isValidDay(calendar.get(7));
        if (bl) {
            bl &= this.isInTimeRange(System.currentTimeMillis());
        }
    }

    public synchronized long getTimezoneOffset() {
        Calendar calendar = Calendar.getInstance();
        return -(calendar.get(15) + calendar.get(16));
    }

    public synchronized long getStartOfDay(long l) {
        return l - (l - this.getTimezoneOffset()) % 86400000L;
    }

    public boolean isInTimeRange(long l) {
        boolean bl = false;
        l -= this.getStartOfDay(l);
        if (this.startTimeMillis <= this.endTimeMillis) {
            bl = this.startTimeMillis == this.endTimeMillis || l >= this.startTimeMillis && l <= this.endTimeMillis;
        } else if (this.endTimeMillis < this.startTimeMillis) {
            bl = l <= this.endTimeMillis || l >= this.startTimeMillis;
        }
        return bl;
    }

    public boolean isValidDay(int n) {
        if (this.daysOfWeek == null) {
            return false;
        }
        return (this.daysOfWeek.getDaysMask() & 1 << n % 7 - 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        Object object = this.saveLock;
        synchronized (object) {
            Registry registry = this.main.m_session.getRegistryInstance();
            RegistryRequest registryRequest = new RegistryRequest();
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Name", this.name));
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/DaysOfWeek", Integer.toString(this.daysOfWeek.getDaysMask())));
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Time", this.startTime));
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/EndTime", this.endTime));
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Action", this.action));
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Recurring", Boolean.toString(this.recurring)));
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Interval", Long.toString(this.interval) + " seconds"));
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Enabled", Boolean.toString(this.enabled)));
            if (this.timeBased) {
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Type", "Time"));
            } else if (this.eventBased) {
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Type", "Event"));
            } else if (this.logical) {
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Type", "Logical"));
                registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/LogicalExpression", this._logicalExpression));
            }
            String string = "";
            switch (this.type) {
                case 1: {
                    string = "Transition";
                    break;
                }
                case 2: {
                    string = "Counter";
                    break;
                }
                case 3: {
                    string = "Usage";
                    break;
                }
                case 4: {
                    string = "AnalogUp";
                    break;
                }
                case 5: {
                    string = "AnalogDn";
                }
            }
            string = string + ":" + this.value + ":" + this.eventChannel;
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/EventBasedType", string));
            registryRequest.addKey(registry.getRegKey("Schedule/Events/" + this.name + "/Misc", Integer.toString(this.misc)));
            registryRequest.addKey(registry.getRegKey("Schedule/$ReloadSchedule", "true"));
            registry.writeRegistry(registryRequest, true);
        }
    }

    public void setTime(String string) {
        this.startTimeMillis = this.getTimeFromString(string);
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
        this.fireChange();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private long getTimeFromString(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(":") > 0) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
                int n4 = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    switch (n4) {
                        case 0: {
                            n = Integer.parseInt(string2);
                            break;
                        }
                        case 1: {
                            n2 = Integer.parseInt(string2);
                            break;
                        }
                        case 2: {
                            n3 = Integer.parseInt(string2);
                        }
                    }
                    ++n4;
                }
                continue;
            }
            if (string2.toLowerCase().indexOf("pm") < 0) continue;
            n += 12;
        }
        return n * 3600000 + n2 * 60000 + n3 * 1000;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setEndTime(String string) {
        this.endTimeMillis = this.getTimeFromString(string);
    }

    public void setRecurring(boolean bl) {
        this.recurring = bl;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setInterval(String string) {
        if (string.equals("")) {
            this.interval = 0L;
            return;
        }
        this.interval = Integer.parseInt(string.split(" ")[0]);
        this.interval = string.lastIndexOf("hour") >= 0 ? (this.interval *= 3600000L) : (string.lastIndexOf("min") >= 0 ? (this.interval *= 60000L) : (this.interval *= 1000L));
    }

    public void fireChange() {
        if (this.listener != null) {
            this.listener.dataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRegistryKeyReceived(EventObject eventObject, RegistryKey registryKey) {
        Object object = this.saveLock;
        synchronized (object) {
            block43: {
                if (registryKey.getKey().endsWith("Enabled")) {
                    this.enabled = Boolean.parseBoolean(registryKey.getValue());
                } else if (registryKey.getKey().endsWith("DaysOfWeek")) {
                    try {
                        int n = Integer.parseInt(registryKey.getValue());
                        this.daysOfWeek = new DaysMask(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                } else if (registryKey.getKey().endsWith("EndTime")) {
                    this.setEndTime(registryKey.getValue());
                } else if (registryKey.getKey().endsWith("Time")) {
                    this.setTime(registryKey.getValue());
                } else if (registryKey.getKey().endsWith("Action")) {
                    this.action = registryKey.getValue().replaceAll("\"", "");
                    this.setAction(this.action);
                } else if (registryKey.getKey().endsWith("Recurring")) {
                    this.setRecurring(Boolean.parseBoolean(registryKey.getValue()));
                } else if (registryKey.getKey().endsWith("Interval")) {
                    this.setInterval(registryKey.getValue());
                } else if (registryKey.getKey().endsWith("EventBasedType")) {
                    try {
                        int n = Integer.parseInt(registryKey.getValue().substring(registryKey.getValue().indexOf(58) + 1, registryKey.getValue().lastIndexOf(58)));
                        String string = registryKey.getValue().substring(0, registryKey.getValue().indexOf(58));
                        if (string.endsWith("Transition")) {
                            this.type = 1;
                            this.value = n == 1 ? 1 : (n == 2 ? 2 : 3);
                        } else if (string.endsWith("Counter")) {
                            this.type = 2;
                            this.value = n;
                        } else if (string.endsWith("Usage")) {
                            this.type = 3;
                            this.value = n;
                        } else if (string.endsWith("AnalogUp")) {
                            this.type = 4;
                            this.value = n;
                        } else if (string.endsWith("AnalogDn")) {
                            this.type = 5;
                            this.value = n;
                        } else {
                            this.type = 0;
                        }
                        this.eventChannel = Integer.parseInt(registryKey.getValue().substring(registryKey.getValue().lastIndexOf(58) + 1));
                        if (this.eventChannel > 8) {
                            this.eventIo = 1;
                            break block43;
                        }
                        this.eventIo = 2;
                    }
                    catch (Exception exception) {}
                } else if (registryKey.getKey().endsWith("Type")) {
                    this.eventBased = registryKey.getValue().equals("Event");
                    this.timeBased = registryKey.getValue().equals("Time");
                    this.logical = registryKey.getValue().equals("Logical");
                } else if (registryKey.getKey().endsWith("Misc")) {
                    try {
                        this.misc = Integer.parseInt(registryKey.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (registryKey.getKey().endsWith("LogicalExpression")) {
                    this._logicalExpression = registryKey.getValue();
                } else {
                    System.out.println("Unhandled registry key = " + registryKey);
                }
            }
        }
    }

    @Override
    public void onRegistryListReceived(EventObject eventObject, String string, String[] stringArray) {
    }
}

