/*
 * Decompiled with CFR 0.152.
 */
package com.integ.serialtoethernet;

import com.integ.serialtoethernet.AssemblyInfo;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.comm.SerialPort;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.net.TcpServer;
import com.integpg.janoslib.net.TcpServerEvent;
import com.integpg.janoslib.net.TcpServerListener;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Json;

public class SerialEthernetMain
implements TcpServerListener {
    private static SerialEthernetMain INSTANCE = null;
    private static Json Config = new Json();
    private SerialPort serial;
    private InputStream spin;
    private OutputStream spout;
    private Socket socket;

    public static void main(String[] args) {
        try {
            Application.init(new AssemblyInfo());
            INSTANCE = new SerialEthernetMain();
            INSTANCE.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Unable to init", ex);
            System.exit(-1);
        }
    }

    public void init() throws Exception {
        boolean useActiveConnection;
        AppLog.info("Initializing...");
        try {
            this.loadConfiguration();
        }
        catch (Exception ex) {
            throw new Exception("Error getting configuration");
        }
        boolean bl = useActiveConnection = Config.get("HostAddress") != null && !((String)Config.get("HostAddress")).equalsIgnoreCase("none");
        if (!useActiveConnection) {
            int port = Integer.parseInt((String)Config.get("PortNumber"));
            TcpServer server = new TcpServer("SerialEthernetTcpServer", port);
            server.setTcpServerListener(this);
            server.start();
        }
        Thread thd = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SerialEthernetMain.this.serialPortLoop();
                }
                catch (Exception ex) {
                    AppLog.error("Error listening to serial port", ex);
                }
            }
        });
        thd.setDaemon(true);
        thd.start();
        Thread.sleep(Integer.MAX_VALUE);
    }

    private void loadConfiguration() {
        AppLog.info("Load Configuration...");
        AppLog.info("Get Port Number...");
        int portNumber = RegistryHelper.getRegistryKey("AppData/TCP_to_Serial/Port", 9201);
        Config.put("PortNumber", portNumber);
        AppLog.info("Get Active Host Address...");
        String hostAddress = RegistryHelper.getRegistryKey("AppData/TCP_to_Serial/HostAddress", "none");
        Config.put("HostAddress", (Object)hostAddress);
        AppLog.info("Get Maintain Connection Flag...");
        boolean maintainConnection = RegistryHelper.getRegistryKey("AppData/TCP_to_Serial/MaintainConnection", true);
        Config.put("MaintainConnection", (Object)String.valueOf(maintainConnection));
        Json serialConfig = new Json();
        AppLog.info("Get Serial Port...");
        String serialPortName = RegistryHelper.getRegistryKey("AppData/TCP_to_Serial/SerialPort", "AUX");
        if ("rs232".equalsIgnoreCase(serialPortName)) {
            serialPortName = "COM";
        }
        serialConfig.put("PortName", (Object)serialPortName);
        String serialSection = serialPortName;
        this.migrateRegistrySection(serialSection);
        AppLog.info("Get Baud Rate...");
        int baudRate = RegistryHelper.getRegistryKey(String.format("%sSerial/Baudrate", serialSection), 9600);
        serialConfig.put("BaudRate", baudRate);
        AppLog.info("Get Data Bits...");
        int dataBits = RegistryHelper.getRegistryKey(String.format("%sSerial/Databits", serialSection), 8);
        serialConfig.put("DataBits", dataBits);
        AppLog.info("Get Stop Bits...");
        int stopBits = RegistryHelper.getRegistryKey(String.format("%sSerial/Stopbits", serialSection), 1);
        serialConfig.put("StopBits", stopBits);
        AppLog.info("Get Parity...");
        int parity = RegistryHelper.getRegistryKey(String.format("%sSerial/Parity", serialSection), 0);
        serialConfig.put("Parity", parity);
        Config.put("Serial", (Object)serialConfig);
        AppLog.info("Configuration: " + Config.toString());
    }

    private void migrateRegistrySection(String serialSection) {
        this.moveRegistryKey("AppData/TCP_to_Serial/BaudRate", String.format("%sSerial/Baudrate", serialSection));
        this.moveRegistryKey("AppData/TCP_to_Serial/Databits", String.format("%sSerial/Databits", serialSection));
        this.moveRegistryKey("AppData/TCP_to_Serial/Stopbits", String.format("%sSerial/Stopbits", serialSection));
        this.moveRegistryKey("AppData/TCP_to_Serial/Parity", String.format("%sSerial/Parity", serialSection));
    }

    private void moveRegistryKey(String oldLocation, String newLocation) {
        String keyValue = JANOS.getRegistryString((String)oldLocation, null);
        if (null != keyValue) {
            JANOS.setRegistryString((String)newLocation, (String)keyValue);
            JANOS.setRegistryString((String)oldLocation, (String)"");
        }
    }

    private void serialPortLoop() throws Exception {
        AppLog.info("Open serial port...");
        Json serialConfig = (Json)Config.get("Serial");
        if (serialConfig.getString("PortName").equalsIgnoreCase("AUX")) {
            this.serial = new AUXSerialPort();
        } else if (serialConfig.getString("PortName").equalsIgnoreCase("COM")) {
            this.serial = new COMSerialPort();
        } else {
            throw new Exception("Invalid Serial Port Name");
        }
        this.serial.open();
        int baudRate = Integer.parseInt((String)serialConfig.get("BaudRate"));
        int dataBits = Integer.parseInt((String)serialConfig.get("DataBits"));
        int stopBits = Integer.parseInt((String)serialConfig.get("StopBits"));
        int parity = Integer.parseInt((String)serialConfig.get("Parity"));
        this.serial.setSerialPortParams(baudRate, dataBits, stopBits, parity);
        this.spin = this.serial.getInputStream();
        this.spout = this.serial.getOutputStream();
        boolean maintainConnection = Boolean.valueOf((String)Config.get("MaintainConnection"));
        AppLog.info("Listen for serial data...");
        byte[] inbuf = new byte[1024];
        while (true) {
            int bytesRead;
            if ((bytesRead = this.spin.read(inbuf, 0, inbuf.length)) <= 0) {
                continue;
            }
            try {
                Socket s = this.getSocket();
                if (s == null) continue;
                System.out.println("S > E: " + bytesRead);
                s.getOutputStream().write(inbuf, 0, bytesRead);
                if (maintainConnection) continue;
                System.out.println("Disconnect from " + s.getInetAddress().getHostAddress() + ":" + s.getPort());
                this.closeSocket();
                continue;
            }
            catch (IOException ex) {
                AppLog.error("Error writing to ethernet port", ex);
                this.closeSocket();
                continue;
            }
            break;
        }
    }

    private void ethernetLoop() throws Exception {
        AppLog.info("Listen for ethernet data...");
        byte[] inbuf = new byte[1024];
        while (this.socket != null) {
            int bytesRead = this.socket.getInputStream().read(inbuf, 0, inbuf.length);
            if (bytesRead > 0) {
                if (this.spin == null) continue;
                System.out.println("E > S: " + bytesRead);
                this.spout.write(inbuf, 0, bytesRead);
                this.spout.flush();
                continue;
            }
            if (bytesRead != -1) continue;
            this.closeSocket();
        }
    }

    private Socket getSocket() {
        Socket s = this.socket;
        if (this.socket == null) {
            boolean useActiveConnection;
            boolean bl = useActiveConnection = Config.get("HostAddress") != null && !((String)Config.get("HostAddress")).equalsIgnoreCase("none");
            if (useActiveConnection && s == null) {
                String hostAddress = (String)Config.get("HostAddress");
                int port = Integer.parseInt((String)Config.get("PortNumber"));
                try {
                    System.out.println("Connect to " + hostAddress + ":" + port);
                    s = new Socket(hostAddress, port);
                }
                catch (IOException ex) {
                    AppLog.error("Error connecting to active host", ex);
                }
            }
        }
        this.socket = s;
        return this.socket;
    }

    private void closeSocket() {
        if (this.socket != null) {
            try {
                System.out.println("close socket.");
                this.socket.close();
            }
            catch (IOException ex) {
                AppLog.error("Error closing connection to active host", ex);
            }
            this.socket = null;
        }
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        System.out.println("client connected.");
        this.socket = evt.getSocket();
        try {
            this.ethernetLoop();
        }
        catch (Exception ex) {
            AppLog.error("Error listening to ethernet port", ex);
            this.closeSocket();
        }
    }
}

