/*
 * Decompiled with CFR 0.152.
 */
package integpg.EmbeddedHelpers.Monitor;

import com.integpg.system.JANOS;
import integpg.EmbeddedHelpers.Base.EmbeddedBase;
import integpg.EmbeddedHelpers.Message.MessagePump;
import integpg.EmbeddedHelpers.Monitor.IOStateListener;
import integpg.EmbeddedHelpers.Monitor.IOStateMessagePumpObject;
import java.io.IOException;
import java.util.Vector;

public class IOStateMonitor
implements Runnable {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    private Thread thd;
    private boolean running;
    private IOStateListenerRunner runner;
    private MessagePump msgPump;
    private EmbeddedBase base;
    protected Vector[] inputListeners = null;
    protected Vector[] outputListeners = null;
    protected long savedInputStateMask = 0L;
    protected long savedOutputStateMask = 0L;
    public long inputStateMask = 0L;
    public long outputStateMask = 0L;
    private long inputChangeMask = 0L;
    private long outputChangeMask = 0L;
    private int[] savedCounts = new int[12];
    private int[] deltaCounts = new int[12];
    private long lastIoSignature = 0L;
    private int _scanRate = 500;

    public IOStateMonitor(MessagePump messagePump) {
        this.base = EmbeddedBase.BASE;
        this.msgPump = messagePump;
        this.runner = new IOStateListenerRunner(messagePump);
        String string = "AppData/" + this.base.name.replace(' ', '_') + "/IOMonitorScanRate";
        this._scanRate = JANOS.getRegistryInt((String)string, (int)this._scanRate);
        this.base.printInfo("IO Monitor Scan Rate Set to " + this._scanRate + " milliseconds");
        this.savedInputStateMask = this.inputStateMask = (long)JANOS.getInputStates();
        this.savedOutputStateMask = this.outputStateMask = (long)JANOS.getOutputStates();
        for (int i = 0; i < 12; ++i) {
            this.savedCounts[i] = JANOS.getInputCounter((int)i);
        }
    }

    public void removeStateListener(IOStateListener iOStateListener, int n, int n2) {
        if (n == 0 && --n2 < this.inputListeners.length && this.inputListeners[n2] != null && this.inputListeners[n2].contains(iOStateListener)) {
            this.inputListeners[n2].removeElement(iOStateListener);
        }
        if (n == 1 && n2 < this.outputListeners.length && this.outputListeners[n2] != null && this.outputListeners[n2].contains(iOStateListener)) {
            this.outputListeners[n2].removeElement(iOStateListener);
        }
    }

    public void addStateListener(IOStateListener iOStateListener, int n, int n2) {
        if (n == 0) {
            if (n2 > 12) {
                throw new IllegalArgumentException("Channel Out of Range");
            }
            if (this.inputListeners == null) {
                this.inputListeners = new Vector[12];
            }
            if (this.inputListeners[n2 - 1] == null) {
                this.inputListeners[n2 - 1] = new Vector();
            }
            if (!this.inputListeners[n2 - 1].contains(iOStateListener)) {
                this.inputListeners[n2 - 1].addElement(iOStateListener);
            }
        } else if (n == 1) {
            if (n2 > 16) {
                throw new IllegalArgumentException("Channel Out of Range");
            }
            if (this.outputListeners == null) {
                this.outputListeners = new Vector[16];
            }
            if (this.outputListeners[n2 - 1] == null) {
                this.outputListeners[n2 - 1] = new Vector();
            }
            if (!this.outputListeners[n2 - 1].contains(iOStateListener)) {
                this.outputListeners[n2 - 1].addElement(iOStateListener);
            }
        }
    }

    public void setScanRate(int n) {
        this._scanRate = n;
    }

    public void start() {
        this.runner.start();
        this.thd = new Thread((Runnable)this, "IO State Watcher");
        this.thd.setDaemon(true);
        this.thd.start();
    }

    public void stop() {
        try {
            this.running = false;
            System.out.println("Stopping IO Monitor");
            this.runner.stop();
            if (this.thd != null) {
                this.thd.join();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            EmbeddedBase.BASE.log(interruptedException.toString());
        }
    }

    public void run() {
        this.running = true;
        while (this.running) {
            try {
                long l = JANOS.getIoSignature();
                if (l != this.lastIoSignature) {
                    this.lastIoSignature = l;
                    this.inputChangeMask = this.getInputsChangeMask();
                    this.outputChangeMask = this.getOutputsChangeMask();
                    if (this.inputChangeMask != 0L || this.outputChangeMask != 0L) {
                        this.fireStateChanges();
                    }
                }
                try {
                    Thread.sleep(this._scanRate);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
        }
    }

    public synchronized long getInputsChangeMask() throws IOException {
        this.savedInputStateMask = this.inputStateMask;
        this.inputStateMask = JANOS.getInputStates();
        this.inputChangeMask = this.savedInputStateMask ^ this.inputStateMask;
        for (int i = 0; i < 12; ++i) {
            if ((this.inputChangeMask & (long)(1 << i)) != 0L) continue;
            int n = JANOS.getInputCounter((int)i);
            if (n != this.savedCounts[i] && n != 0) {
                this.inputChangeMask |= (long)(1 << i);
            }
            this.deltaCounts[i] = n - this.savedCounts[i];
            this.savedCounts[i] = n;
        }
        return this.inputChangeMask;
    }

    public synchronized long getOutputsChangeMask() throws IOException {
        this.savedOutputStateMask = this.outputStateMask;
        this.outputStateMask = JANOS.getOutputStates();
        this.outputChangeMask = this.savedOutputStateMask ^ this.outputStateMask;
        return this.outputChangeMask;
    }

    public synchronized void fireStateChanges() {
        IOStateMessagePumpObject iOStateMessagePumpObject;
        int n;
        int n2;
        int n3;
        if (this.inputListeners != null) {
            for (n3 = 0; n3 < 8; ++n3) {
                n2 = n3 + 1;
                if (this.inputListeners[n3] == null || (this.inputChangeMask & (long)(n = 1 << n3)) == 0L) continue;
                if ((this.savedInputStateMask & (long)n) == 0L) {
                    if (this.deltaCounts[n3] > 0) {
                        if ((this.inputStateMask & (long)n) == 0L) {
                            iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 1, this.inputStateMask, this.outputStateMask);
                            this.msgPump.put(iOStateMessagePumpObject);
                            iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 0, this.inputStateMask, this.outputStateMask);
                            this.msgPump.put(iOStateMessagePumpObject);
                            continue;
                        }
                        iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 1, this.inputStateMask, this.outputStateMask);
                        this.msgPump.put(iOStateMessagePumpObject);
                        continue;
                    }
                    iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 1, this.inputStateMask, this.outputStateMask);
                    this.msgPump.put(iOStateMessagePumpObject);
                    continue;
                }
                if (this.deltaCounts[n3] > 0) {
                    if ((this.inputStateMask & (long)n) != 0L) {
                        iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 0, this.inputStateMask, this.outputStateMask);
                        this.msgPump.put(iOStateMessagePumpObject);
                        iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 1, this.inputStateMask, this.outputStateMask);
                        this.msgPump.put(iOStateMessagePumpObject);
                        iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 0, this.inputStateMask, this.outputStateMask);
                        this.msgPump.put(iOStateMessagePumpObject);
                        continue;
                    }
                    iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 0, this.inputStateMask, this.outputStateMask);
                    this.msgPump.put(iOStateMessagePumpObject);
                    iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 1, this.inputStateMask, this.outputStateMask);
                    this.msgPump.put(iOStateMessagePumpObject);
                    continue;
                }
                iOStateMessagePumpObject = new IOStateMessagePumpObject(this.inputListeners[n3], 0, (byte)n2, 0, this.inputStateMask, this.outputStateMask);
                this.msgPump.put(iOStateMessagePumpObject);
            }
        }
        if (this.outputListeners != null) {
            for (n3 = 0; n3 < 16; ++n3) {
                n2 = n3 + 1;
                if (this.outputListeners[n3] == null || (this.outputChangeMask & (long)(n = 1 << n3)) == 0L) continue;
                iOStateMessagePumpObject = new IOStateMessagePumpObject(this.outputListeners[n3], 1, (byte)n2, (byte)(this.outputStateMask >> n3 & 1L), this.inputStateMask, this.outputStateMask);
                this.msgPump.put(iOStateMessagePumpObject);
            }
        }
    }

    private void fireWatcherEvent(Vector vector, int n, byte by, byte by2, long l, long l2) {
        by = (byte)(by - 1);
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            try {
                IOStateListener iOStateListener = (IOStateListener)vector.elementAt(i);
                if (iOStateListener == null) continue;
                iOStateListener.ioStateChange(n, (byte)(by + 1), by2, l, l2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class IOStateListenerRunner
    implements Runnable {
        private MessagePump msgPump = null;
        private Thread thd = null;
        private boolean quit = false;

        public IOStateListenerRunner(MessagePump messagePump) {
            this.msgPump = messagePump;
        }

        public void start() {
            this.thd = new Thread((Runnable)this, "IO State Monitor Runner");
            this.thd.setDaemon(true);
            this.thd.start();
        }

        public void stop() {
            try {
                this.quit = true;
                this.msgPump.stop();
                if (this.thd != null) {
                    this.thd.join();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                EmbeddedBase.BASE.log(interruptedException.toString());
            }
        }

        public void run() {
            this.quit = false;
            while (!this.quit) {
                Object object = this.msgPump.get();
                if (object == null) continue;
                IOStateMessagePumpObject iOStateMessagePumpObject = (IOStateMessagePumpObject)object;
                IOStateMonitor.this.fireWatcherEvent(iOStateMessagePumpObject.listeners, iOStateMessagePumpObject.io, iOStateMessagePumpObject.channel, iOStateMessagePumpObject.state, iOStateMessagePumpObject.inputMask, iOStateMessagePumpObject.outputMask);
            }
        }
    }
}

