/*
 * Decompiled with CFR 0.152.
 */
package com.integ.serialcontrol;

import com.integ.common.iolog.DigitalInputChannelEvent;
import com.integ.common.iolog.DigitalInputsIoLogMonitor;
import com.integ.common.iolog.IoChannelEvent;
import com.integ.common.iolog.IoChannelLogListener;
import com.integ.common.iolog.RelayOutputsIoLogMonitor;
import com.integ.common.logging.AppLog;
import com.integ.common.logging.Logger;
import com.integ.common.logging.RollingFileLog;
import com.integ.common.net.IClient;
import com.integ.common.net.TcpServer;
import com.integ.common.net.TcpServerEvent;
import com.integ.common.net.TcpServerListener;
import com.integ.common.net.UdpConnectionListener;
import com.integ.common.net.UdpServer;
import com.integ.common.system.Application;
import com.integ.serialcontrol.AssemblyInfo;
import com.integ.serialcontrol.Config;
import com.integ.serialcontrol.SerialControlClient;
import com.integ.serialcontrol.UdpControlClient;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.Socket;

public class SerialControlMain
implements IoChannelLogListener {
    private boolean _validConfiguration = false;
    private DigitalInputsIoLogMonitor _digitalInputsIoLogMonitor;
    private RelayOutputsIoLogMonitor _relayOutputsIoLogMonitor;

    public static void main(String[] args) throws Exception {
        Application.init(new AssemblyInfo());
        SerialControlMain serialControlMain = new SerialControlMain();
        serialControlMain.init(args);
        serialControlMain.run();
    }

    public void init(String[] args) throws Exception {
        Config.init();
        this.setUpSerialPort();
        this.setUpTcpServer();
        this.setUpUdpServer();
        this.setIoLogMonitors();
    }

    private void setUpSerialPort() {
        try {
            AUXSerialPort serialPort = null;
            String serialPortName = Config.getSerialPortName();
            if ("aux".equalsIgnoreCase(serialPortName)) {
                serialPort = new AUXSerialPort();
            } else if ("rs232".equalsIgnoreCase(serialPortName) || "com".equalsIgnoreCase(serialPortName)) {
                serialPort = new COMSerialPort();
            }
            if (null != serialPort) {
                AppLog.info(String.format("opening %s serial port", serialPortName));
                serialPort.open();
                Logger serialLog = RollingFileLog.getLogger(String.format("%s_Serial.log", Application.getAppName()));
                SerialControlClient serialControlClient = new SerialControlClient(serialPortName + " port", (InputStream)serialPort.getInputStream(), (OutputStream)serialPort.getOutputStream());
                serialControlClient.setLog(serialLog);
                this._validConfiguration = true;
            } else {
                AppLog.info("serial port not configured to be in use");
            }
        }
        catch (Exception ex) {
            AppLog.error("error opening serial port", ex);
        }
    }

    private void setUpTcpServer() {
        try {
            int tcpServerPortNumber = Config.getTcpServerPortNumber();
            if (-1 != tcpServerPortNumber) {
                TcpServer tcpServer = new TcpServer("SerialControl-TcpServer", tcpServerPortNumber);
                tcpServer.setLog(AppLog.getLog());
                tcpServer.start();
                final Logger tcpServerLog = RollingFileLog.getLogger(String.format("%s_TcpServer.log", Application.getAppName()));
                tcpServer.setTcpServerListener(new TcpServerListener(){

                    @Override
                    public void clientConnected(TcpServerEvent evt) {
                        Socket socket = evt.getSocket();
                        String clientInfo = String.format("%s:%d", socket.getInetAddress().getHostAddress(), socket.getPort());
                        tcpServerLog.info(String.format("%s is connected", clientInfo));
                        try {
                            SerialControlClient serialControlClient = new SerialControlClient(clientInfo, socket.getInputStream(), socket.getOutputStream());
                            serialControlClient.setLog(tcpServerLog);
                        }
                        catch (IOException ex) {
                            tcpServerLog.error(String.format("error setting up ascii command client for %s", clientInfo), ex);
                        }
                    }
                });
                this._validConfiguration = true;
            } else {
                AppLog.info("tcp server not configured to be in use");
            }
        }
        catch (Exception ex) {
            AppLog.error("error setting up tcp server", ex);
        }
    }

    private void setUpUdpServer() {
        try {
            int udpServerPortNumber = Config.getUdpServerPortNumber();
            if (-1 != udpServerPortNumber) {
                UdpServer udpServer = new UdpServer("SerialControl-UdpServer", udpServerPortNumber);
                udpServer.setLog(AppLog.getLog());
                udpServer.start();
                final Logger udpServerLog = RollingFileLog.getLogger(String.format("%s_UdpServer.log", Application.getAppName()));
                udpServer.setListener(new UdpConnectionListener(){

                    @Override
                    public void processMessage(IClient client, DatagramPacket packet, String message) {
                        udpServerLog.info(String.format("%s is connected", client.getSocketInfo()));
                        try {
                            UdpControlClient udpControlClient = new UdpControlClient(client.getSocketInfo());
                            udpControlClient.setLog(udpServerLog);
                            udpControlClient.processMessage(message);
                        }
                        catch (IOException ex) {
                            udpServerLog.error(String.format("error setting up udp command client for %s", client.getSocketInfo()), ex);
                        }
                    }
                });
                this._validConfiguration = true;
            } else {
                AppLog.info("udp server not configured to be in use");
            }
        }
        catch (Exception ex) {
            AppLog.error("error setting up udp server", ex);
        }
    }

    private void setIoLogMonitors() {
        this._digitalInputsIoLogMonitor = new DigitalInputsIoLogMonitor();
        this._digitalInputsIoLogMonitor.addIoChannelLogEventListener(this);
        this._digitalInputsIoLogMonitor.start();
        this._relayOutputsIoLogMonitor = new RelayOutputsIoLogMonitor();
        this._relayOutputsIoLogMonitor.addIoChannelLogEventListener(this);
        this._relayOutputsIoLogMonitor.start();
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        boolean sendUnsolicitedIoAlerts = Config.getSendUnsolicitedIoAlerts();
        if (sendUnsolicitedIoAlerts) {
            String outputString = String.format("%s%d=%d", ioEvent.AbbrTypeString, ioEvent.Channel, ioEvent.State ? 1 : 0);
            if (ioEvent instanceof DigitalInputChannelEvent && Config.getSendCounts()) {
                int counter = JANOS.getInputCounter((int)(ioEvent.Channel - 1));
                outputString = String.format("%s,%d", outputString, counter);
            }
            SerialControlClient.broadcast(outputString, ioEvent.TransitionTime);
        }
    }

    public void run() throws Exception {
        if (this._validConfiguration) {
            Thread.sleep(Integer.MAX_VALUE);
        } else {
            AppLog.warn("there was either not valid configuration or errors occured.  nothing to do, exiting.");
        }
    }
}

