/*
 * Decompiled with CFR 0.152.
 */
package com.integ.serialtoethernet;

import com.integ.serialtoethernet.AssemblyInfo;
import com.integ.serialtoethernet.Config;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.comm.SerialPort;
import com.integpg.comm.SerialPortEvent;
import com.integpg.comm.SerialPortEventListener;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.net.TcpServer;
import com.integpg.janoslib.net.TcpServerEvent;
import com.integpg.janoslib.net.TcpServerListener;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.utils.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SerialEthernetMain
implements TcpServerListener,
SerialPortEventListener {
    private static SerialEthernetMain INSTANCE = null;
    private SerialPort _serial;
    private InputStream spin;
    private OutputStream spout;
    private Socket socket;

    public static void main(String[] args) {
        try {
            Application.init(new AssemblyInfo());
            INSTANCE = new SerialEthernetMain();
            INSTANCE.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Unable to init", ex);
            System.exit(-1);
        }
    }

    public void init() throws Exception {
        FileUtils.moveFile("tcp_to_serial.log", "serialtoethernet.log");
        FileUtils.moveFile("tcp_to_serial.log.bak", "serialtoethernet.log.bak");
        FileUtils.moveFile("tcp_to_serial_boot.log", "serialtoethernet_boot.log");
        FileUtils.moveFile("tcp_to_serial_boot.log.bak", "serialtoethernet_boot.log.bak");
        AppLog.info("Initializing...");
        Config.init();
        if (!Config.useActiveConnection()) {
            int port = Config.getTcpServerPort();
            TcpServer server = new TcpServer("SerialEthernetTcpServer", port);
            server.setTcpServerListener(this);
            server.start();
        }
        Thread thd = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SerialEthernetMain.this.serialPortLoop();
                }
                catch (Exception ex) {
                    AppLog.error("Error getting serial port", ex);
                }
            }
        });
        thd.setDaemon(true);
        thd.start();
        Thread.sleep(Integer.MAX_VALUE);
    }

    private void serialPortLoop() throws Exception {
        AppLog.info("Open serial port...");
        if (Config.getSerialPortName().equalsIgnoreCase("AUX")) {
            this._serial = new AUXSerialPort();
        } else if (Config.getSerialPortName().equalsIgnoreCase("COM")) {
            this._serial = new COMSerialPort();
        } else {
            throw new Exception("Invalid Serial Port Name");
        }
        this._serial.open();
        this._serial.disableReceiveTimeout();
        this._serial.addEventListener((SerialPortEventListener)this);
        this.spin = this._serial.getInputStream();
        this.spout = this._serial.getOutputStream();
        AppLog.info("Listen for serial data...");
        byte[] inbuf = new byte[1024];
        block4: while (true) {
            try {
                while (true) {
                    int bytesRead;
                    if ((bytesRead = this.spin.read(inbuf, 0, inbuf.length)) <= 0) {
                        continue;
                    }
                    try {
                        Socket s = this.getSocket();
                        if (s == null) continue block4;
                        System.out.println("S > E: " + bytesRead);
                        s.getOutputStream().write(inbuf, 0, bytesRead);
                        if (Config.shouldMaintainConnection()) continue block4;
                        System.out.println("Disconnect from " + s.getInetAddress().getHostAddress() + ":" + s.getPort());
                        this.closeSocket();
                        continue block4;
                    }
                    catch (IOException ex) {
                        AppLog.error("Error writing to ethernet connection", ex);
                        this.closeSocket();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                AppLog.error("Error reading from serial port", ex);
                this.closeSocket();
                continue;
            }
            break;
        }
    }

    private void ethernetLoop() throws Exception {
        byte[] inbuf = new byte[1024];
        while (this.socket != null) {
            try {
                int bytesRead = this.socket.getInputStream().read(inbuf, 0, inbuf.length);
                if (bytesRead > 0) {
                    if (this.spin == null) continue;
                    try {
                        System.out.println("E > S: " + bytesRead);
                        if (Config.useRTSLine() && this._serial instanceof AUXSerialPort) {
                            ((AUXSerialPort)this._serial).setRTS(true);
                        }
                        this.spout.write(inbuf, 0, bytesRead);
                        this.spout.flush();
                        if (!Config.useRTSLine() || !(this._serial instanceof AUXSerialPort)) continue;
                        ((AUXSerialPort)this._serial).setRTS(false);
                    }
                    catch (Exception ex) {
                        AppLog.error("error writing to serial port");
                    }
                    continue;
                }
                if (bytesRead != -1) continue;
                this.closeSocket();
            }
            catch (Exception ex) {
                AppLog.error("Error reading from ethernet connection", ex);
                this.closeSocket();
            }
        }
    }

    private Socket getSocket() {
        Socket s = this.socket;
        if (this.socket == null && Config.useActiveConnection() && s == null) {
            String hostAddress = Config.getHostAddress();
            int port = Config.getTcpServerPort();
            try {
                System.out.println("Connect to " + hostAddress + ":" + port);
                s = new Socket(hostAddress, port);
            }
            catch (IOException ex) {
                AppLog.error("Error connecting to active host", ex);
            }
        }
        this.socket = s;
        return this.socket;
    }

    private void closeSocket() {
        if (this.socket != null) {
            String hostInfo = String.format("%s:%d", this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                AppLog.error("Error closing connection to " + hostInfo, ex);
            }
            this.socket = null;
        }
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        this.socket = evt.getSocket();
        String hostInfo = String.format("%s:%d", this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
        AppLog.info(String.format("client connected: %s", hostInfo));
        try {
            this.ethernetLoop();
        }
        catch (Exception ex) {
            AppLog.warn(String.format("client disconnected: %s", hostInfo));
            this.closeSocket();
        }
    }

    public void serialEvent(SerialPortEvent serialportevent) {
        switch (serialportevent.getEventType()) {
            case 1: {
                AppLog.debug("CTS is now " + serialportevent.getNewValue());
            }
        }
    }
}

