/*
 * Decompiled with CFR 0.152.
 */
package com.integ.slaveservice;

import com.integ.slaveservice.JniorConnection;
import com.integ.slaveservice.JniorConnectionListener;
import com.integ.slaveservice.SlaveService;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.system.JANOS;
import java.util.ArrayList;
import java.util.EventObject;

public class RemoteSlaveService
extends SlaveService
implements JniorConnectionListener {
    private final JniorConnection _jniorConnection;

    public RemoteSlaveService(String ipAddress, int port, String username, String password) {
        String name = "remote[" + ipAddress + "]";
        this._log = Logger.getLogger(Application.getAppName() + "_" + name + ".log");
        this._jniorConnection = new JniorConnection();
        this._jniorConnection.setName(name);
        this._jniorConnection.setLog(this._log);
        this._jniorConnection.addConnectionListener(this);
        this._jniorConnection.setIpAddress(ipAddress);
        this._jniorConnection.setPort(port);
        this._jniorConnection.setUserName(username);
        this._jniorConnection.setPassword(password);
    }

    @Override
    public void connectionAttempt(EventObject evt) {
    }

    @Override
    public void connectionEstablished(EventObject evt) {
    }

    @Override
    public void connectionLost(EventObject evt) {
        AppLog.warn(this._jniorConnection.getIPAddress() + " connection lost");
        try {
            int failedOutputStates = this.getFailedOutputStates();
            AppLog.warn("set outputs 0x" + Long.toHexString(this._failedOutputMask) + " to 0x" + Long.toHexString(failedOutputStates));
            JANOS.setOutputStates((int)failedOutputStates, (int)this._failedOutputMask);
        }
        catch (Exception ex) {
            this._log.error(ex);
        }
    }

    @Override
    public void monitorReceived(EventObject evt) {
    }

    @Override
    protected void monitor() {
        if (null == this._monitorThread) {
            AppLog.info("Starting Remote Slave Service for " + this._jniorConnection.getIPAddress());
            this._jniorConnection.start();
            this._monitorThread = new Thread(this);
            this._monitorThread.setDaemon(true);
            this._monitorThread.setName(this.getClass().getName() + ":" + this._jniorConnection.getIPAddress());
            this._monitorThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AppLog.info("Remote Slave Service for " + this._jniorConnection.getIPAddress() + " has started");
        this._running = true;
        while (0 < this._rules.size()) {
            if (this._jniorConnection.getConnectionState()) {
                int usedOutputMask = 0;
                int newOutputs = 0;
                int remoteInputs = this._jniorConnection.getInputStates();
                int remoteOutputs = this._jniorConnection.getOutputStates();
                ArrayList arrayList = this._rules;
                synchronized (arrayList) {
                    for (SlaveService.Rule rule : this._rules) {
                        int state = 0;
                        int remoteChannel = rule.RemoteIoChannel;
                        state = 0 == rule.RemoteIoType ? remoteInputs >> remoteChannel - 1 & 1 : remoteOutputs >> remoteChannel - 1 & 1;
                        if (rule.Invert) {
                            state = (state + 1) % 2;
                        }
                        int localChannel = rule.LocalIoChannel;
                        if (0 == rule.LocalIoType) {
                            JANOS.setInputConditioning((int)(localChannel - 1), (int)(1 == state ? 3 : 2));
                            continue;
                        }
                        usedOutputMask |= 1 << localChannel - 1;
                        newOutputs |= state << localChannel - 1;
                    }
                    try {
                        JANOS.setOutputStates((int)newOutputs, (int)usedOutputMask);
                    }
                    catch (Exception ex) {
                        this._log.error(ex);
                    }
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        AppLog.info("Remote Slave Service for " + this._jniorConnection.getIPAddress() + " has ended");
        this._jniorConnection.close();
    }

    public int getFailedOutputStates() {
        int newOutputs = 0;
        for (int channel = 0; channel < 12; ++channel) {
            if ((this._failedOutputMask >> channel & 1) == 0) continue;
            System.out.println("_failedOutputStrings[" + channel + "]: " + this._failedOutputStrings[channel]);
            int state = "relay-on".equals(this._failedOutputStrings[channel]) ? 1 : 0;
            System.out.println("Failed Output States " + (channel + 1) + "=" + state);
            if (state != 1) continue;
            System.out.println("Output " + channel + "=" + state + "   0x" + Long.toHexString(newOutputs |= 1 << channel));
        }
        return newOutputs;
    }
}

