/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.logging;

import com.integ.common.logging.LogOutputStream;
import com.integ.common.utils.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BakLogOutputStream
extends LogOutputStream {
    public BakLogOutputStream(String filename) throws FileNotFoundException {
        super(filename);
    }

    @Override
    protected int preWrite(byte[] b, int off, int len) throws IOException {
        if ((long)this._maxFileSize < this._file.length() + (long)len) {
            return this.bakFile(b, off, len);
        }
        return 0;
    }

    private int bakFile(byte[] b, int off, int len) throws IOException {
        long start = System.currentTimeMillis();
        int remainingSpace = this._maxFileSize - (int)this._file.length();
        while (0 < remainingSpace--) {
            if (10 != b[remainingSpace]) continue;
            FileUtils.appendBytes(this._file.getPath(), b, off, remainingSpace++);
            break;
        }
        if (this._bakFile.exists()) {
            this._bakFile.delete();
        }
        this._file.renameTo(this._bakFile);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println(String.format("took %lld to create bak file for %s", elapsed, this._file.getPath()));
        return remainingSpace;
    }
}

