/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.modbusserver;

import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.debug.Stopwatch;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.modbusserver.ExternalModuleConfig;
import com.integpg.modbusserver.ModbusServer;
import com.integpg.modbusserver.Utils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import com.integpg.system.Immutable;
import com.integpg.system.JANOS;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ModbusComm
implements Runnable {
    private static final SensorPort SENSOR_PORT = new SensorPort();
    private static byte[] INIT_7E_DATA = new byte[20];
    public Socket theSocket;
    private String _socketInfo;
    private DataInputStream modbusIn;
    private OutputStream modbusOut;
    private int loginID = -1;
    private boolean bLogin;
    private boolean bWaiting;
    private int TransactionID;
    private int ProtocolID;
    private int Length;
    private int UnitID;
    private int FunctionCode;
    private Immutable store = new Immutable();
    private Hashtable mappings;
    private Vector devExternalQueue;
    private byte[] respbufr;
    private byte[] respdata;
    private boolean _quit = false;
    private boolean _notLoggedInLogged = false;
    private Stopwatch _stopwatch = new Stopwatch("ResponseTime");
    private byte[] txbufr;
    private byte gcFlag = 0;

    public ModbusComm(Socket sock) {
        this.store = ModbusServer.store;
        this.theSocket = sock;
        this._socketInfo = this.theSocket.getInetAddress().getHostAddress() + ":" + this.theSocket.getPort();
        this.respbufr = new byte[128];
        this.devExternalQueue = new Vector();
        this.bLogin = RegistryHelper.getRegistryKey("ModbusServer/Login", true);
        this.mappings = new Hashtable(1);
        long[] addresses = new long[]{};
        try {
            addresses = JANOS.getExternalDeviceList();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (addresses.length != 0) {
            for (int deviceIndex = 0; deviceIndex < addresses.length; ++deviceIndex) {
                long address = addresses[deviceIndex];
                String addressString = "0000000000000000" + Long.toHexString(address);
                int storeAddress = ExternalModuleConfig.getModbusAddressForModule(addressString = addressString.substring(addressString.length() - 16));
                if (storeAddress < 0 || storeAddress >= 4096) continue;
                byte[] data = new byte[]{};
                try {
                    data = (address & 0xFFL) == 126L ? this.read7E(address) : JANOS.readDeviceBlock((long)address);
                    System.out.println(HexUtils.bytesToHex(data));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                if (data.length <= 0) continue;
                int nType = (int)(address & 0xFFL);
                MappedDevice map = new MappedDevice();
                map.address = address;
                map.baseAddress = storeAddress;
                map.type = nType;
                int i = 0;
                while (2 * i < data.length) {
                    this.mappings.put(new Integer(storeAddress + i), map);
                    ++i;
                }
            }
        }
    }

    public void close(String reason) throws IOException {
        this._quit = true;
        AppLog.info(this.theSocket.getInetAddress().getHostAddress() + ":" + this.theSocket.getPort() + " " + reason);
        if (ModbusServer.connections.contains(this)) {
            ModbusServer.connections.removeElement(this);
            System.out.println("--- CONNECTIONS: " + ModbusServer.connections.size());
        }
        if (this.modbusIn != null) {
            this.modbusIn.close();
        }
        if (this.modbusOut != null) {
            this.modbusOut.close();
        }
        if (this.theSocket != null) {
            this.theSocket.close();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void ReadCoils1() throws IOException {
        short Count;
        short Address;
        try {
            Address = this.modbusIn.readShort();
            Count = this.modbusIn.readShort();
        }
        catch (IOException ex) {
            throw new IOException("Unable to read Function " + this.FunctionCode);
        }
        if (Count < 1 || Count > 2000) {
            this.sendExceptionResponse(3);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
            return;
        }
        if (Address < 0 || Address > 65535 || Address + Count > 65535) {
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
            this.sendExceptionResponse(2);
            return;
        }
        if (this.QueueBitsExternal(Address, Count)) {
            this.ReadQueuedExternal(true);
        }
        this.respdata = this.bitRead(Address, Count, this.respdata);
        int length = 1 + (Count - 1) / 8;
        if (this.respbufr.length < length) {
            this.respbufr = new byte[length];
        }
        this.respbufr[0] = (byte)length;
        ArrayUtils.arraycopy((Object)this.respdata, (int)0, (Object)this.respbufr, (int)1, (int)length);
        this.sendResponse(this.respbufr, 1 + length);
    }

    private void ReadInputDiscrete2() throws IOException {
        this.ReadCoils1();
    }

    private void ReadMultipleRegisters3() throws IOException {
        this.ReadInputRegister4();
    }

    private synchronized void ReadInputRegister4() throws IOException {
        short Address = this.modbusIn.readShort();
        short Count = this.modbusIn.readShort();
        if (Count < 1 || Count > 125) {
            this.sendExceptionResponse(3);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
            return;
        }
        if (Address < 0 || Address > 4095 || Address + Count > 4095) {
            this.sendExceptionResponse(2);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
            return;
        }
        if (this.QueueWordsExternal(Address, Count)) {
            this.ReadQueuedExternal(true);
        }
        this.respdata = this.wordRead(Address, Count, this.respdata);
        if (this.respbufr.length < 1 + 2 * Count) {
            this.respbufr = new byte[1 + 2 * Count];
        }
        this.respbufr[0] = (byte)(2 * Count);
        ArrayUtils.arraycopy((Object)this.respdata, (int)0, (Object)this.respbufr, (int)1, (int)(2 * Count));
        this.sendResponse(this.respbufr, 1 + 2 * Count);
    }

    private synchronized void WriteSingleCoil5() throws IOException {
        short Address = this.modbusIn.readShort();
        short Value = this.modbusIn.readShort();
        if (Address < 0 || Address > 65535) {
            this.sendExceptionResponse(2);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
            return;
        }
        if (this.QueueBitsExternal(Address, 1)) {
            this.ReadQueuedExternal(false);
        }
        this.bitSet(Address, Value != 0);
        ArrayUtils.setShort((byte[])this.respbufr, (int)0, (short)Address);
        ArrayUtils.setShort((byte[])this.respbufr, (int)2, (short)Value);
        this.sendResponse(this.respbufr, 4);
    }

    private synchronized void WriteSingleRegister6() throws IOException {
        short Address = this.modbusIn.readShort();
        short Value = this.modbusIn.readShort();
        if (Address < 0 || Address > 4095) {
            this.sendExceptionResponse(2);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
            return;
        }
        if (this.QueueWordsExternal(Address, 1)) {
            this.ReadQueuedExternal(false);
        }
        byte[] data = new byte[2];
        ArrayUtils.setShort((byte[])data, (int)0, (short)Value);
        if (this.wordWrite(data, Address)) {
            ArrayUtils.setShort((byte[])this.respbufr, (int)0, (short)Address);
            ArrayUtils.setShort((byte[])this.respbufr, (int)2, (short)Value);
            this.sendResponse(this.respbufr, 4);
        }
    }

    private synchronized void WriteMultipleCoils15() throws IOException {
        short Address = this.modbusIn.readShort();
        short Count = this.modbusIn.readShort();
        int ByteCount = this.modbusIn.readByte();
        if (Count < 1 || Count > 2000 || ByteCount != (Count + 7) / 8) {
            this.sendExceptionResponse(3);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
            return;
        }
        if (Address < 0 || Address > 65535 || Address + Count > 65535) {
            this.sendExceptionResponse(2);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
            return;
        }
        if (this.QueueBitsExternal(Address, Count)) {
            this.ReadQueuedExternal(false);
        }
        byte[] data = new byte[ByteCount];
        for (int i = 0; i < ByteCount; ++i) {
            data[i] = this.modbusIn.readByte();
        }
        this.bitWrite(data, Address, Count);
        ArrayUtils.setShort((byte[])this.respbufr, (int)0, (short)Address);
        ArrayUtils.setShort((byte[])this.respbufr, (int)2, (short)Count);
        this.sendResponse(this.respbufr, 4);
    }

    private synchronized void WriteMultipleRegisters16() throws IOException {
        short Address = this.modbusIn.readShort();
        int Count = this.modbusIn.readShort();
        byte ByteCount = this.modbusIn.readByte();
        if (Count < 1 || Count > 123 || ByteCount != 2 * Count) {
            this.sendExceptionResponse(3);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
            return;
        }
        if (Address < 0 || Address > 4095 || Address + Count > 4095) {
            this.sendExceptionResponse(2);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
            return;
        }
        if (this.QueueWordsExternal(Address, Count)) {
            this.ReadQueuedExternal(false);
        }
        byte[] data = new byte[2 * Count];
        for (int i = 0; i < Count; ++i) {
            short Value = this.modbusIn.readShort();
            ArrayUtils.setShort((byte[])data, (int)(2 * i), (short)Value);
        }
        if (this.wordWrite(data, Address)) {
            ArrayUtils.setShort((byte[])this.respbufr, (int)0, (short)Address);
            ArrayUtils.setShort((byte[])this.respbufr, (int)2, (short)((short)Count));
            this.sendResponse(this.respbufr, 4);
        }
    }

    private synchronized void MaskWriteRegister22() throws IOException {
        short Address = this.modbusIn.readShort();
        short And_Mask = this.modbusIn.readShort();
        short Or_Mask = this.modbusIn.readShort();
        if (Address < 0 || Address > 4095) {
            this.sendExceptionResponse(2);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
            return;
        }
        if (this.QueueWordsExternal(Address, 1)) {
            this.ReadQueuedExternal(false);
        }
        this.respdata = this.wordRead(Address, 1, this.respdata);
        int nData = ArrayUtils.getShort((byte[])this.respdata, (int)0);
        nData = nData & And_Mask | Or_Mask & ~And_Mask;
        ArrayUtils.setShort((byte[])this.respdata, (int)0, (short)((short)nData));
        if (this.wordWrite(this.respdata, Address)) {
            ArrayUtils.setShort((byte[])this.respbufr, (int)0, (short)Address);
            ArrayUtils.setShort((byte[])this.respbufr, (int)2, (short)And_Mask);
            ArrayUtils.setShort((byte[])this.respbufr, (int)4, (short)Or_Mask);
            this.sendResponse(this.respbufr, 6);
        }
    }

    private synchronized void ReadWriteInputRegister23() throws IOException {
        short Address = this.modbusIn.readShort();
        short Count = this.modbusIn.readShort();
        short Address2 = this.modbusIn.readShort();
        int Count2 = this.modbusIn.readShort();
        byte ByteCount = this.modbusIn.readByte();
        if (Count < 1 || Count > 125 || Count2 < 1 || Count2 > 121 || ByteCount != 2 * Count2) {
            this.sendExceptionResponse(3);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
            return;
        }
        if (Address < 0 || Address > 4095 || Address + Count > 4095 || Address2 < 0 || Address2 > 4095 || Address2 + Count2 > 4095) {
            this.sendExceptionResponse(2);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
            return;
        }
        if (this.QueueWordsExternal(Address, Count)) {
            this.ReadQueuedExternal(false);
        }
        if (this.respbufr.length < 1 + 2 * Count) {
            this.respbufr = new byte[1 + 2 * Count];
        }
        this.respbufr[0] = (byte)(2 * Count);
        this.respdata = this.wordRead(Address, Count, this.respdata);
        ArrayUtils.arraycopy((Object)this.respdata, (int)0, (Object)this.respbufr, (int)1, (int)(2 * Count));
        if (this.respdata.length < 2 * Count2) {
            this.respdata = new byte[2 * Count2];
        }
        for (int i = 0; i < Count2; ++i) {
            short Value = this.modbusIn.readShort();
            ArrayUtils.setShort((byte[])this.respdata, (int)(2 * i), (short)Value);
        }
        if (this.wordWrite(this.respdata, Address2)) {
            this.sendResponse(this.respbufr, 1 + 2 * Count);
        }
    }

    private synchronized void ReadDeviceIdentification43() throws IOException {
        int ConformityLevel = 129;
        byte MEItype = this.modbusIn.readByte();
        byte ReadDevice = this.modbusIn.readByte();
        byte Object2 = this.modbusIn.readByte();
        if (MEItype != 14) {
            this.sendExceptionResponse(1);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Wrong MEI Type: " + MEItype);
            return;
        }
        if (Object2 < 0 || Object2 > 2) {
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Object out of range: " + Object2);
            this.sendExceptionResponse(2);
            return;
        }
        if (ReadDevice != 1 && ReadDevice != 4) {
            this.sendExceptionResponse(3);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " ReadDevice out of range: " + ReadDevice);
            return;
        }
        String VendorName = "INTEG process group, inc.";
        String ProductCode = "JNIOR " + JANOS.getRegistryString((String)"$Model", (String)"");
        String Revision = JANOS.getVersion();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(14);
        buffer.write(ReadDevice);
        buffer.write(ConformityLevel);
        buffer.write(0);
        buffer.write(0);
        if (ReadDevice == 1) {
            buffer.write(3 - Object2);
        } else {
            buffer.write(1);
        }
        if (Object2 == 0) {
            buffer.write(0);
            buffer.write(VendorName.length());
            buffer.write(VendorName.getBytes());
        }
        if (ReadDevice == 1 && Object2 <= 1 || ReadDevice == 4 && Object2 == 1) {
            buffer.write(1);
            buffer.write(ProductCode.length());
            buffer.write(ProductCode.getBytes());
        }
        if (ReadDevice == 1 || ReadDevice == 4 && Object2 == 2) {
            buffer.write(2);
            buffer.write(Revision.length());
            buffer.write(Revision.getBytes());
        }
        this.sendResponse(buffer.toByteArray(), buffer.size());
    }

    private synchronized void User_Login100() throws IOException {
        byte ByteCount = this.modbusIn.readByte();
        byte[] data = new byte[ByteCount];
        this.modbusIn.read(data);
        String username = new String(data);
        ByteCount = this.modbusIn.readByte();
        data = new byte[ByteCount];
        this.modbusIn.read(data);
        String password = new String(data);
        if (username.length() == 0 && password.length() > 0) {
            this.loginID = Utils.decodeAuthorization(password);
            username = Utils.decode64(password);
        } else {
            this.loginID = 128;
        }
        if (this.loginID == 255) {
            this.loginID = -1;
        }
        if (this.loginID != -1) {
            AppLog.info(this._socketInfo + " - '" + username + "' Modbus login successful (ID = " + this.loginID + ")");
        } else {
            AppLog.warn(this._socketInfo + " -  '" + username + "' Modbus login failed");
        }
        this.respbufr[0] = (byte)this.loginID;
        this.sendResponse(this.respbufr, 1);
    }

    private synchronized void User_PulseMultipleCoils101() throws IOException {
        int Repeat = this.modbusIn.readShort();
        if (Repeat != 0) {
            for (int n = 0; n < Repeat; ++n) {
                short Address = this.modbusIn.readShort();
                short Count = this.modbusIn.readShort();
                byte ByteCount = this.modbusIn.readByte();
                byte Value = this.modbusIn.readByte();
                int Duration2 = this.modbusIn.readInt();
                if (Count < 1 || Count > 2000 || ByteCount != 1) {
                    this.sendExceptionResponse(3);
                    AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
                    return;
                }
                if (Address < 8 || Address > 15 || Address + Count > 16) {
                    this.sendExceptionResponse(2);
                    AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
                    return;
                }
                int nData = Value << Address - 8;
                int nMask = (1 << Count) - 1 << Address - 8;
                JANOS.setOutputPulsed((int)nData, (int)nMask, (int)Duration2);
            }
        }
        ArrayUtils.setShort((byte[])this.respbufr, (int)0, (short)((short)Repeat));
        this.sendResponse(this.respbufr, 2);
    }

    private synchronized void User_PulseMultipleCoilsMask104() throws IOException {
        int Repeat = this.modbusIn.readShort();
        if (Repeat != 0) {
            for (int n = 0; n < Repeat; ++n) {
                short Address = this.modbusIn.readShort();
                short Count = this.modbusIn.readShort();
                byte ByteCount = this.modbusIn.readByte();
                int Mask = this.modbusIn.readByte();
                byte Value = this.modbusIn.readByte();
                int Duration2 = this.modbusIn.readInt();
                if (Count < 1 || Count > 2000 || ByteCount != 1) {
                    this.sendExceptionResponse(3);
                    AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
                    return;
                }
                if (Address < 8 || Address > 15 || Address + Count > 16) {
                    this.sendExceptionResponse(2);
                    AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
                    return;
                }
                int nData = Value << Address - 8;
                int nMask = (Mask &= (1 << Count) - 1) << Address - 8;
                JANOS.setOutputPulsed((int)nData, (int)nMask, (int)Duration2);
            }
        }
        ArrayUtils.setShort((byte[])this.respbufr, (int)0, (short)((short)Repeat));
        this.sendResponse(this.respbufr, 2);
    }

    private void User_ReadRegistryKeys102() throws IOException {
        int num = 0;
        int Count = this.modbusIn.readShort();
        if (Count < 1) {
            this.sendExceptionResponse(3);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
            return;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(0);
        buffer.write(0);
        for (int n = 0; n < Count; ++n) {
            short uID = this.modbusIn.readShort();
            byte ByteCount = this.modbusIn.readByte();
            if (ByteCount == 0) {
                this.sendExceptionResponse(3);
                return;
            }
            byte[] data = new byte[ByteCount];
            this.modbusIn.read(data);
            String[] settings = JANOS.getRegistryKey((String)new String(data));
            if (settings == null) continue;
            byte[] content = new byte[]{};
            buffer.write(uID >> 8 & 0xFF);
            buffer.write(uID & 0xFF);
            buffer.write(content.length);
            buffer.write(content);
            ++num;
        }
        byte[] response = buffer.toByteArray();
        response[0] = (byte)(num >> 8 & 0xFF);
        response[1] = (byte)(num & 0xFF);
        this.sendResponse(response, response.length);
    }

    private synchronized void User_WriteRegistryKeys103() throws IOException {
        int num = 0;
        int Count = this.modbusIn.readShort();
        if (Count < 1) {
            this.sendExceptionResponse(3);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
            return;
        }
        for (int n = 0; n < Count; ++n) {
            byte ByteCount = this.modbusIn.readByte();
            if (ByteCount == 0) {
                this.sendExceptionResponse(3);
                return;
            }
            byte[] data = new byte[ByteCount];
            this.modbusIn.read(data);
            String key = new String(data);
            ByteCount = this.modbusIn.readByte();
            data = new byte[ByteCount];
            this.modbusIn.read(data);
            String content = new String(data);
            if (!JANOS.setRegistryString((String)key, (String)content)) continue;
            ++num;
        }
        ArrayUtils.setShort((byte[])this.respbufr, (int)0, (short)((short)num));
        this.sendResponse(this.respbufr, 2);
    }

    private synchronized void WriteMultipleCoilsMask105() throws IOException {
        int i;
        short Address = this.modbusIn.readShort();
        short Count = this.modbusIn.readShort();
        int ByteCount = this.modbusIn.readByte();
        if (Count < 1 || Count > 2000 || ByteCount != (Count + 7) / 8) {
            this.sendExceptionResponse(3);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Count out of range: " + Count);
            return;
        }
        if (Address < 0 || Address > 65535 || Address + Count > 65535) {
            this.sendExceptionResponse(2);
            AppLog.warn("Modbus client - Function " + Long.toHexString(this.FunctionCode) + " Address out of range: " + Address);
            return;
        }
        if (this.QueueBitsExternal(Address, Count)) {
            this.ReadQueuedExternal(false);
        }
        byte[] mask = new byte[ByteCount];
        for (i = 0; i < ByteCount; ++i) {
            mask[i] = this.modbusIn.readByte();
        }
        byte[] data = new byte[ByteCount];
        for (i = 0; i < ByteCount; ++i) {
            data[i] = this.modbusIn.readByte();
        }
        this.bitWrite(data, mask, Address, Count);
        ArrayUtils.setShort((byte[])this.respbufr, (int)0, (short)Address);
        ArrayUtils.setShort((byte[])this.respbufr, (int)2, (short)Count);
        this.sendResponse(this.respbufr, 4);
    }

    private synchronized void sendResponse(byte[] data, int length) throws IOException {
        try {
            this._stopwatch.split("send response");
            if (this.txbufr == null || this.txbufr.length < 8 + length) {
                this.txbufr = new byte[8 + length];
            }
            ArrayUtils.setShort((byte[])this.txbufr, (int)0, (short)((short)this.TransactionID));
            ArrayUtils.setShort((byte[])this.txbufr, (int)2, (short)((short)this.ProtocolID));
            ArrayUtils.setShort((byte[])this.txbufr, (int)4, (short)((short)(2 + length)));
            this.txbufr[6] = (byte)this.UnitID;
            this.txbufr[7] = (byte)this.FunctionCode;
            ArrayUtils.arraycopy((Object)data, (int)0, (Object)this.txbufr, (int)8, (int)length);
            this._stopwatch.split("sending response");
            this.modbusOut.write(this.txbufr, 0, 8 + length);
            this.modbusOut.flush();
            this._stopwatch.split("response sent");
        }
        catch (IOException ex) {
            throw new IOException(JANOS.uptimeMillis() + "  " + this.TransactionID + " Unable to send Response");
        }
    }

    public void sendExceptionResponse(int code) throws IOException {
        try {
            byte[] response = new byte[9];
            ArrayUtils.setShort((byte[])response, (int)0, (short)((short)this.TransactionID));
            ArrayUtils.setShort((byte[])response, (int)2, (short)((short)this.ProtocolID));
            ArrayUtils.setShort((byte[])response, (int)4, (short)3);
            response[6] = (byte)this.UnitID;
            response[7] = (byte)(this.FunctionCode | 0x80);
            response[8] = (byte)code;
            this.modbusOut.write(response);
            if (this.modbusIn.skip(this.Length - 2) != (long)(this.Length - 2)) {
                AppLog.warn("We didnt skip all the bytes we wanted to");
            }
        }
        catch (IOException ex) {
            throw new IOException("Unable to send Exception Response");
        }
    }

    public synchronized byte[] bitRead(int address, int count, byte[] data) {
        this._stopwatch.split("bit read");
        int hasfirstbit = address / 16;
        int haslastbit = (address + count - 1) / 16;
        int numwords = haslastbit - hasfirstbit + 1;
        data = this.wordRead(hasfirstbit, numwords, data);
        for (int i = 0; i < data.length; i += 2) {
            byte temp = data[i];
            data[i] = data[i + 1];
            data[i + 1] = temp;
        }
        int rightshift = address & 0xF;
        int offset = rightshift / 8;
        rightshift -= 8 * offset;
        if (offset > 0) {
            ArrayUtils.arraycopy((Object)data, (int)offset, (Object)data, (int)0, (int)(data.length - offset));
        }
        while (rightshift != 0) {
            int cy = 0;
            for (int i = data.length - 1; i >= 0; --i) {
                if ((data[i] & 1) == 0) {
                    data[i] = (byte)((data[i] & 0xFF) >> 1);
                    int n = i;
                    data[n] = (byte)(data[n] | cy);
                    cy = 0;
                    continue;
                }
                data[i] = (byte)((data[i] & 0xFF) >> 1);
                int n = i;
                data[n] = (byte)(data[n] | cy);
                cy = -128;
            }
            --rightshift;
        }
        return data;
    }

    public void bitWrite(byte[] data, int address, int count) throws IOException {
        this._stopwatch.split("bit write");
        for (int i = 0; i < count; ++i) {
            int addr = i / 8;
            boolean state = (data[addr] & 1 << (i & 7)) != 0;
            this.bitSet(address++, state);
        }
    }

    public void bitWrite(byte[] data, byte[] mask, int address, int count) throws IOException {
        this._stopwatch.split("bit write for external");
        for (int i = 0; i < count; ++i) {
            int addr = i / 8;
            int bit = 1 << (i & 7);
            if ((mask[addr] & bit) != 0) {
                this.bitSet(address, (data[addr] & bit) != 0);
            }
            ++address;
        }
    }

    public void bitSet(int address, boolean state) throws IOException {
        if (address >= 8 && address < 16) {
            JANOS.setOutputRelay((int)(address - 8), (boolean)state);
            return;
        }
        if (address >= 1304 && address < 1312) {
            int channel = address - 1296;
            if (state) {
                JANOS.setOutputStates((int)(1 << channel), (int)(1 << channel));
            } else {
                JANOS.setOutputStates((int)0, (int)(1 << channel));
            }
            return;
        }
        int addr = address / 8;
        addr ^= 1;
        int mask = 1 << (address & 7);
        if (state) {
            this.store.write(addr, this.store.read(addr) | mask);
        } else {
            this.store.write(addr, this.store.read(addr) & ~mask);
        }
    }

    public byte[] wordRead(int address, int count, byte[] data) {
        this._stopwatch.split("word read");
        for (int addr = address; addr < address + count; ++addr) {
            int base;
            int i;
            if (addr >= 256) continue;
            if (addr == 0) {
                int status = 0;
                for (i = 0; i < 8; ++i) {
                    if (!JANOS.isLatching((int)i)) {
                        status |= (JANOS.isInputSet((int)i) ? 1 : 0) << i;
                        continue;
                    }
                    status |= (JANOS.isInputLatched((int)i) ? 1 : 0) << i;
                }
                this.store.writeByte(1, (byte)(status & 0xFF));
                this.store.write(0, JANOS.getOutputStates() & 0xFF);
                continue;
            }
            if (addr >= 1 && addr < 17) {
                base = addr - 1;
                if ((base & 1) != 0) continue;
                int counts = JANOS.getInputCounter((int)(base / 2));
                this.store.writeInt(2 * addr, counts);
                continue;
            }
            if (addr >= 17 && addr < 81) {
                base = addr - 17;
                if (base >= 32) {
                    base += 32;
                }
                if ((base & 3) != 0) continue;
                long usage = JANOS.getUsageMeter((int)(base / 4));
                this.store.writeLong(2 * addr, usage);
                continue;
            }
            if (addr == 81) {
                int status = 0;
                for (i = 8; i < 16; ++i) {
                    if (!JANOS.isLatching((int)i)) {
                        status |= (JANOS.isInputSet((int)i) ? 1 : 0) << i - 8;
                        continue;
                    }
                    status |= (JANOS.isInputLatched((int)i) ? 1 : 0) << i - 8;
                }
                this.store.write(163, status & 0);
                this.store.write(162, JANOS.getOutputStates() >> 8 & 0xFF);
                continue;
            }
            if (addr >= 82 && addr < 97) {
                base = addr - 82 + 16;
                if ((base & 1) != 0) continue;
                int counts = JANOS.getInputCounter((int)(base / 2));
                this.store.writeInt(2 * addr, counts);
                continue;
            }
            if (addr < 98 || addr >= 161) continue;
            base = addr - 98 + 32;
            if (base >= 64) {
                base += 32;
            }
            if ((base & 3) != 0) continue;
            long usage = JANOS.getUsageMeter((int)(base / 4));
            this.store.writeLong(2 * addr, usage);
        }
        if (data == null || data.length < 2 * count) {
            data = new byte[2 * count];
        }
        this.store.readBytes(2 * address, data, 0, 2 * count);
        return data;
    }

    public boolean wordWrite(byte[] data, int address) throws IOException {
        this._stopwatch.split("word write");
        this.store.writeBytes(2 * address, data, 0, data.length);
        int count = (data.length + 1) / 2;
        for (int addr = address + count - 1; addr >= address; --addr) {
            int base;
            if (addr >= 256) continue;
            if (addr == 0) {
                JANOS.setOutputStates((int)this.store.read(0), (int)255);
            } else if (addr == 81) {
                int outputstates = this.store.read(162) << 8;
                System.out.println("outputstates 9-16: 0x" + Long.toHexString(outputstates));
                JANOS.setOutputStates((int)outputstates, (int)65280);
            }
            if (addr >= 1 && addr < 17) {
                base = addr - 1;
                if ((base & 1) != 1) continue;
                try {
                    int index = base / 2;
                    if ((1 << index & 0xFF) == 0) {
                        this.sendExceptionResponse(2);
                        return false;
                    }
                    int counts = this.store.readInt(index);
                    JANOS.setInputCounter((int)index, (int)counts);
                }
                catch (IOException ioe) {
                    AppLog.error(ioe.toString());
                }
                continue;
            }
            if (addr >= 17 && addr < 81) {
                base = addr - 17;
                if (base >= 32) {
                    base += 32;
                }
                try {
                    int index = base / 4;
                    if ((1 << index & 0xFF) != 0 || (1 << index - 16 & 0xFF) != 0) {
                        long usage = this.store.readLong(2 * addr);
                        if (usage == 0L) {
                            JANOS.resetUsageMeter((int)index);
                        }
                        continue;
                    }
                    this.sendExceptionResponse(2);
                    return false;
                }
                catch (IOException ioe) {
                    AppLog.error(ioe.toString());
                }
                continue;
            }
            if (addr >= 82 && addr < 97) {
                base = addr - 82 + 32;
                if ((base & 1) != 1) continue;
                try {
                    int index = base / 4;
                    if ((1 << index & 0xFF) == 0) {
                        this.sendExceptionResponse(2);
                        return false;
                    }
                    int counts = this.store.readInt(2 * base);
                    JANOS.setInputCounter((int)index, (int)counts);
                }
                catch (IOException ioe) {
                    AppLog.error(ioe.toString());
                }
                continue;
            }
            if (addr < 98 || addr >= 161) continue;
            base = addr - 98 + 32;
            if (base >= 64) {
                base += 32;
            }
            try {
                int index = base / 4;
                if ((1 << index & 0xFF) != 0 || (1 << index - 16 & 0xFF) != 0) {
                    long usage = this.store.readLong(2 * addr);
                    if (usage == 0L) {
                        JANOS.resetUsageMeter((int)index);
                    }
                    continue;
                }
                this.sendExceptionResponse(2);
                return false;
            }
            catch (IOException ioe) {
                AppLog.error(ioe.toString());
            }
        }
        return true;
    }

    private boolean QueueBitsExternal(int address, int count) {
        boolean status = false;
        for (int addr = address / 16; addr <= address / 16 + count / 16; ++addr) {
            MappedDevice map = (MappedDevice)this.mappings.get(new Integer(addr));
            if (map == null) continue;
            if (!this.devExternalQueue.contains(map)) {
                this.devExternalQueue.addElement(map);
            }
            status = true;
        }
        return status;
    }

    private boolean QueueWordsExternal(int address, int count) {
        boolean status = false;
        for (int addr = address; addr < address + count; ++addr) {
            MappedDevice map = (MappedDevice)this.mappings.get(new Integer(addr));
            if (map == null) continue;
            if (!this.devExternalQueue.contains(map)) {
                this.devExternalQueue.addElement(map);
            }
            status = true;
        }
        return status;
    }

    private void ReadQueuedExternal(boolean clear) throws IOException {
        if (this.devExternalQueue.size() > 0) {
            Enumeration maps = this.devExternalQueue.elements();
            while (maps.hasMoreElements()) {
                MappedDevice map = (MappedDevice)maps.nextElement();
                map.array = (map.address & 0xFFL) == 126L ? this.read7E(map.address) : JANOS.readDeviceBlock((long)map.address);
                if (DEBUG.ON) {
                    System.out.println(HexUtils.bytesToHex(map.array));
                }
                if (map.array.length <= 0 || 2 * map.baseAddress + map.array.length >= this.store.size()) continue;
                this.store.writeBytes(2 * map.baseAddress, map.array, 0, map.array.length);
            }
            if (clear) {
                this.devExternalQueue.removeAllElements();
            }
        }
    }

    private void WriteQueuedExternal() throws IOException {
        if (this.devExternalQueue.size() > 0) {
            Enumeration maps = this.devExternalQueue.elements();
            while (maps.hasMoreElements()) {
                MappedDevice map = (MappedDevice)maps.nextElement();
                switch (map.type) {
                    case 18: {
                        byte[] bufr = new byte[2];
                        this.store.readBytes(2 * map.baseAddress, bufr, 0, bufr.length);
                        JANOS.writeDeviceBlock((long)map.address, (byte[])bufr);
                        break;
                    }
                    case 44: {
                        byte[] bufr = new byte[2];
                        this.store.readBytes(2 * map.baseAddress + 1, bufr, 0, bufr.length);
                        JANOS.writeDeviceBlock((long)map.address, (byte[])bufr);
                        break;
                    }
                    case 251: {
                        byte[] bufr = new byte[10];
                        this.store.readBytes(2 * map.baseAddress, bufr, 0, bufr.length);
                        JANOS.writeDeviceBlock((long)map.address, (byte[])bufr);
                        break;
                    }
                    case 253: 
                    case 254: {
                        byte[] bufr = new byte[4];
                        this.store.readBytes(2 * (map.baseAddress + 4), bufr, 0, bufr.length);
                        JANOS.writeDeviceBlock((long)map.address, (byte[])bufr);
                    }
                }
            }
        }
        this.devExternalQueue.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] read7E(long address) {
        int index = 34;
        int len = 20;
        byte[] data = new byte[len + 3];
        data[0] = -16;
        data[1] = (byte)index;
        data[2] = 0;
        ArrayUtils.arraycopy((Object)INIT_7E_DATA, (int)0, (Object)data, (int)3, (int)len);
        SensorPort sensorPort = SENSOR_PORT;
        synchronized (sensorPort) {
            try {
                SENSOR_PORT.open();
                SENSOR_PORT.select(address);
                SENSOR_PORT.data(data, 0, data.length);
                ArrayUtils.arraycopy((Object)data, (int)3, (Object)data, (int)0, (int)len);
                short s = ArrayUtils.getShort((byte[])data, (int)0);
                s = ArrayUtils.swapEndian((short)s);
                float tempC = (float)((double)s / 16.0);
                float tempF = (float)((double)(tempC * 9.0f) / 5.0 + 32.0);
                s = ArrayUtils.getShort((byte[])data, (int)2);
                s = ArrayUtils.swapEndian((short)s);
                float humidity = (float)((double)s / 16.0);
                ArrayUtils.setInt((byte[])data, (int)0, (int)Float.floatToIntBits(tempC));
                ArrayUtils.setInt((byte[])data, (int)4, (int)Float.floatToIntBits(tempF));
                ArrayUtils.setInt((byte[])data, (int)8, (int)Float.floatToIntBits(humidity));
            }
            catch (Exception ex) {
                data = null;
            }
            finally {
                try {
                    SENSOR_PORT.close();
                }
                catch (Exception ex) {}
            }
            return data;
        }
    }

    static {
        for (int n = 0; n < INIT_7E_DATA.length; ++n) {
            ModbusComm.INIT_7E_DATA[n] = -1;
        }
    }

    class MappedDevice {
        public long address;
        public byte[] array;
        int baseAddress;
        int type;

        MappedDevice() {
        }
    }
}

